/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ComputeNode;
import com.mathworks.toolbox.distcomp.control.PortConfig;

public class Node
implements ComputeNode {
    private Integer fBasePort;
    private CommandSet fCommandSet;
    private String fHostname;
    private boolean fLocal;
    private Integer fRemotePort;
    private Integer fServicePort;
    private Integer fPmodePort;

    public Node(String string, Integer n, boolean bl, CommandSet commandSet) {
        this.initialize(string, n, bl, commandSet);
    }

    private void initialize(String string, Integer n, boolean bl, CommandSet commandSet) {
        assert (string != null) : "attempt to set a null hostname";
        assert (n != null && n > 0) : "attempt to set a null invalid base port " + n;
        assert (commandSet != null) : "attempt to set a null commandSet";
        this.fHostname = string;
        this.fBasePort = n;
        String string2 = Integer.toString(this.fBasePort);
        this.fRemotePort = PortConfig.getRemoteCommandPort(string2);
        this.fServicePort = PortConfig.getMinDistcompServiceExportPort(string2);
        this.fPmodePort = PortConfig.getPmodePort(string2);
        this.fLocal = bl;
        this.fCommandSet = commandSet;
    }

    @Override
    public String getHostname() {
        return this.fHostname;
    }

    public Integer getBasePort() {
        return this.fBasePort;
    }

    public Integer getRemotePort() {
        return this.fRemotePort;
    }

    public Integer getServicePort() {
        return this.fServicePort;
    }

    public Integer getPmodePort() {
        return this.fPmodePort;
    }

    public boolean isLocal() {
        return this.fLocal;
    }

    public CommandSet getCommandSet() {
        return this.fCommandSet;
    }
}

