/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceTableModel;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TableModelRowsTargetSource<SI extends ServiceInfo>
extends TargetSource {
    private final ServiceTableModel<SI, ?> fTableModel;
    private final boolean fMustBeRunning;

    public TableModelRowsTargetSource(ServiceTableModel<SI, ?> serviceTableModel) {
        this(serviceTableModel, true);
    }

    public TableModelRowsTargetSource(ServiceTableModel<SI, ?> serviceTableModel, boolean bl) {
        this.fTableModel = serviceTableModel;
        this.fMustBeRunning = bl;
        this.fTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TableModelRowsTargetSource.this.fireTargetsChanges();
            }
        });
    }

    @Override
    public Collection<ServiceInfo> getTargets() {
        return new ArrayList<ServiceInfo>();
    }

    @Override
    protected boolean areTargetsProper() {
        if (!this.fMustBeRunning) {
            return this.fTableModel.getRowCount() > 0;
        }
        for (ServiceInfo serviceInfo : this.fTableModel.getInfoList()) {
            if (serviceInfo.getStatus() != ServiceStatus.RUNNING) continue;
            return true;
        }
        return false;
    }
}

