/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceDetailModel;
import com.mathworks.toolbox.distcomp.admincenter.services.view.HostnameRenderer;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

public class ServiceDetailDisplay {
    private static final Map<ServiceInfo, ServiceDetailDialog<?>> sDetailDialogs = new HashMap();
    private static final List<ServiceDetailDialog<?>> sLastActiveStack = new ArrayList();
    private static final int SPAN_MARGIN = 25;
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(ServiceDetailDisplay.class);
    private static final String VAL_DELIM = ",<br>";
    private static final int CELL_PADDING = 8;
    private static final int PROP_COL_WIDTH = 260;
    private static final int DEFAULT_DIALOG_WIDTH = 520;

    private ServiceDetailDisplay() {
    }

    public static void showServiceDetails(Collection<ServiceInfo> collection, ActionEvent actionEvent) {
        assert (collection != null) : "infoList must not be null.";
        for (ServiceInfo serviceInfo : collection) {
            ServiceDetailDisplay.showServiceDetail(serviceInfo, actionEvent);
        }
    }

    private static <V extends ServiceInfo> void showServiceDetail(V v, ActionEvent actionEvent) {
        ServiceDetailDialog<?> serviceDetailDialog;
        assert (v != null) : "info must not be null.";
        assert (EventQueue.isDispatchThread()) : "Can only be called in the Event Dispatch Thread.";
        ServiceDetailDialog<?> serviceDetailDialog2 = sDetailDialogs.get(v);
        if (serviceDetailDialog2 != null && serviceDetailDialog2.isDisplayable()) {
            serviceDetailDialog2.bringToFront();
            return;
        }
        Frame frame = MJAbstractAction.getFrame((ActionEvent)actionEvent);
        ServiceDetailDialog serviceDetailDialog3 = new ServiceDetailDialog(v, null);
        serviceDetailDialog3.pack();
        serviceDetailDialog3.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                sLastActiveStack.remove(windowEvent.getWindow());
                sLastActiveStack.add((ServiceDetailDialog)((Object)windowEvent.getWindow()));
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                sLastActiveStack.remove(windowEvent.getWindow());
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                sLastActiveStack.remove(windowEvent.getWindow());
            }
        });
        ServiceDetailDialog<?> serviceDetailDialog4 = serviceDetailDialog = sLastActiveStack.isEmpty() ? null : sLastActiveStack.get(sLastActiveStack.size() - 1);
        if (serviceDetailDialog == null) {
            serviceDetailDialog3.setLocationRelativeTo(frame);
        } else {
            Point point = serviceDetailDialog.getLocationOnScreen();
            point.x += 25;
            if (!WindowUtils.isEntirelyOnSingleScreen((Rectangle)new Rectangle(point, serviceDetailDialog3.getSize()))) {
                point.x = 0;
            }
            point.y += 25;
            if (!WindowUtils.isEntirelyOnSingleScreen((Rectangle)new Rectangle(point, serviceDetailDialog3.getSize()))) {
                point.y = 0;
            }
            serviceDetailDialog3.setLocation(point);
        }
        sDetailDialogs.put(v, serviceDetailDialog3);
        serviceDetailDialog3.setVisible(true);
        WindowUtils.ensureOnSingleScreen(serviceDetailDialog3);
    }

    private static String getTitle(ServiceInfo serviceInfo) {
        assert (serviceInfo != null) : "info may not be null.";
        String string = serviceInfo instanceof MDCSServiceInfo ? HostnameRenderer.getDisplayHostname(serviceInfo, true) : (serviceInfo instanceof JobManagerServiceInfo ? serviceInfo.getServiceName() + "@" + HostnameRenderer.getDisplayHostname(serviceInfo) : serviceInfo.getServiceName());
        return sRes.getString("details.title", sRes.getString("details.title.type." + serviceInfo.getClass().getSimpleName(), new Object[0]), string);
    }

    private static class ServiceDetailDialog<V extends ServiceInfo>
    extends MJDialog {
        private final MJButton fCloseButton;
        private final MJScrollPane fScrollPane;

        private ServiceDetailDialog(V v) {
            super((Frame)null, ServiceDetailDisplay.getTitle(v), false);
            this.setDefaultCloseOperation(2);
            StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
            this.fScrollPane = new MJScrollPane(new ServiceDetailPane<V>(v));
            styleGuidePanel.addLine((JComponent)this.fScrollPane, 8);
            this.fCloseButton = new MJButton((Action)new AbstractAction(sRes.getString("details.close", new Object[0]), (ServiceInfo)v){
                final /* synthetic */ ServiceInfo val$info;
                {
                    this.val$info = serviceInfo;
                    super(string);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceDetailDialog.this.dispose();
                    sDetailDialogs.remove(this.val$info);
                }
            });
            this.getRootPane().setDefaultButton((JButton)this.fCloseButton);
            this.setFocusTarget((Component)this.fCloseButton);
            StyleGuidePanel styleGuidePanel2 = new StyleGuidePanel();
            styleGuidePanel2.addLine((JComponent)((Object)styleGuidePanel), 8);
            styleGuidePanel2.addLine((JComponent[][])new JComponent[][]{{null, this.fCloseButton}}, 0, 0);
            this.setContentPane((Container)((Object)styleGuidePanel2));
        }

        public void requestFocus() {
            this.fCloseButton.requestFocus();
        }

        public void pack() {
            super.pack();
            this.setSize(520, this.getHeight());
            this.validate();
            if (this.fScrollPane.getHorizontalScrollBar().isVisible()) {
                this.setSize(this.getWidth(), this.getHeight() + this.fScrollPane.getHorizontalScrollBar().getHeight());
            }
        }

        public void bringToFront() {
            this.setVisible(true);
            super.toFront();
            this.requestFocus();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ServiceDetailDialog.this.isActive()) {
                        ServiceDetailDialog.this.setVisible(false);
                        ServiceDetailDialog.this.setVisible(true);
                    }
                }
            });
        }

        /* synthetic */ ServiceDetailDialog(ServiceInfo serviceInfo, 1 var2_2) {
            this(serviceInfo);
        }
    }

    private static class ServiceDetailPane<V extends ServiceInfo>
    extends StyleGuidePanel {
        ServiceDetailPane(V v) {
            ServiceDetailModel<V> serviceDetailModel = ServiceDetailModel.getModel(v);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<HTML><HEAD><STYLE type=\"text/css\">\n<!-- \n.proptable, .proptable TD, .proptable TH\n{\nfont-family:sans-serif; \nfont-size:12pt; \n}\n-->\n</STYLE></HEAD><BODY><TABLE CLASS=\"proptable\" CELLPADDING=8>");
            for (ServiceDetailModel.Property<V> property : serviceDetailModel.getProperties()) {
                stringBuilder.append("<TR><TD align=\"right\" valign=\"top\" width=\"260\"><b>");
                stringBuilder.append(serviceDetailModel.getPropertyName(property));
                stringBuilder.append("</b></TD><TD valign=\"top\">");
                stringBuilder.append(this.getValueText(serviceDetailModel.getValue(v, property)));
                stringBuilder.append("</TD></TR>");
            }
            stringBuilder.append("</TABLE></BODY></HTML>");
            MJTextPane mJTextPane = new MJTextPane();
            mJTextPane.setContentType("text/html");
            mJTextPane.setOpaque(false);
            mJTextPane.setEditable(false);
            mJTextPane.setText(stringBuilder.toString());
            mJTextPane.getCaret().setVisible(false);
            mJTextPane.setCaretPosition(0);
            this.addLine((JComponent)mJTextPane, 8);
        }

        private String getValueText(Object object) {
            if (object == null) {
                return "";
            }
            Collection<Object> collection = null;
            if (object instanceof Object[]) {
                collection = Arrays.asList((Object[])object);
            } else if (object instanceof Collection) {
                collection = (Collection)object;
            }
            if (collection != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object2 : collection) {
                    if (object2 == null) continue;
                    stringBuilder.append(object2).append(ServiceDetailDisplay.VAL_DELIM);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.delete(stringBuilder.length() - ServiceDetailDisplay.VAL_DELIM.length(), stringBuilder.length());
                }
                return stringBuilder.toString();
            }
            if (object instanceof ServiceDetailModel.UsingMulticast) {
                return sRes.getString("details.jobmanager.using_multicast", new Object[0]);
            }
            return object.toString();
        }
    }
}

