/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ServiceAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceDialog;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;

public class DelistHostsAction
extends ServiceAction {
    public DelistHostsAction(TargetSource targetSource, String string, ResponseHandler responseHandler, ClientMonitor clientMonitor, SubmissionProgressListener submissionProgressListener, SystemErrorHandler systemErrorHandler) {
        super(ResourceStatics.sRes.getString("module.hosts.action.delisthosts"), targetSource, string, new DelistHostsRequestCreator(), responseHandler, clientMonitor, submissionProgressListener, systemErrorHandler);
    }

    private static String getPreferredHostname(ServiceInfo serviceInfo) {
        try {
            return serviceInfo.getMDCSHostName();
        }
        catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
            return serviceInfo.getHostName();
        }
    }

    private static class DelistHostsDialog
    extends ServiceDialog<Object> {
        private static final String HELP = "AC_DELIST_HOSTS";

        protected DelistHostsDialog(Frame frame, Collection<String> collection, Collection<String> collection2) {
            super(frame, ResourceStatics.sRes.getString("services.dialog.delisthosts"), ResourceStatics.sRes.getString("services.dialog.proceed"), HELP, new DelistHostsContent(collection, collection2));
        }

        private static class DelistHostsContent
        extends StyleGuidePanel
        implements ServiceDialog.ServiceDialogContent<Object> {
            private static final int MAX_LIST = 12;

            private DelistHostsContent(Collection<String> collection, Collection<String> collection2) {
                MJLabel mJLabel = new MJLabel(ResourceStatics.sRes.getString("services.dialog.delisthosts.summary"));
                MJLabel mJLabel2 = new MJLabel(MessageFormat.format(ResourceStatics.sRes.getString("services.dialog.delisthosts.selected"), DelistHostsContent.createHostListString(collection)));
                MJLabel mJLabel3 = new MJLabel(MessageFormat.format(ResourceStatics.sRes.getString("services.dialog.delisthosts.additional"), DelistHostsContent.createHostListString(collection2)));
                MJLabel mJLabel4 = new MJLabel(ResourceStatics.sRes.getString("services.dialog.delisthosts.note"));
                MJLabel mJLabel5 = new MJLabel(ResourceStatics.sRes.getString("services.dialog.proceed.question"));
                this.addLine((JComponent)mJLabel);
                this.addLine((JComponent)mJLabel2);
                this.addLine((JComponent)mJLabel3);
                this.addLine((JComponent)mJLabel4);
                this.addLine((JComponent)mJLabel5);
                this.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
            }

            @Override
            public JComponent getComponent() {
                return this;
            }

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public void registerOkayButton(MJButton mJButton) {
            }

            private static String createHostListString(Collection<String> collection) {
                StringBuilder stringBuilder = new StringBuilder("<b>");
                ArrayList<String> arrayList = new ArrayList<String>(collection);
                Collections.sort(arrayList);
                int n = 0;
                for (String string : arrayList) {
                    if (n == 12) {
                        stringBuilder.append(String.format(ResourceStatics.sRes.getString("services.dialog.delisthosts.more"), arrayList.size() - 12 + 1));
                        break;
                    }
                    if (n > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string);
                    ++n;
                }
                stringBuilder.append("</b>");
                return stringBuilder.toString();
            }
        }
    }

    private static class DelistHostsRequestCreator
    implements ActionRequestCreator {
        private static final int UI_WIDTH = 500;
        private static final int UI_HEIGHT = 300;

        private DelistHostsRequestCreator() {
        }

        @Override
        public ActionRequest createActionServiceRequest(ActionEvent actionEvent, final ClientMonitor clientMonitor, TargetSource targetSource, final SystemErrorHandler systemErrorHandler) {
            ServiceInfo serviceInfo2;
            assert (targetSource != null) : "targetSource must not be null.";
            assert (systemErrorHandler != null) : "errorHandler must not be null.";
            assert (actionEvent != null) : "actionEvent must not be null.";
            assert (clientMonitor != null) : "monitor must not be null.";
            HashSet<MDCSServiceInfo> hashSet = new HashSet<MDCSServiceInfo>();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (ServiceInfo serviceInfo2 : targetSource.getTargets()) {
                if (!(serviceInfo2 instanceof MDCSServiceInfo)) continue;
                hashSet.add((MDCSServiceInfo)serviceInfo2);
                hashSet2.add(serviceInfo2.getHostName());
            }
            final Set<String> set = DelistHostsRequestCreator.calculateDelistClosure(hashSet, clientMonitor.getServiceInfo());
            serviceInfo2 = null;
            if (set.size() > hashSet.size()) {
                HashSet<String> hashSet3 = new HashSet<String>(set);
                hashSet3.removeAll(hashSet2);
                DelistHostsDialog delistHostsDialog = new DelistHostsDialog(MJAbstractAction.getFrame((ActionEvent)actionEvent), hashSet2, hashSet3);
                delistHostsDialog.pack();
                delistHostsDialog.setLocationRelativeTo(MJAbstractAction.getFrame((ActionEvent)actionEvent));
                delistHostsDialog.setSize(500, 300);
                delistHostsDialog.setVisible(true);
                if (delistHostsDialog.isCancelled()) {
                    return new ActionRequest(clientMonitor, true, (Collection<ServiceRequest>)((Object)serviceInfo2), systemErrorHandler);
                }
            }
            return new ActionRequest(clientMonitor, false, (Collection)((Object)serviceInfo2), systemErrorHandler){

                @Override
                public void startUpdate() {
                    try {
                        clientMonitor.removeHosts(set);
                    }
                    catch (ServiceRequestException serviceRequestException) {
                        systemErrorHandler.handleError(serviceRequestException);
                    }
                }

                @Override
                public ActionRequest.UpdateAction getUpdateAction() {
                    return ActionRequest.UpdateAction.REMOVE_HOSTS;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private static Set<String> calculateDelistClosure(Collection<MDCSServiceInfo> collection, Collection<ServiceInfo> collection2) {
            HashSet<ServiceInfo> hashSet;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (MDCSServiceInfo serializable2 : collection) {
                hashMap.put(DelistHostsAction.getPreferredHostname(serializable2), serializable2.getHostName());
            }
            Object object = new HashSet<ServiceInfo>(collection2);
            Object var4_5 = null;
            do {
                void var4_6;
                if (var4_6 != null) {
                    object = var4_6;
                }
                hashSet = new HashSet<ServiceInfo>();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    ServiceInfo serviceInfo = (ServiceInfo)iterator.next();
                    if (hashMap.containsValue(serviceInfo.getHostName())) continue;
                    boolean bl = true;
                    if (serviceInfo instanceof JobManagerServiceInfo) {
                        object2 = ((JobManagerServiceInfo)serviceInfo).getWorkerHostNames().iterator();
                        while (object2.hasNext()) {
                            String string = (String)object2.next();
                            if (!hashMap.containsKey(string)) continue;
                            hashMap.put(DelistHostsAction.getPreferredHostname(serviceInfo), serviceInfo.getHostName());
                            bl = false;
                            break;
                        }
                    } else if (serviceInfo instanceof WorkerServiceInfo && (hashMap.containsKey(object2 = ((WorkerServiceInfo)serviceInfo).getJobManagerHostName()) || hashMap.containsValue(object2))) {
                        hashMap.put(DelistHostsAction.getPreferredHostname(serviceInfo), serviceInfo.getHostName());
                        bl = false;
                    }
                    if (!bl) continue;
                    hashSet.add(serviceInfo);
                }
            } while (object.size() != hashSet.size());
            return new HashSet<String>(hashMap.values());
        }
    }
}

