/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public final class History<T> {
    private final Set<Session> fSessions;
    private final Truncator<T> fTruncator;
    private static final int sCurrentSerialVersion = 1;

    public History() {
        this(null);
    }

    public History(Truncator<T> truncator) {
        this.fTruncator = truncator == null ? new Truncator<T>(){

            @Override
            public void truncate(History<T> history) {
            }
        } : truncator;
        this.fSessions = new TreeSet<Session>();
    }

    public static <T> History<T> load(Truncator<T> truncator, File file, Serializer<T> serializer) throws IOException {
        History<T> history = new History<T>(truncator);
        super.load(file, serializer);
        return history;
    }

    public static Serializer<String> getStringSerializer() {
        return new Serializer<String>(){

            @Override
            public void serialize(DataOutputStream dataOutputStream, String string) throws IOException {
                dataOutputStream.writeUTF(string);
            }

            @Override
            public String deserialize(DataInputStream dataInputStream) throws IOException {
                return dataInputStream.readUTF();
            }
        };
    }

    public Session createNewSession() {
        return this.createNewSession(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createNewSession(long l) {
        Set<Session> set = this.fSessions;
        synchronized (set) {
            Session session = new Session(l);
            while (System.currentTimeMillis() == session.fStartTime) {
                Thread.yield();
            }
            this.fSessions.add(session);
            this.truncate();
            return session;
        }
    }

    public List<Session> getSessions() {
        return new Vector<Session>(this.fSessions);
    }

    public List<Item> getAllItems() {
        LinkedList<Item> linkedList = new LinkedList<Item>();
        for (Session session : this.getSessions()) {
            linkedList.addAll(session.getItems());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncate() {
        Truncator<T> truncator = this.fTruncator;
        synchronized (truncator) {
            this.fTruncator.truncate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public History<T> removeItems(Iterable<Item> iterable) {
        Set<Session> set = this.fSessions;
        synchronized (set) {
            HashMap hashMap = new HashMap();
            for (Item object : iterable) {
                List list = (List)hashMap.get(object.getSession());
                if (list == null) {
                    list = new LinkedList();
                    hashMap.put(object.getSession(), list);
                }
                list.add(object);
            }
            History<T> history = new History<T>();
            for (List list : hashMap.keySet()) {
                Session session = history.createNewSession(((Session)((Object)list)).getStartTime().getTime());
                for (Item item : (List)hashMap.get(list)) {
                    session.addItem(item.getValue(), item.getCreationTime().getTime());
                    item.delete();
                }
                if (((Session)((Object)list)).getItems().size() != 0) continue;
                this.fSessions.remove(list);
            }
            return history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public History<T> removeSessions(Iterable<Session> iterable) {
        Set<Session> set = this.fSessions;
        synchronized (set) {
            LinkedList<Item> linkedList = new LinkedList<Item>();
            for (Session object : iterable) {
                linkedList.addAll(object.getItems());
            }
            History<T> history = this.removeItems(linkedList);
            for (Session session : iterable) {
                this.fSessions.remove(session);
            }
            return history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, Serializer<T> serializer) throws IOException {
        Set<Session> set = this.fSessions;
        synchronized (set) {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(this.fSessions.size());
            for (Session session : this.fSessions) {
                List<Item> list = session.getItems();
                dataOutputStream.writeLong(session.fStartTime);
                dataOutputStream.writeInt(list.size());
                for (Item item : list) {
                    dataOutputStream.writeLong(item.fCreationTime);
                    serializer.serialize(dataOutputStream, item.getValue());
                }
            }
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file, Serializer<T> serializer) throws IOException {
        Set<Session> set = this.fSessions;
        synchronized (set) {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            int n = dataInputStream.readInt();
            if (n != 1) {
                throw new IllegalArgumentException(file + " has unrecognized serial version " + n);
            }
            int n2 = dataInputStream.readInt();
            for (int i = 0; i < n2; ++i) {
                long l = dataInputStream.readLong();
                int n3 = dataInputStream.readInt();
                Session session = this.createNewSession(l);
                this.fSessions.add(session);
                for (int j = 0; j < n3; ++j) {
                    long l2 = dataInputStream.readLong();
                    T t = serializer.deserialize(dataInputStream);
                    session.addItem(t, l2);
                }
            }
        }
    }

    public final class Session
    implements Comparable<Session> {
        private final List<Item> fItems;
        private final long fStartTime;

        public Session() {
            this(System.currentTimeMillis());
        }

        public Session(long l) {
            this.fStartTime = l;
            this.fItems = new Vector<Item>();
        }

        @Override
        public int compareTo(Session session) {
            if (this.fStartTime == session.fStartTime) {
                return 0;
            }
            return this.fStartTime > session.fStartTime ? 1 : -1;
        }

        public boolean equals(Object object) {
            return this.compareTo((Session)object) == 0;
        }

        public int hashCode() {
            return (int)this.fStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Item> getItems() {
            List<Item> list = this.fItems;
            synchronized (list) {
                return new Vector<Item>(this.fItems);
            }
        }

        public Date getStartTime() {
            return new Date(this.fStartTime);
        }

        public Item addItem(T t) {
            return this.addItem(t, System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item addItem(T t, long l) {
            List<Item> list = this.fItems;
            synchronized (list) {
                Item item = new Item(t, this, l);
                this.fItems.add(item);
                History.this.truncate();
                return item;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeItem(Item item) {
            List<Item> list = this.fItems;
            synchronized (list) {
                this.fItems.remove(item);
                History.this.truncate();
            }
        }
    }

    public final class Item {
        private final T fValue;
        private final long fCreationTime;
        private final Session fSession;

        Item(T t, Session session, long l) {
            this.fValue = t;
            this.fSession = session;
            this.fCreationTime = l;
        }

        public T getValue() {
            return this.fValue;
        }

        public Session getSession() {
            return this.fSession;
        }

        public Date getCreationTime() {
            return new Date(this.fCreationTime);
        }

        public void delete() {
            this.fSession.removeItem(this);
        }

        public String toString() {
            return this.fValue.toString();
        }
    }

    public static interface Serializer<T> {
        public void serialize(DataOutputStream var1, T var2) throws IOException;

        public T deserialize(DataInputStream var1) throws IOException;
    }

    public static interface Truncator<T> {
        public void truncate(History<T> var1);
    }
}

