/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class FormInputUpload
extends Panel
implements ObjectPainter,
TextListener,
Movable,
ActionListener {
    private DocView I;
    private DInputElement OEAB;
    private ObjectBox add;
    private TextField addActionListener = null;
    private Button addTextListener = null;
    private Frame append = null;
    private FileDialog checkAwtTree = null;
    private int dispatchChange = 100;
    private String drawRect;

    FormInputUpload(DocView docView, DElement dElement) {
        this.I = docView;
        this.OEAB = (DInputElement)dElement;
        this.addActionListener = new TextField();
        this.addTextListener = new Button("Browse");
        this.append = new Frame();
        this.checkAwtTree = new FileDialog(this.append);
        this.addTextListener.setBackground(Color.lightGray);
        this.I();
        int n = this.OEAB.getAttributeAsInt("size");
        if (n <= 0) {
            n = 20;
        }
        this.addActionListener.setColumns(n);
        this.setLayout(new BorderLayout());
        this.add((Component)this.addActionListener, "Center");
        this.add((Component)this.addTextListener, "East");
        this.addActionListener.setBackground(Color.white);
        this.addActionListener.setFont(new Font("Monospaced", 0, 12));
        this.enableEvents(28L);
        this.addActionListener.addTextListener(this);
        this.addTextListener.addActionListener(this);
    }

    private void I() {
        String string;
        this.addActionListener.setEditable(!this.OEAB.getReadOnly());
        this.addActionListener.setEnabled(!this.OEAB.getDisabled());
        int n = this.OEAB.getMaxLength();
        if (n != 0) {
            this.dispatchChange = n;
        }
        if ((string = this.OEAB.getValue()) != null && !string.equals(this.addActionListener.getText())) {
            this.addActionListener.setText(string);
        }
        try {
            this.addActionListener.setCaretPosition(string.length());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        String string = this.addActionListener.getText();
        if (string.length() > this.dispatchChange) {
            string = string.substring(0, this.dispatchChange);
            this.addActionListener.setText(string);
            try {
                this.addActionListener.setCaretPosition(this.dispatchChange);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        this.OEAB.setValue(string);
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.I();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.add = objectBox;
        this.I.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.add;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        if (!this.isValid()) {
            this.validate();
        }
        this.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.checkAwtTree.show();
        String string = this.checkAwtTree.getDirectory() + this.checkAwtTree.getFile();
        this.addActionListener.setText(string);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.I.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.OEAB(focusEvent);
        } else if (n == 1005) {
            this.add(focusEvent);
        }
        super.processFocusEvent(focusEvent);
    }

    private void OEAB(FocusEvent focusEvent) {
        if (this.drawRect == null) {
            this.drawRect = this.addActionListener.getText();
        }
    }

    private void add(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String string = this.addActionListener.getText();
        if (!string.equals(this.drawRect)) {
            this.OEAB.dispatchChange();
        }
        this.drawRect = null;
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
    }
}

