/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.FramesetData;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.Emulation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.w3c.dom.events.EventListener;

public abstract class DocPaneXml
extends DocPane {
    private ThePilot OEAB;
    private CSSLayout booleanProperty;
    private boolean clearSelection;
    private int consume;
    public boolean enableTextSelection = Defs.booleanProperty((String)"ice.pilots.html4.enableTextSelection", (boolean)true);
    private boolean containsFixedBoxes = false;

    final void bind(ThePilot thePilot, CSSLayout cSSLayout) {
        this.OEAB = thePilot;
        this.booleanProperty = cSSLayout;
        this.clearSelection = "ie".equals(Emulation.getEmulationMode());
        this.consume = thePilot.getPilotViewport().getDocumentId();
        this.booleanProperty.docPane = this;
    }

    final void do_clear() {
        Viewport viewport = this.OEAB.getPilotViewport();
        if (viewport != null) {
            this.consume = viewport.getDocumentId();
            this.setCursor(0);
            this.reqClear();
        }
    }

    public void revalidate(int n, int n2, int n3, int n4) {
        FramesetData framesetData = this.OEAB.framesetData;
        if (framesetData != null) {
            framesetData.layout(n, n2, n3, n4);
        } else {
            this.setPaneBounds(n, n2, n3, n4);
            this.revalidate();
        }
    }

    protected abstract void setPaneBounds(int var1, int var2, int var3, int var4);

    protected abstract void revalidate();

    protected abstract void init(int var1);

    protected abstract Component getPaneComponent();

    protected abstract ObjectPainter createFormControl(DElement var1);

    protected abstract ObjectPainter createScroller();

    protected abstract Container createEmbeddedContainer(EmbeddedObject var1, Component var2);

    protected abstract Component createFramesDividerComponent();

    protected abstract void checkAwtTree(ObjectBox var1, Component var2);

    protected final boolean processAwtKeyEvent(Component component, KeyEvent keyEvent, EventListener eventListener) {
        int n;
        char c;
        int n2;
        int n3 = keyEvent.getID();
        if (n3 == 401) {
            this.containsFixedBoxes = false;
            n2 = 9;
        } else if (n3 == 402) {
            n2 = 10;
            if (this.containsFixedBoxes && this.is_msie_event_emulation()) {
                return true;
            }
        } else {
            n2 = 8;
            if (this.containsFixedBoxes && this.is_msie_event_emulation()) {
                return true;
            }
        }
        DOMUIEvent dOMUIEvent = null;
        int n4 = keyEvent.getKeyCode();
        if (n3 == 400) {
            c = keyEvent.getKeyChar();
            n = c;
        } else {
            n = n4;
            c = keyEvent.getKeyChar();
        }
        if (this.is_msie_event_emulation()) {
            switch (n4) {
                case 112: {
                    if (n4 != 112) break;
                    dOMUIEvent = this.createDomUIEvent(23);
                    break;
                }
                case 10: {
                    n = 13;
                    break;
                }
                case 127: {
                    n = 46;
                    break;
                }
                case 155: {
                    n = 45;
                }
            }
        }
        DOMUIEvent dOMUIEvent2 = this.createDomUIEvent(n2);
        dOMUIEvent2.setKeyCode(n);
        dOMUIEvent2.setCharCode(c);
        boolean bl = this.uiEvent(dOMUIEvent2, keyEvent, eventListener);
        if (n3 == 401 && dOMUIEvent2.isDefaultCancelled()) {
            this.containsFixedBoxes = true;
        }
        if (!dOMUIEvent2.isDefaultCancelled() && dOMUIEvent != null) {
            this.booleanProperty.handleEvent(dOMUIEvent);
        }
        return bl;
    }

    public final boolean uiEvent(DOMUIEvent dOMUIEvent, InputEvent inputEvent, EventListener eventListener) {
        if (eventListener != null) {
            dOMUIEvent.setAction(eventListener);
        }
        dOMUIEvent.setSystemEvent(inputEvent);
        dOMUIEvent.setAltKey(inputEvent.isAltDown());
        dOMUIEvent.setCtrlKey(inputEvent.isControlDown());
        dOMUIEvent.setShiftKey(inputEvent.isShiftDown());
        int n = inputEvent.getModifiers();
        short s = 0;
        if ((n & 0x10) != 0) {
            s = (n & 8) != 0 ? ((n & 4) != 0 ? (short)7 : 5) : ((n & 4) != 0 ? (short)3 : 1);
        } else if ((n & 8) != 0) {
            s = (n & 4) != 0 ? (short)6 : 4;
        } else if ((n & 4) != 0) {
            s = 2;
        }
        dOMUIEvent.setMouseButtons(s);
        Component component = inputEvent.getComponent();
        if (component instanceof ObjectPainter) {
            dOMUIEvent.setObjectPainter((ObjectPainter)((Object)component));
        }
        this.booleanProperty.handleEvent(dOMUIEvent);
        switch (dOMUIEvent.typeId) {
            case 8: {
                KeyEvent keyEvent = (KeyEvent)inputEvent;
                keyEvent.setKeyChar((char)dOMUIEvent.getCharCode());
                break;
            }
        }
        if (dOMUIEvent.isDefaultCancelled()) {
            inputEvent.consume();
            return false;
        }
        return !dOMUIEvent.isDefaultDone();
    }

    protected abstract void onNodeSelectCall(DNode var1);

    protected abstract void onNodeBlurEvent(DOMUIEvent var1, DNode var2);

    protected abstract void onNodeFocusEvent(DOMUIEvent var1, DNode var2);

    public final boolean checkDocumentId() {
        Viewport viewport = this.OEAB.getPilotViewport();
        if (this.OEAB.getDocument() == null) {
            return false;
        }
        if (viewport != null && this.consume == viewport.getDocumentId()) {
            return true;
        }
        if (Debug.trace) {
            Debug.trace((String)"Old id");
        }
        return false;
    }

    public boolean is_msie_event_emulation() {
        return this.clearSelection;
    }

    public final ThePilot getPilot() {
        return this.OEAB;
    }

    public final boolean isPilotDisposed() {
        return this.OEAB.isDisposed();
    }

    public final int getDocWidth() {
        return this.booleanProperty.getWidth();
    }

    public final int getDocHeight() {
        return this.booleanProperty.getHeight();
    }

    public final void docLayout(int n, int n2) {
        block2: {
            try {
                this.booleanProperty.layout(n, n2);
            }
            catch (RuntimeException runtimeException) {
                if (!Debug.ex) break block2;
                Debug.ex((Throwable)runtimeException);
            }
        }
    }

    public final void docPostLayout() {
        this.booleanProperty.postLayout();
    }

    public final void docClearSelection() {
        this.booleanProperty.clearSelection();
    }

    public final void docSetSelection(int n, int n2, int n3, int n4) {
        int n5 = this.getScrollX();
        int n6 = this.getScrollY();
        this.booleanProperty.setSelection(n, n2, n3, n4, n5, n6);
    }

    public final boolean docContainsFixedBoxes() {
        return this.booleanProperty.containsFixedBoxes();
    }

    public final void docPaint(Graphics graphics) {
        this.booleanProperty.paint(graphics);
    }

    public final void docPaintFixed(Graphics graphics) {
        this.booleanProperty.paintFixed(graphics);
    }

    public final DOMUIEvent createDomUIEvent(int n) {
        return (DOMUIEvent)this.OEAB.getDDocument().createDOMEvent(n);
    }

    public final ObjectPainter getNodePainter(DNode dNode) {
        return this.OEAB.getView().getNodePainter(dNode);
    }

    protected final void notifyFocusGain() {
        this.OEAB.viewportBecameActive();
        this.booleanProperty.getFocusManager().setFrameFocused(true);
    }

    protected final void notifyFocusLost() {
        this.booleanProperty.getFocusManager().setFrameFocused(false);
    }
}

