/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.diagView;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticViewerInterface;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticViewerSetRunnable;
import com.mathworks.toolbox.dastudio.diagView.DiagnosticViewerWindow;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class DiagnosticViewerTableModel
extends DefaultTableModel {
    private static DiagnosticViewerWindow viewer;
    private static DiagnosticViewerInterface viewerUDD;
    MouseAdapter listMouseListener;
    private static JTable tableView;
    private static ResourceBundle res;

    public DiagnosticViewerTableModel(DiagnosticViewerWindow diagnosticViewerWindow) {
        super(0, 5);
        viewer = diagnosticViewerWindow;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ImageIcon.class;
            }
        }
        return super.getColumnClass(n);
    }

    public void setDiagnosticViewer(DiagnosticViewerWindow diagnosticViewerWindow) {
        viewer = diagnosticViewerWindow;
    }

    @Override
    public String getColumnName(int n) {
        if (n != 0) {
            return res.getString("diagView.table.header" + new Integer(n).toString());
        }
        char[] cArray = new char[]{' '};
        return new String(cArray);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void removeRow(int n) {
        super.removeRow(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void removeMouseListener() {
        JTableHeader jTableHeader = tableView.getTableHeader();
        jTableHeader.removeMouseListener(this.listMouseListener);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        tableView = jTable;
        tableView.setColumnSelectionAllowed(false);
        this.listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    TableColumnModel tableColumnModel = tableView.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = tableView.convertColumnIndexToModel(n);
                    if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                        viewerUDD = viewer.getUDDDiagnosticViewer();
                        DiagnosticViewerSetRunnable diagnosticViewerSetRunnable = new DiagnosticViewerSetRunnable(viewerUDD, n2 + 1);
                        Matlab.whenMatlabReady((Runnable)diagnosticViewerSetRunnable);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    Window window = SwingUtilities.windowForComponent(tableView);
                    DiagnosticViewerWindow diagnosticViewerWindow = (DiagnosticViewerWindow)((Object)window);
                    JPopupMenu jPopupMenu = diagnosticViewerWindow.getVisibPopupMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        JTableHeader jTableHeader = tableView.getTableHeader();
        jTableHeader.addMouseListener(this.listMouseListener);
    }

    static {
        res = ResourceBundle.getBundle("com.mathworks.toolbox.dastudio.diagView.resources.RES_diagViewer");
    }
}

