/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeDate
extends IdScriptable {
    private static String[] NaN = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static int[] OEAB = new int[]{-1, -2, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
    private static String StringClass = "Invalid Date";
    private static String[] abs = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] addAsPrototype = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static TimeZone addIdFunctionProperty;
    private static double append;
    private static DateFormat ceil;
    private static DateFormat charAt;
    private static DateFormat currentTimeMillis;
    private static DateFormat equals;
    private double date;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeDate nativeDate = new NativeDate();
        nativeDate.prototypeFlag = true;
        nativeDate.date = ScriptRuntime.NaN;
        nativeDate.addAsPrototype(44, context, scriptable, bl);
    }

    private NativeDate() {
        if (addIdFunctionProperty == null) {
            addIdFunctionProperty = TimeZone.getDefault();
            append = addIdFunctionProperty.getRawOffset();
        }
    }

    public String getClassName() {
        return "Date";
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null) {
            clazz = ScriptRuntime.StringClass;
        }
        return super.getDefaultValue(clazz);
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
        this.addIdFunctionProperty(idFunction, -2, bl);
        this.addIdFunctionProperty(idFunction, -1, bl);
        super.fillConstructorProperties(context, idFunction, bl);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case -2: {
                    return 1;
                }
                case -1: {
                    return 1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 0;
                }
                case 9: {
                    return 0;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    return 0;
                }
                case 13: {
                    return 0;
                }
                case 14: {
                    return 0;
                }
                case 15: {
                    return 0;
                }
                case 16: {
                    return 0;
                }
                case 17: {
                    return 0;
                }
                case 18: {
                    return 0;
                }
                case 19: {
                    return 0;
                }
                case 20: {
                    return 0;
                }
                case 21: {
                    return 0;
                }
                case 22: {
                    return 0;
                }
                case 23: {
                    return 0;
                }
                case 24: {
                    return 0;
                }
                case 25: {
                    return 0;
                }
                case 26: {
                    return 0;
                }
                case 27: {
                    return 0;
                }
                case 28: {
                    return 0;
                }
                case 29: {
                    return 1;
                }
                case 30: {
                    return 1;
                }
                case 31: {
                    return 1;
                }
                case 32: {
                    return 2;
                }
                case 33: {
                    return 2;
                }
                case 34: {
                    return 3;
                }
                case 35: {
                    return 3;
                }
                case 36: {
                    return 4;
                }
                case 37: {
                    return 4;
                }
                case 38: {
                    return 1;
                }
                case 39: {
                    return 1;
                }
                case 40: {
                    return 2;
                }
                case 41: {
                    return 2;
                }
                case 42: {
                    return 3;
                }
                case 43: {
                    return 3;
                }
                case 44: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case -2: {
                    return this.wrap_double(NativeDate.methodArity(objectArray));
                }
                case -1: {
                    return this.wrap_double(NativeDate.prototypeFlag(ScriptRuntime.toString(objectArray, 0)));
                }
                case 1: {
                    return NativeDate.jsConstructor(objectArray, scriptable2 == null);
                }
                case 2: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    return NativeDate.toInteger(d, 0);
                }
                case 3: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    return NativeDate.toInteger(d, 2);
                }
                case 4: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    return NativeDate.toInteger(d, 1);
                }
                case 5: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    return NativeDate.toNumber(d);
                }
                case 6: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    return NativeDate.toString(d);
                }
                case 7: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    return NativeDate.NaN(d);
                }
                case 8: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        return NativeDate.abs(d);
                    }
                    return StringClass;
                }
                case 9: {
                    return this.wrap_double(this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date);
                }
                case 10: {
                    return this.wrap_double(this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date);
                }
                case 11: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.addAsPrototype(context, d);
                    }
                    return this.wrap_double(d);
                }
                case 12: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.append(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 13: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.append(d);
                    }
                    return this.wrap_double(d);
                }
                case 14: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.date(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 15: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.date(d);
                    }
                    return this.wrap_double(d);
                }
                case 16: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.equals(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 17: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.equals(d);
                    }
                    return this.wrap_double(d);
                }
                case 18: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.execMethod(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 19: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.execMethod(d);
                    }
                    return this.wrap_double(d);
                }
                case 20: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getDateTimeInstance(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 21: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getDateTimeInstance(d);
                    }
                    return this.wrap_double(d);
                }
                case 22: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getDefault(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 23: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getDefault(d);
                    }
                    return this.wrap_double(d);
                }
                case 24: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getDefaultValue(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 25: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getDefaultValue(d);
                    }
                    return this.wrap_double(d);
                }
                case 26: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getRawOffset(NativeDate.format(d));
                    }
                    return this.wrap_double(d);
                }
                case 27: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.getRawOffset(d);
                    }
                    return this.wrap_double(d);
                }
                case 28: {
                    double d = this.NaN((Scriptable)scriptable2, (IdFunction)idFunction, (boolean)true).date;
                    if (d == d) {
                        d = NativeDate.currentTimeMillis(d);
                    }
                    return this.wrap_double(d);
                }
                case 29: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, true).fillConstructorProperties(ScriptRuntime.toNumber(objectArray, 0)));
                }
                case 30: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 1, true));
                }
                case 31: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 1, false));
                }
                case 32: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 2, true));
                }
                case 33: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 2, false));
                }
                case 34: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 3, true));
                }
                case 35: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 3, false));
                }
                case 36: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 4, true));
                }
                case 37: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).floor(objectArray, 4, false));
                }
                case 38: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).format(objectArray, 1, true));
                }
                case 39: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).format(objectArray, 1, false));
                }
                case 40: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).format(objectArray, 2, true));
                }
                case 41: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).format(objectArray, 2, false));
                }
                case 42: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).format(objectArray, 3, true));
                }
                case 43: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).format(objectArray, 3, false));
                }
                case 44: {
                    return this.wrap_double(this.NaN(scriptable2, idFunction, false).getTimeInstance(ScriptRuntime.toNumber(objectArray, 0)));
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeDate NaN(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        while (!(scriptable instanceof NativeDate)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, bl);
        }
        return (NativeDate)scriptable;
    }

    private static double OEAB(double d) {
        return Math.floor(d / 8.64E7);
    }

    private static double StringClass(double d) {
        double d2 = d % 8.64E7;
        if (d2 < 0.0) {
            d2 += 8.64E7;
        }
        return d2;
    }

    private static int abs(int n) {
        if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            return 366;
        }
        return 365;
    }

    private static double addAsPrototype(double d) {
        return 365.0 * (d - 1970.0) + Math.floor((d - 1969.0) / 4.0) - Math.floor((d - 1901.0) / 100.0) + Math.floor((d - 1601.0) / 400.0);
    }

    private static double addIdFunctionProperty(double d) {
        return NativeDate.addAsPrototype(d) * 8.64E7;
    }

    private static int append(double d) {
        int n;
        int n2 = (int)Math.floor(d / 8.64E7 / 366.0) + 1970;
        int n3 = (int)Math.floor(d / 8.64E7 / 365.0) + 1970;
        if (n3 < n2) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        while (n3 > n2) {
            int n4 = (n3 + n2) / 2;
            if (NativeDate.addIdFunctionProperty(n4) > d) {
                n3 = n4 - 1;
                continue;
            }
            if (!(NativeDate.addIdFunctionProperty(n4) <= d)) continue;
            n = n4 + 1;
            if (NativeDate.addIdFunctionProperty(n) > d) {
                return n4;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    private static boolean ceil(double d) {
        return NativeDate.abs(NativeDate.append(d)) == 366;
    }

    private static int charAt(double d) {
        int n = NativeDate.append(d);
        return (int)(NativeDate.OEAB(d) - NativeDate.addAsPrototype(n));
    }

    private static double currentTimeMillis(int n, boolean bl) {
        int n2 = n * 30;
        n2 = n >= 7 ? (n2 += n / 2 - 1) : (n >= 2 ? (n2 += (n - 1) / 2 - 1) : (n2 += n));
        if (bl && n >= 2) {
            ++n2;
        }
        return n2;
    }

    private static int date(double d) {
        int n = NativeDate.charAt(d);
        int n2 = 31;
        if (n < 31) {
            return 0;
        }
        n2 = NativeDate.ceil(d) ? (n2 += 29) : (n2 += 28);
        if (n < n2) {
            return 1;
        }
        if (n < (n2 += 31)) {
            return 2;
        }
        if (n < (n2 += 30)) {
            return 3;
        }
        if (n < (n2 += 31)) {
            return 4;
        }
        if (n < (n2 += 30)) {
            return 5;
        }
        if (n < (n2 += 31)) {
            return 6;
        }
        if (n < (n2 += 31)) {
            return 7;
        }
        if (n < (n2 += 30)) {
            return 8;
        }
        if (n < (n2 += 31)) {
            return 9;
        }
        if (n < (n2 += 30)) {
            return 10;
        }
        return 11;
    }

    private static int equals(double d) {
        int n = NativeDate.charAt(d);
        int n2 = 30;
        if (n <= 30) {
            return n + 1;
        }
        int n3 = n2;
        n2 = NativeDate.ceil(d) ? (n2 += 29) : (n2 += 28);
        if (n <= n2) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        return n - n3;
    }

    private static int execMethod(double d) {
        double d2 = NativeDate.OEAB(d) + 4.0;
        if ((d2 %= 7.0) < 0.0) {
            d2 += 7.0;
        }
        return (int)d2;
    }

    private static double fillConstructorProperties() {
        return System.currentTimeMillis();
    }

    private static double floor(double d) {
        Date date = new Date((long)d);
        if (addIdFunctionProperty.inDaylightTime(date)) {
            return 3600000.0;
        }
        return 0.0;
    }

    private static double format(double d) {
        return d + append + NativeDate.floor(d);
    }

    private static double getDateInstance(double d) {
        return d - append - NativeDate.floor(d - append);
    }

    private static int getDateTimeInstance(double d) {
        double d2 = Math.floor(d / 3600000.0) % 24.0;
        if (d2 < 0.0) {
            d2 += 24.0;
        }
        return (int)d2;
    }

    private static int getDefault(double d) {
        double d2 = Math.floor(d / 60000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int getDefaultValue(double d) {
        double d2 = Math.floor(d / 1000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int getRawOffset(double d) {
        double d2 = d % 1000.0;
        if (d2 < 0.0) {
            d2 += 1000.0;
        }
        return (int)d2;
    }

    private static double getTimeInstance(double d, double d2, double d3, double d4) {
        return ((d * 60.0 + d2) * 60.0 + d3) * 1000.0 + d4;
    }

    private static double hasFeature(double d, double d2, double d3) {
        d += Math.floor(d2 / 12.0);
        if ((d2 %= 12.0) < 0.0) {
            d2 += 12.0;
        }
        boolean bl = NativeDate.abs((int)d) == 366;
        double d4 = Math.floor(NativeDate.addIdFunctionProperty(d) / 8.64E7);
        double d5 = NativeDate.currentTimeMillis((int)d2, bl);
        double d6 = d4 + d5 + d3 - 1.0;
        return d6;
    }

    private static double inDaylightTime(double d, double d2) {
        return d * 8.64E7 + d2;
    }

    private static double isInfinite(double d) {
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Math.abs(d) > 8.64E15) {
            return ScriptRuntime.NaN;
        }
        if (d > 0.0) {
            return Math.floor(d + 0.0);
        }
        return Math.ceil(d + 0.0);
    }

    private static double length(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = NativeDate.hasFeature(d, d2, d3);
        double d9 = NativeDate.getTimeInstance(d4, d5, d6, d7);
        double d10 = NativeDate.inDaylightTime(d8, d9);
        return d10;
    }

    private static double methodArity(Object[] objectArray) {
        double d;
        double[] dArray = new double[7];
        int n = 0;
        while (n < 7) {
            if (n < objectArray.length) {
                d = ScriptRuntime.toNumber(objectArray[n]);
                if (d != d || Double.isInfinite(d)) {
                    return ScriptRuntime.NaN;
                }
                dArray[n] = ScriptRuntime.toInteger(objectArray[n]);
            } else {
                dArray[n] = 0.0;
            }
            ++n;
        }
        if (dArray[0] >= 0.0 && dArray[0] <= 99.0) {
            dArray[0] = dArray[0] + 1900.0;
        }
        if (dArray[2] < 1.0) {
            dArray[2] = 1.0;
        }
        d = NativeDate.length(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
        d = NativeDate.isInfinite(d);
        return d;
    }

    private static boolean nextInstanceCheck(String string, int n, String string2, int n2, int n3) {
        boolean bl = false;
        int n4 = string.length();
        int n5 = string2.length();
        while (n3 > 0 && n < n4 && n2 < n5) {
            if (Character.toLowerCase(string.charAt(n)) != Character.toLowerCase(string2.charAt(n2))) break;
            ++n;
            ++n2;
            --n3;
        }
        if (n3 == 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double padArguments(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        char c = '\u0000';
        char c2 = '\u0000';
        int n7 = 0;
        int n8 = -1;
        double d = -1.0;
        char c3 = '\u0000';
        int n9 = 0;
        boolean bl = false;
        if (string == null) {
            return ScriptRuntime.NaN;
        }
        n9 = string.length();
        block0: while (n7 < n9) {
            int n10;
            c = string.charAt(n7);
            ++n7;
            if (c <= ' ' || c == ',' || c == '-') {
                if (n7 >= n9) continue;
                c2 = string.charAt(n7);
                if (c != '-' || '0' > c2 || c2 > '9') continue;
                c3 = c;
                continue;
            }
            if (c == '(') {
                n10 = 1;
                while (n7 < n9) {
                    c = string.charAt(n7);
                    ++n7;
                    if (c == '(') {
                        ++n10;
                        continue;
                    }
                    if (c == ')' && --n10 <= 0) continue block0;
                }
                continue;
            }
            if ('0' <= c && c <= '9') {
                n8 = c - 48;
                while (n7 < n9 && '0' <= (c = string.charAt(n7)) && c <= '9') {
                    n8 = n8 * 10 + c - 48;
                    ++n7;
                }
                if (c3 == '+' || c3 == '-') {
                    bl = true;
                    n8 = n8 < 24 ? (n8 *= 60) : n8 % 100 + n8 / 100 * 60;
                    if (c3 == '+') {
                        n8 = -n8;
                    }
                    if (d != 0.0 && d != -1.0) {
                        return ScriptRuntime.NaN;
                    }
                    d = n8;
                } else if (n8 >= 70 || c3 == '/' && n2 >= 0 && n3 >= 0 && n < 0) {
                    if (n >= 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (c > ' ' && c != ',' && c != '/' && n7 < n9) return ScriptRuntime.NaN;
                    n = n8 < 100 ? n8 + 1900 : n8;
                } else if (c == ':') {
                    if (n4 < 0) {
                        n4 = n8;
                    } else {
                        if (n5 >= 0) return ScriptRuntime.NaN;
                        n5 = n8;
                    }
                } else if (c == '/') {
                    if (n2 < 0) {
                        n2 = n8 - 1;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                } else {
                    if (n7 < n9 && c != ',' && c > ' ' && c != '-') {
                        return ScriptRuntime.NaN;
                    }
                    if (bl && n8 < 60) {
                        d = d < 0.0 ? (d -= (double)n8) : (d += (double)n8);
                    } else if (n4 >= 0 && n5 < 0) {
                        n5 = n8;
                    } else if (n5 >= 0 && n6 < 0) {
                        n6 = n8;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                }
                c3 = '\u0000';
                continue;
            }
            if (c == '/' || c == ':' || c == '+' || c == '-') {
                c3 = c;
                continue;
            }
            n10 = n7 - 1;
            while (n7 < n9) {
                c = string.charAt(n7);
                if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) break;
                ++n7;
            }
            if (n7 <= n10 + 1) {
                return ScriptRuntime.NaN;
            }
            int n11 = NaN.length;
            while (--n11 >= 0) {
                if (!NativeDate.nextInstanceCheck(NaN[n11], 0, string, n10, n7 - n10)) continue;
                int n12 = OEAB[n11];
                if (n12 == 0) break;
                if (n12 < 0) {
                    if (n4 > 12 || n4 < 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (n12 == -1 && n4 == 12) {
                        n4 = 0;
                        break;
                    }
                    if (n12 != -2 || n4 == 12) break;
                    n4 += 12;
                    break;
                }
                if (n12 <= 13) {
                    if (n2 >= 0) return ScriptRuntime.NaN;
                    n2 = n12 - 2;
                    break;
                }
                d = n12 - 10000;
                break;
            }
            if (n11 < 0) {
                return ScriptRuntime.NaN;
            }
            c3 = '\u0000';
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            return ScriptRuntime.NaN;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (d == -1.0) {
            double d2 = NativeDate.length(n, n2, n3, n4, n5, n6, 0.0);
            return NativeDate.getDateInstance(d2);
        }
        double d3 = NativeDate.length(n, n2, n3, n4, n5, n6, 0.0);
        return d3 += d * 60000.0;
    }

    private static double prototypeFlag(String string) {
        return NativeDate.padArguments(string);
    }

    private static String toInteger(double d, int n) {
        int n2;
        if (d != d) {
            return StringClass;
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        double d2 = NativeDate.format(d);
        int n3 = (int)Math.floor((append + NativeDate.floor(d)) / 60000.0);
        int n4 = n3 / 60 * 100 + n3 % 60;
        String string = Integer.toString(NativeDate.equals(d2));
        String string2 = Integer.toString(NativeDate.getDateTimeInstance(d2));
        String string3 = Integer.toString(NativeDate.getDefault(d2));
        String string4 = Integer.toString(NativeDate.getDefaultValue(d2));
        String string5 = Integer.toString(n4 > 0 ? n4 : -n4);
        int n5 = NativeDate.append(d2);
        String string6 = Integer.toString(n5 > 0 ? n5 : -n5);
        if (n != 2) {
            stringBuffer.append(abs[NativeDate.execMethod(d2)]);
            stringBuffer.append(' ');
            stringBuffer.append(addAsPrototype[NativeDate.date(d2)]);
            if (string.length() == 1) {
                stringBuffer.append(" 0");
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            stringBuffer.append(' ');
            if (n5 < 0) {
                stringBuffer.append('-');
            }
            n2 = string6.length();
            while (n2 < 4) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string6);
            if (n != 1) {
                stringBuffer.append(' ');
            }
        }
        if (n != 1) {
            if (string2.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
            if (string3.length() == 1) {
                stringBuffer.append(":0");
            } else {
                stringBuffer.append(':');
            }
            stringBuffer.append(string3);
            if (string4.length() == 1) {
                stringBuffer.append(":0");
            } else {
                stringBuffer.append(':');
            }
            stringBuffer.append(string4);
            if (n4 > 0) {
                stringBuffer.append(" GMT+");
            } else {
                stringBuffer.append(" GMT-");
            }
            n2 = string5.length();
            while (n2 < 4) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string5);
            if (ceil == null) {
                ceil = new SimpleDateFormat("zzz");
            }
            if (ceil != null) {
                stringBuffer.append(" (");
                Date date = new Date((long)d);
                stringBuffer.append(ceil.format(date));
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    private static Object jsConstructor(Object[] objectArray, boolean bl) {
        if (!bl) {
            return NativeDate.toInteger(NativeDate.fillConstructorProperties(), 0);
        }
        NativeDate nativeDate = new NativeDate();
        if (objectArray.length == 0) {
            nativeDate.date = NativeDate.fillConstructorProperties();
            return nativeDate;
        }
        if (objectArray.length == 1) {
            double d;
            if (objectArray[0] instanceof Scriptable) {
                objectArray[0] = ((Scriptable)objectArray[0]).getDefaultValue(null);
            }
            if (!(objectArray[0] instanceof String)) {
                d = ScriptRuntime.toNumber(objectArray[0]);
            } else {
                String string = (String)objectArray[0];
                d = NativeDate.padArguments(string);
            }
            nativeDate.date = NativeDate.isInfinite(d);
            return nativeDate;
        }
        double[] dArray = new double[7];
        int n = 0;
        while (n < 7) {
            if (n < objectArray.length) {
                double d = ScriptRuntime.toNumber(objectArray[n]);
                if (d != d || Double.isInfinite(d)) {
                    nativeDate.date = ScriptRuntime.NaN;
                    return nativeDate;
                }
                dArray[n] = ScriptRuntime.toInteger(objectArray[n]);
            } else {
                dArray[n] = 0.0;
            }
            ++n;
        }
        if (dArray[0] >= 0.0 && dArray[0] <= 99.0) {
            dArray[0] = dArray[0] + 1900.0;
        }
        if (dArray[2] < 1.0) {
            dArray[2] = 1.0;
        }
        double d = NativeDate.hasFeature(dArray[0], dArray[1], dArray[2]);
        double d2 = NativeDate.getTimeInstance(dArray[3], dArray[4], dArray[5], dArray[6]);
        d2 = NativeDate.inDaylightTime(d, d2);
        d2 = NativeDate.getDateInstance(d2);
        nativeDate.date = NativeDate.isInfinite(d2);
        return nativeDate;
    }

    private static String toLowerCase(double d, DateFormat dateFormat) {
        if (d != d) {
            return StringClass;
        }
        Date date = new Date((long)d);
        return dateFormat.format(date);
    }

    private static String toNumber(double d) {
        if (charAt == null) {
            charAt = DateFormat.getDateTimeInstance(1, 1);
        }
        return NativeDate.toLowerCase(d, charAt);
    }

    private static String toString(double d) {
        if (equals == null) {
            equals = DateFormat.getTimeInstance(1);
        }
        return NativeDate.toLowerCase(d, equals);
    }

    private static String NaN(double d) {
        if (currentTimeMillis == null) {
            currentTimeMillis = DateFormat.getDateInstance(1);
        }
        return NativeDate.toLowerCase(d, currentTimeMillis);
    }

    private static String abs(double d) {
        StringBuffer stringBuffer = new StringBuffer(60);
        String string = Integer.toString(NativeDate.equals(d));
        String string2 = Integer.toString(NativeDate.getDateTimeInstance(d));
        String string3 = Integer.toString(NativeDate.getDefault(d));
        String string4 = Integer.toString(NativeDate.getDefaultValue(d));
        int n = NativeDate.append(d);
        String string5 = Integer.toString(n > 0 ? n : -n);
        stringBuffer.append(abs[NativeDate.execMethod(d)]);
        stringBuffer.append(", ");
        if (string.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append(addAsPrototype[NativeDate.date(d)]);
        if (n < 0) {
            stringBuffer.append(" -");
        } else {
            stringBuffer.append(' ');
        }
        int n2 = string5.length();
        while (n2 < 4) {
            stringBuffer.append('0');
            ++n2;
        }
        stringBuffer.append(string5);
        if (string2.length() == 1) {
            stringBuffer.append(" 0");
        } else {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string2);
        if (string3.length() == 1) {
            stringBuffer.append(":0");
        } else {
            stringBuffer.append(':');
        }
        stringBuffer.append(string3);
        if (string4.length() == 1) {
            stringBuffer.append(":0");
        } else {
            stringBuffer.append(':');
        }
        stringBuffer.append(string4);
        stringBuffer.append(" GMT");
        return stringBuffer.toString();
    }

    private static double addAsPrototype(Context context, double d) {
        int n = NativeDate.append(NativeDate.format(d));
        if (context.hasFeature(1)) {
            if (n >= 1900 && n < 2000) {
                n -= 1900;
            }
        } else {
            n -= 1900;
        }
        return n;
    }

    private static double currentTimeMillis(double d) {
        return (d - NativeDate.format(d)) / 60000.0;
    }

    private double fillConstructorProperties(double d) {
        this.date = NativeDate.isInfinite(d);
        return this.date;
    }

    private double floor(Object[] objectArray, int n, boolean bl) {
        double[] dArray = new double[4];
        double d = this.date;
        if (d != d) {
            return d;
        }
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        int n2 = 0;
        while (n2 < objectArray.length && n2 < n) {
            dArray[n2] = ScriptRuntime.toNumber(objectArray[n2]);
            if (dArray[n2] != dArray[n2] || Double.isInfinite(dArray[n2])) {
                this.date = ScriptRuntime.NaN;
                return this.date;
            }
            dArray[n2] = ScriptRuntime.toInteger(dArray[n2]);
            ++n2;
        }
        double d2 = bl ? NativeDate.format(d) : d;
        n2 = 0;
        int n3 = objectArray.length;
        double d3 = n >= 4 && n2 < n3 ? dArray[n2++] : (double)NativeDate.getDateTimeInstance(d2);
        double d4 = n >= 3 && n2 < n3 ? dArray[n2++] : (double)NativeDate.getDefault(d2);
        double d5 = n >= 2 && n2 < n3 ? dArray[n2++] : (double)NativeDate.getDefaultValue(d2);
        double d6 = n >= 1 && n2 < n3 ? dArray[n2++] : (double)NativeDate.getRawOffset(d2);
        double d7 = NativeDate.getTimeInstance(d3, d4, d5, d6);
        double d8 = NativeDate.inDaylightTime(NativeDate.OEAB(d2), d7);
        if (bl) {
            d8 = NativeDate.getDateInstance(d8);
        }
        this.date = d = NativeDate.isInfinite(d8);
        return d;
    }

    private double format(Object[] objectArray, int n, boolean bl) {
        double d;
        double[] dArray = new double[3];
        double d2 = this.date;
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        int n2 = 0;
        while (n2 < objectArray.length && n2 < n) {
            dArray[n2] = ScriptRuntime.toNumber(objectArray[n2]);
            if (dArray[n2] != dArray[n2] || Double.isInfinite(dArray[n2])) {
                this.date = ScriptRuntime.NaN;
                return this.date;
            }
            dArray[n2] = ScriptRuntime.toInteger(dArray[n2]);
            ++n2;
        }
        if (d2 != d2) {
            if (objectArray.length < 3) {
                return ScriptRuntime.NaN;
            }
            d = 0.0;
        } else {
            d = bl ? NativeDate.format(d2) : d2;
        }
        n2 = 0;
        int n3 = objectArray.length;
        double d3 = n >= 3 && n2 < n3 ? dArray[n2++] : (double)NativeDate.append(d);
        double d4 = n >= 2 && n2 < n3 ? dArray[n2++] : (double)NativeDate.date(d);
        double d5 = n >= 1 && n2 < n3 ? dArray[n2++] : (double)NativeDate.equals(d);
        d5 = NativeDate.hasFeature(d3, d4, d5);
        double d6 = NativeDate.inDaylightTime(d5, NativeDate.StringClass(d));
        if (bl) {
            d6 = NativeDate.getDateInstance(d6);
        }
        this.date = d2 = NativeDate.isInfinite(d6);
        return d2;
    }

    private double getTimeInstance(double d) {
        if (d != d || Double.isInfinite(d)) {
            this.date = ScriptRuntime.NaN;
            return this.date;
        }
        this.date = this.date != this.date ? 0.0 : NativeDate.format(this.date);
        if (d >= 0.0 && d <= 99.0) {
            d += 1900.0;
        }
        double d2 = NativeDate.hasFeature(d, NativeDate.date(this.date), NativeDate.equals(this.date));
        double d3 = NativeDate.inDaylightTime(d2, NativeDate.StringClass(this.date));
        d3 = NativeDate.getDateInstance(d3);
        this.date = NativeDate.isInfinite(d3);
        return this.date;
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case -2: {
                    return "UTC";
                }
                case -1: {
                    return "parse";
                }
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toTimeString";
                }
                case 4: {
                    return "toDateString";
                }
                case 5: {
                    return "toLocaleString";
                }
                case 6: {
                    return "toLocaleTimeString";
                }
                case 7: {
                    return "toLocaleDateString";
                }
                case 8: {
                    return "toUTCString";
                }
                case 9: {
                    return "valueOf";
                }
                case 10: {
                    return "getTime";
                }
                case 11: {
                    return "getYear";
                }
                case 12: {
                    return "getFullYear";
                }
                case 13: {
                    return "getUTCFullYear";
                }
                case 14: {
                    return "getMonth";
                }
                case 15: {
                    return "getUTCMonth";
                }
                case 16: {
                    return "getDate";
                }
                case 17: {
                    return "getUTCDate";
                }
                case 18: {
                    return "getDay";
                }
                case 19: {
                    return "getUTCDay";
                }
                case 20: {
                    return "getHours";
                }
                case 21: {
                    return "getUTCHours";
                }
                case 22: {
                    return "getMinutes";
                }
                case 23: {
                    return "getUTCMinutes";
                }
                case 24: {
                    return "getSeconds";
                }
                case 25: {
                    return "getUTCSeconds";
                }
                case 26: {
                    return "getMilliseconds";
                }
                case 27: {
                    return "getUTCMilliseconds";
                }
                case 28: {
                    return "getTimezoneOffset";
                }
                case 29: {
                    return "setTime";
                }
                case 30: {
                    return "setMilliseconds";
                }
                case 31: {
                    return "setUTCMilliseconds";
                }
                case 32: {
                    return "setSeconds";
                }
                case 33: {
                    return "setUTCSeconds";
                }
                case 34: {
                    return "setMinutes";
                }
                case 35: {
                    return "setUTCMinutes";
                }
                case 36: {
                    return "setHours";
                }
                case 37: {
                    return "setUTCHours";
                }
                case 38: {
                    return "setDate";
                }
                case 39: {
                    return "setUTCDate";
                }
                case 40: {
                    return "setMonth";
                }
                case 41: {
                    return "setUTCMonth";
                }
                case 42: {
                    return "setFullYear";
                }
                case 43: {
                    return "setUTCFullYear";
                }
                case 44: {
                    return "setYear";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 6: {
                string2 = "getDay";
                n = 18;
                break;
            }
            case 7: {
                switch (string.charAt(3)) {
                    case 'D': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getDate";
                            n = 16;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setDate";
                        n = 38;
                        break block0;
                    }
                    case 'T': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getTime";
                            n = 10;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setTime";
                        n = 29;
                        break block0;
                    }
                    case 'Y': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getYear";
                            n = 11;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setYear";
                        n = 44;
                        break block0;
                    }
                    case 'u': {
                        string2 = "valueOf";
                        n = 9;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'g') {
                    c = string.charAt(7);
                    if (c == 'h') {
                        string2 = "getMonth";
                        n = 14;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "getHours";
                    n = 20;
                    break;
                }
                if (c == 's') {
                    c = string.charAt(7);
                    if (c == 'h') {
                        string2 = "setMonth";
                        n = 40;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setHours";
                    n = 36;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 2;
                break;
            }
            case 9: {
                string2 = "getUTCDay";
                n = 19;
                break;
            }
            case 10: {
                char c = string.charAt(3);
                if (c == 'M') {
                    c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getMinutes";
                        n = 22;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setMinutes";
                    n = 34;
                    break;
                }
                if (c == 'S') {
                    c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getSeconds";
                        n = 24;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setSeconds";
                    n = 32;
                    break;
                }
                if (c != 'U') break;
                c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCDate";
                    n = 17;
                    break;
                }
                if (c != 's') break;
                string2 = "setUTCDate";
                n = 39;
                break;
            }
            case 11: {
                switch (string.charAt(3)) {
                    case 'F': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getFullYear";
                            n = 12;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setFullYear";
                        n = 42;
                        break block0;
                    }
                    case 'M': {
                        string2 = "toGMTString";
                        n = 8;
                        break block0;
                    }
                    case 'T': {
                        string2 = "toUTCString";
                        n = 8;
                        break block0;
                    }
                    case 'U': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            c = string.charAt(9);
                            if (c == 'r') {
                                string2 = "getUTCHours";
                                n = 21;
                                break block0;
                            }
                            if (c != 't') break block0;
                            string2 = "getUTCMonth";
                            n = 15;
                            break block0;
                        }
                        if (c != 's') break block0;
                        c = string.charAt(9);
                        if (c == 'r') {
                            string2 = "setUTCHours";
                            n = 37;
                            break block0;
                        }
                        if (c != 't') break block0;
                        string2 = "setUTCMonth";
                        n = 41;
                        break block0;
                    }
                    case 's': {
                        string2 = "constructor";
                        n = 1;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                char c = string.charAt(2);
                if (c == 'D') {
                    string2 = "toDateString";
                    n = 4;
                    break;
                }
                if (c != 'T') break;
                string2 = "toTimeString";
                n = 3;
                break;
            }
            case 13: {
                char c = string.charAt(0);
                if (c == 'g') {
                    c = string.charAt(6);
                    if (c == 'M') {
                        string2 = "getUTCMinutes";
                        n = 23;
                        break;
                    }
                    if (c != 'S') break;
                    string2 = "getUTCSeconds";
                    n = 25;
                    break;
                }
                if (c != 's') break;
                c = string.charAt(6);
                if (c == 'M') {
                    string2 = "setUTCMinutes";
                    n = 35;
                    break;
                }
                if (c != 'S') break;
                string2 = "setUTCSeconds";
                n = 33;
                break;
            }
            case 14: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCFullYear";
                    n = 13;
                    break;
                }
                if (c == 's') {
                    string2 = "setUTCFullYear";
                    n = 43;
                    break;
                }
                if (c != 't') break;
                string2 = "toLocaleString";
                n = 5;
                break;
            }
            case 15: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getMilliseconds";
                    n = 26;
                    break;
                }
                if (c != 's') break;
                string2 = "setMilliseconds";
                n = 30;
                break;
            }
            case 17: {
                string2 = "getTimezoneOffset";
                n = 28;
                break;
            }
            case 18: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCMilliseconds";
                    n = 27;
                    break;
                }
                if (c == 's') {
                    string2 = "setUTCMilliseconds";
                    n = 31;
                    break;
                }
                if (c != 't') break;
                c = string.charAt(8);
                if (c == 'D') {
                    string2 = "toLocaleDateString";
                    n = 7;
                    break;
                }
                if (c != 'T') break;
                string2 = "toLocaleTimeString";
                n = 6;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

