/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.plaf;

import com.jgoodies.looks.common.RenderingUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.text.View;

public class MBasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static Rectangle zeroRect;
    static Rectangle iconRect;
    static Rectangle textRect;
    static Rectangle acceleratorRect;
    static Rectangle checkIconRect;
    static Rectangle arrowIconRect;
    static Rectangle viewRect;
    static Rectangle r;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MBasicMenuItemUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        }
        this.defaultTextIconGap = PlafUtils.isPlasticLookAndFeel() ? 2 : 4;
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(string + ".checkIcon");
        }
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent jComponent2 = (JComponent)container;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(string2, actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("doClick", new ClickAction());
        return actionMapUIResource;
    }

    InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (keyStroke != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(keyStroke, "doClick");
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Serializable serializable;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        string2 = keyStroke == null ? this.getAcceleratorSequenceText(jMenuItem) : KeyStrokeUtils.translateKeyStroke(keyStroke);
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getToolkit().getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getToolkit().getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n, n);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(MBasicMenuItemUI.iconRect.x, MBasicMenuItemUI.iconRect.y, MBasicMenuItemUI.iconRect.width, MBasicMenuItemUI.iconRect.height, r);
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int n2;
            serializable = (JComponent)container;
            Integer n3 = (Integer)((JComponent)serializable).getClientProperty(MAX_TEXT_WIDTH);
            Integer n4 = (Integer)((JComponent)serializable).getClientProperty(MAX_ACC_WIDTH);
            int n5 = n3 != null ? n3 : 0;
            int n6 = n2 = n4 != null ? n4 : 0;
            if (MBasicMenuItemUI.r.width < n5) {
                MBasicMenuItemUI.r.width = n5;
            } else {
                ((JComponent)serializable).putClientProperty(MAX_TEXT_WIDTH, new Integer(MBasicMenuItemUI.r.width));
            }
            if (MBasicMenuItemUI.acceleratorRect.width > n2) {
                n2 = MBasicMenuItemUI.acceleratorRect.width;
                ((JComponent)serializable).putClientProperty(MAX_ACC_WIDTH, new Integer(MBasicMenuItemUI.acceleratorRect.width));
            }
            MBasicMenuItemUI.r.width += n2;
            MBasicMenuItemUI.r.width += n;
        }
        if (this.useCheckAndArrow()) {
            MBasicMenuItemUI.r.width += MBasicMenuItemUI.checkIconRect.width;
            MBasicMenuItemUI.r.width += n;
            MBasicMenuItemUI.r.width += n;
            MBasicMenuItemUI.r.width += MBasicMenuItemUI.arrowIconRect.width;
        }
        MBasicMenuItemUI.r.width += 2 * n;
        serializable = jMenuItem.getInsets();
        if (serializable != null) {
            MBasicMenuItemUI.r.width += ((Insets)serializable).left + ((Insets)serializable).right;
            MBasicMenuItemUI.r.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (MBasicMenuItemUI.r.width % 2 == 0) {
            ++MBasicMenuItemUI.r.width;
        }
        if (MBasicMenuItemUI.r.height % 2 == 0) {
            ++MBasicMenuItemUI.r.height;
        }
        if (PlatformInfo.isWindowsVistaAppearance()) {
            MBasicMenuItemUI.r.height += 5;
        }
        return r.getSize();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n2 = jMenuItem.getWidth();
        int n3 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n2, n3);
        MBasicMenuItemUI.viewRect.x += insets.left;
        MBasicMenuItemUI.viewRect.y += insets.top;
        MBasicMenuItemUI.viewRect.width -= insets.right + MBasicMenuItemUI.viewRect.x;
        MBasicMenuItemUI.viewRect.height -= insets.bottom + MBasicMenuItemUI.viewRect.y;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        string = keyStroke == null ? this.getAcceleratorSequenceText(jMenuItem) : KeyStrokeUtils.translateKeyStroke(keyStroke);
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color3);
            }
            if (this.useCheckAndArrow()) {
                icon.paintIcon(jComponent, graphics, MBasicMenuItemUI.checkIconRect.x, MBasicMenuItemUI.checkIconRect.y);
            }
            graphics.setColor(color3);
        }
        if (jMenuItem.getIcon() != null) {
            if (!buttonModel.isEnabled()) {
                object = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                object = jMenuItem.getPressedIcon();
                if (object == null) {
                    object = jMenuItem.getIcon();
                }
            } else {
                object = jMenuItem.getIcon();
            }
            if (object != null) {
                object.paintIcon(jComponent, graphics, MBasicMenuItemUI.iconRect.x, MBasicMenuItemUI.iconRect.y);
            }
        }
        if (string2 != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, textRect);
            } else {
                this.paintText(graphics, jMenuItem, textRect, string2);
            }
        }
        if (string != null && !string.equals("")) {
            int n4 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n5 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n6 = n5 != null ? n5 : MBasicMenuItemUI.acceleratorRect.width;
                n4 = n6 - MBasicMenuItemUI.acceleratorRect.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    RenderingUtils.drawStringUnderlineCharAt((JComponent)this.menuItem, (Graphics)graphics, (String)string, (int)-1, (int)(MBasicMenuItemUI.acceleratorRect.x - n4), (int)(MBasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent()));
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    RenderingUtils.drawStringUnderlineCharAt((JComponent)this.menuItem, (Graphics)graphics, (String)string, (int)-1, (int)(MBasicMenuItemUI.acceleratorRect.x - n4), (int)(MBasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent()));
                    graphics.setColor(jMenuItem.getBackground().darker());
                    RenderingUtils.drawStringUnderlineCharAt((JComponent)this.menuItem, (Graphics)graphics, (String)string, (int)-1, (int)(MBasicMenuItemUI.acceleratorRect.x - n4 - 1), (int)(MBasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent() - 1));
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                RenderingUtils.drawStringUnderlineCharAt((JComponent)this.menuItem, (Graphics)graphics, (String)string, (int)-1, (int)(MBasicMenuItemUI.acceleratorRect.x - n4), (int)(MBasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent()));
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow()) {
                icon2.paintIcon(jComponent, graphics, MBasicMenuItemUI.arrowIconRect.x, MBasicMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                if (PlatformInfo.isWindowsVistaAppearance()) {
                    MBasicMenuItemUI.paintVistaMenuSelectedBackground(graphics, n, n2);
                } else {
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, n, n2);
                }
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            graphics.setColor(color2);
        }
    }

    private static void paintVistaMenuSelectedBackground(Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(247, 243, 255), 0.0f, n2, new Color(239, 243, 255)));
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n - 1, n2 - 1, 6.0, 6.0);
        graphics2D.fill(double_);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(231, 239, 243), 0.0f, n2, new Color(218, 235, 243)));
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(2.0, 2.0, n - 4, n2 - 4, 2.0, 2.0);
        graphics2D.fill(double_2);
        graphics.setColor(new Color(168, 216, 235));
        graphics2D.draw(double_);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                RenderingUtils.drawStringUnderlineCharAt((JComponent)jMenuItem, (Graphics)graphics, (String)string, (int)n, (int)rectangle.x, (int)(rectangle.y + fontMetrics.getAscent()));
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                RenderingUtils.drawStringUnderlineCharAt((JComponent)jMenuItem, (Graphics)graphics, (String)string, (int)n, (int)rectangle.x, (int)(rectangle.y + fontMetrics.getAscent()));
                graphics.setColor(jMenuItem.getBackground().darker());
                RenderingUtils.drawStringUnderlineCharAt((JComponent)jMenuItem, (Graphics)graphics, (String)string, (int)n, (int)(rectangle.x - 1), (int)(rectangle.y + fontMetrics.getAscent() - 1));
            }
        } else {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            RenderingUtils.drawStringUnderlineCharAt((JComponent)jMenuItem, (Graphics)graphics, (String)string, (int)n, (int)rectangle.x, (int)(rectangle.y + fontMetrics.getAscent()));
        }
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            rectangle3.x += n6;
            rectangle2.x += n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + n6;
                rectangle3.x += n6 + rectangle5.width;
                rectangle2.x += n6 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n6;
            rectangle2.x -= n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + rectangle.width - n6 - rectangle5.width;
                rectangle3.x -= n6 + rectangle5.width;
                rectangle2.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (this.useCheckAndArrow()) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private boolean useCheckAndArrow() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2;
            for (n2 = menuElementArray2.length - 1; n2 >= 0 && menuElementArray2[n2].getComponent() != container; --n2) {
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        Action action;
        Serializable serializable;
        if (!this.isInternalFrameSystemMenu() && (serializable = this.menuItem.getActionMap()) != null && (action = ((ActionMap)serializable).get(this.getPropertyPrefix() + ".commandSound")) != null) {
            BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        }
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        if ((serializable = EventQueue.getCurrentEvent()) instanceof MouseEvent && !SwingUtilities.isLeftMouseButton((MouseEvent)serializable)) {
            return;
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String string = this.menuItem.getActionCommand();
        return string == "Close" || string == "Minimize" || string == "Restore" || string == "Maximize";
    }

    protected String getAcceleratorSequenceText(JMenuItem jMenuItem) {
        KeyStroke[] keyStrokeArray;
        String string = "";
        Action action = jMenuItem.getAction();
        if (action instanceof ExtendedAction && (keyStrokeArray = ((ExtendedAction)action).getAcceleratorSequence()) != null) {
            string = KeyStrokeUtils.translateKeyStrokes(new KeyStrokeList(keyStrokeArray));
        }
        return string;
    }

    static {
        if (PlatformInfo.isWindowsVistaAppearance()) {
            UIManager.put("MenuItem.selectionForeground", Color.BLACK);
        }
        zeroRect = new Rectangle(0, 0, 0, 0);
        iconRect = new Rectangle();
        textRect = new Rectangle();
        acceleratorRect = new Rectangle();
        checkIconRect = new Rectangle();
        arrowIconRect = new Rectangle();
        viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        r = new Rectangle();
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                MBasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            int n = MBasicMenuItemUI.this.menuItem.getMnemonic();
            if (n == 0 || menuKeyEvent.getPath().length != 2) {
                return;
            }
            if (this.lower((char)n) == this.lower(menuKeyEvent.getKeyChar())) {
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                MBasicMenuItemUI.this.doClick(menuSelectionManager);
                menuKeyEvent.consume();
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c) {
            return Character.toLowerCase(c);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < MBasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < MBasicMenuItemUI.this.menuItem.getHeight()) {
                MBasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < MBasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < MBasicMenuItemUI.this.menuItem.getHeight()) {
                MBasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(MBasicMenuItemUI.this.getPath());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n2 = menuElementArray.length - 1;
                    for (int i = 0; i < n2; ++i) {
                        menuElementArray2[i] = menuElementArray[i];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

