/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.window.MJFullWindowRegistry;
import com.mathworks.util.HWndProvider;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public class MJWindow
extends JWindow
implements HWndProvider {
    protected boolean fNativeEventsEnabled;
    static final String CLOSE_ACTION = "close-window";

    public MJWindow() {
        MJFullWindowRegistry.register(this);
    }

    public MJWindow(Frame frame) {
        super(frame);
        MJFullWindowRegistry.register(this);
    }

    public MJWindow(Window window) {
        super(window);
        MJFullWindowRegistry.register(this);
    }

    public MJWindow(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        MJFullWindowRegistry.register(this);
    }

    public MJWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        MJFullWindowRegistry.register(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.fNativeEventsEnabled) {
            MJWindow.enableNativeEvents(this);
            this.fNativeEventsEnabled = true;
        }
    }

    @Override
    public void dispose() {
        MJFullWindowRegistry.unregister(this);
        if (this.fNativeEventsEnabled) {
            MJWindow.disableNativeEvents(this);
            this.fNativeEventsEnabled = false;
        }
        super.dispose();
    }

    static void disableNativeEvents(Window window) {
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            NativeJava.disableNativeEvents((long)NativeJava.hWndFromWindow((Window)window));
        }
    }

    static void enableNativeEvents(Window window) {
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            NativeJava.enableNativeEvents((Window)window, (long)NativeJava.hWndFromWindow((Window)window));
        }
    }

    public long getHWnd() {
        return NativeJava.getHWnd((Window)this);
    }

    static class EscapeAction
    extends AbstractAction
    implements KeyListener {
        private Window fWindow;

        EscapeAction() {
        }

        void attachTo(JFrame jFrame) {
            this.fWindow = jFrame;
            this.attachTo(jFrame.getRootPane());
        }

        void attachTo(JDialog jDialog) {
            this.fWindow = jDialog;
            this.attachTo(jDialog.getRootPane());
            jDialog.addKeyListener(this);
        }

        private void attachTo(JRootPane jRootPane) {
            InputMap inputMap = jRootPane.getInputMap(1);
            InputMap inputMap2 = new InputMap();
            inputMap2.setParent(inputMap);
            inputMap2.put(KeyStroke.getKeyStroke(27, 0), MJWindow.CLOSE_ACTION);
            jRootPane.setInputMap(1, inputMap2);
            ActionMap actionMap = jRootPane.getActionMap();
            actionMap.put(MJWindow.CLOSE_ACTION, this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray != null && menuElementArray.length > 0) {
                if (menuElementArray.length > 1) {
                    int n = 1;
                    int n2 = menuElementArray.length - 1;
                    while (n2 > 0 && !(menuElementArray[n2] instanceof JMenu)) {
                        --n2;
                        ++n;
                    }
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - n];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - n);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else {
                    menuSelectionManager.clearSelectedPath();
                }
            } else if (this.fWindow != null) {
                WindowEvent windowEvent = new WindowEvent(this.fWindow, 201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                this.actionPerformed(null);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

