/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import com.sun.java.swing.plaf.windows.WindowsMenuUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

public class MJMenu
extends JMenu {
    public static final String CORRECTED_WINDOWS_MARGINS_CLIENT_PROPERTY = "correctedWindowsMargins";
    private static final String BASE_NAME = "Menu";

    public MJMenu() {
    }

    public MJMenu(Action action) {
        super(action);
    }

    public MJMenu(String string) {
        this.setText(string);
    }

    public MJMenu(String string, boolean bl) {
        super(string, bl);
        this.setText(string);
    }

    @Override
    public void updateUI() {
        if (PlafUtils.isWindowsLookAndFeel()) {
            this.setUI((MenuItemUI)((Object)new MWindowsMenuUI()));
        } else {
            super.updateUI();
        }
    }

    @Override
    public Color getForeground() {
        return PlatformInfo.isWindowsVistaAppearance() && !this.isEnabled() ? UIManager.getColor("Menu.foreground") : super.getForeground();
    }

    @Override
    public JMenuItem add(Action action) {
        return this.add(new MJMenuItem(action));
    }

    @Override
    public JMenuItem add(JMenuItem jMenuItem) {
        this.removeMnemonicIfContextMenu(jMenuItem);
        BareSwingDetector.exempt();
        JMenuItem jMenuItem2 = super.add(jMenuItem);
        BareSwingDetector.reinstate();
        return jMenuItem2;
    }

    @Override
    public JMenuItem insert(Action action, int n) {
        return this.insert(new MJMenuItem(action), n);
    }

    @Override
    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        BareSwingDetector.exempt();
        super.insert(jMenuItem, n);
        BareSwingDetector.reinstate();
        this.removeMnemonicIfContextMenu(jMenuItem);
        return jMenuItem;
    }

    private void removeMnemonicIfContextMenu(JMenuItem jMenuItem) {
        if (MJPopupMenu.isInContextMenu(this.getParent())) {
            MJPopupMenu.removeMnemonic(jMenuItem);
        }
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            super.setText(null);
            this.setMnemonic('\u0000');
            return;
        }
        super.setText(MJUtilities.exciseAmpersand(string));
        MJUtilities.setMnemonicFromText(this, string);
    }

    @Override
    public void setAction(Action action) {
        String string;
        Integer n;
        Action action2 = this.getAction();
        super.setAction(action);
        if (action == null) {
            if (action2 instanceof MJAbstractAction) {
                this.setName(BASE_NAME);
            }
            return;
        }
        if (action.getValue("ShortDescription") != null) {
            this.setToolTipText(null);
        }
        if ((n = (Integer)action.getValue("MnemonicIndex")) != null) {
            this.setDisplayedMnemonicIndex(n);
        }
        if ((string = (String)action.getValue("ComponentName")) != null) {
            this.setName(string + BASE_NAME);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        BareSwingDetector.exempt();
        JPopupMenu jPopupMenu = super.getPopupMenu();
        BareSwingDetector.reinstate();
        return jPopupMenu;
    }

    public void dispose() {
        MJMenu.dispose(this);
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        Integer n = action == null ? null : (Integer)action.getValue("MnemonicKey");
        this.setMnemonic(n == null ? 0 : n);
    }

    public static void dispose(JMenu jMenu) {
        MenuListener[] menuListenerArray;
        MJUtilities.dispose(jMenu);
        for (MenuListener menuListener : menuListenerArray = jMenu.getMenuListeners()) {
            jMenu.removeMenuListener(menuListener);
        }
        int n = jMenu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (component instanceof MJMenu) {
                ((MJMenu)component).dispose();
                continue;
            }
            if (component instanceof JMenu) {
                MJMenu.dispose((JMenu)component);
                continue;
            }
            if (!(component instanceof AbstractButton)) continue;
            MJUtilities.dispose((AbstractButton)component);
        }
    }

    private static class WindowsVistaPropertyChangeListener
    implements PropertyChangeListener {
        private Insets fOriginalMargin;

        private WindowsVistaPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("ancestor")) {
                this.correctWindowsMenuBarMargins((JMenu)propertyChangeEvent.getSource(), propertyChangeEvent.getNewValue() instanceof JMenuBar);
            }
        }

        private void correctWindowsMenuBarMargins(JMenu jMenu, boolean bl) {
            if (WindowsVistaPropertyChangeListener.shouldAddCorrectedMargins(jMenu, bl)) {
                Insets insets = jMenu.getMargin();
                if (insets != null) {
                    this.fOriginalMargin = insets;
                    Insets insets2 = new Insets(Math.max(insets.top, 4), Math.max(insets.left, 4), Math.max(insets.bottom, 5), Math.max(insets.right, 4));
                    jMenu.setMargin(insets2);
                    jMenu.putClientProperty(MJMenu.CORRECTED_WINDOWS_MARGINS_CLIENT_PROPERTY, Boolean.TRUE);
                }
            } else if (WindowsVistaPropertyChangeListener.shouldRemoveCorrectedMargins(jMenu, bl)) {
                jMenu.setMargin(this.fOriginalMargin);
                jMenu.putClientProperty(MJMenu.CORRECTED_WINDOWS_MARGINS_CLIENT_PROPERTY, null);
            }
        }

        private static boolean shouldAddCorrectedMargins(JMenu jMenu, boolean bl) {
            return bl && jMenu.getClientProperty(MJMenu.CORRECTED_WINDOWS_MARGINS_CLIENT_PROPERTY) == null;
        }

        private static boolean shouldRemoveCorrectedMargins(JMenu jMenu, boolean bl) {
            return !bl && jMenu.getClientProperty(MJMenu.CORRECTED_WINDOWS_MARGINS_CLIENT_PROPERTY) != null;
        }
    }

    private static class MWindowsMenuUI
    extends WindowsMenuUI {
        private PropertyChangeListener fVistaPropertyListener;

        private MWindowsMenuUI() {
        }

        protected void installListeners() {
            if (PlatformInfo.isWindowsVistaAppearance()) {
                this.fVistaPropertyListener = new WindowsVistaPropertyChangeListener();
                this.menuItem.addPropertyChangeListener(this.fVistaPropertyListener);
            }
            super.installListeners();
        }

        protected void uninstallListeners() {
            if (this.fVistaPropertyListener != null) {
                this.menuItem.removePropertyChangeListener(this.fVistaPropertyListener);
                this.fVistaPropertyListener = null;
            }
            super.uninstallListeners();
        }

        protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
            JMenu jMenu = (JMenu)jMenuItem;
            if (!jMenu.isTopLevelMenu() && jMenu.getIcon() == null) {
                rectangle.x = jMenuItem.getInsets().left + this.defaultTextIconGap + this.checkIcon.getIconWidth() + this.defaultTextIconGap;
            }
            super.paintText(graphics, jMenuItem, rectangle, string);
        }
    }
}

