/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class BorderUtils {
    public static Border correctEtchedIfHighContrast(Component component, Border border) {
        if (component == null) {
            throw new IllegalArgumentException("parentComponent cannot be null");
        }
        return MJUtilities.isHighContrast() ? BorderUtils.correctEtched(component, border) : border;
    }

    private static Border correctEtched(Component component, Border border) {
        if (border instanceof EtchedBorder) {
            EtchedBorder etchedBorder = BorderUtils.getNewBorderIfNotContrasting(component, (EtchedBorder)border);
            if (etchedBorder != null) {
                border = etchedBorder;
            }
        } else if (border instanceof CompoundBorder) {
            EtchedBorder etchedBorder = BorderUtils.getNewBorderIfNotContrasting(component, BorderUtils.findEtchedBorder((CompoundBorder)border));
            if (etchedBorder != null) {
                border = BorderUtils.replaceEtched(etchedBorder, (CompoundBorder)border);
            }
        } else if (border instanceof TitledBorder) {
            EtchedBorder etchedBorder;
            TitledBorder titledBorder = (TitledBorder)border;
            if (titledBorder.getBorder() instanceof EtchedBorder) {
                EtchedBorder etchedBorder2 = BorderUtils.getNewBorderIfNotContrasting(component, (EtchedBorder)titledBorder.getBorder());
                if (etchedBorder2 != null) {
                    border = BorderUtils.createNewTitledBorder(etchedBorder2, titledBorder);
                }
            } else if (titledBorder.getBorder() instanceof CompoundBorder && (etchedBorder = BorderUtils.getNewBorderIfNotContrasting(component, BorderUtils.findEtchedBorder((CompoundBorder)titledBorder.getBorder()))) != null) {
                border = BorderUtils.createNewTitledBorder(BorderUtils.replaceEtched(etchedBorder, (CompoundBorder)titledBorder.getBorder()), titledBorder);
            }
        }
        return border;
    }

    private static EtchedBorder getNewBorderIfNotContrasting(Component component, EtchedBorder etchedBorder) {
        EtchedBorder etchedBorder2 = null;
        Color color = component.getBackground();
        if (etchedBorder != null && color != null) {
            boolean bl;
            boolean bl2 = bl = ColorUtils.areContrasting(color, etchedBorder.getHighlightColor(component)) && ColorUtils.areContrasting(color, etchedBorder.getShadowColor(component));
            if (!bl) {
                Color color2 = ColorUtils.getBlackOrWhiteContrasting(color);
                etchedBorder2 = (EtchedBorder)BorderFactory.createEtchedBorder(etchedBorder.getEtchType(), color2, color2);
            }
        }
        return etchedBorder2;
    }

    private static TitledBorder createNewTitledBorder(Border border, TitledBorder titledBorder) {
        return BorderFactory.createTitledBorder(border, titledBorder.getTitle(), titledBorder.getTitleJustification(), titledBorder.getTitlePosition(), titledBorder.getTitleFont(), titledBorder.getTitleColor());
    }

    private static EtchedBorder findEtchedBorder(CompoundBorder compoundBorder) {
        EtchedBorder etchedBorder = null;
        if (compoundBorder.getInsideBorder() instanceof EtchedBorder) {
            etchedBorder = (EtchedBorder)compoundBorder.getInsideBorder();
        } else if (compoundBorder.getOutsideBorder() instanceof EtchedBorder) {
            etchedBorder = (EtchedBorder)compoundBorder.getOutsideBorder();
        } else if (compoundBorder.getInsideBorder() instanceof TitledBorder && ((TitledBorder)compoundBorder.getInsideBorder()).getBorder() instanceof EtchedBorder) {
            etchedBorder = (EtchedBorder)((TitledBorder)compoundBorder.getInsideBorder()).getBorder();
        } else if (compoundBorder.getOutsideBorder() instanceof TitledBorder && ((TitledBorder)compoundBorder.getOutsideBorder()).getBorder() instanceof EtchedBorder) {
            etchedBorder = (EtchedBorder)((TitledBorder)compoundBorder.getOutsideBorder()).getBorder();
        }
        return etchedBorder;
    }

    private static CompoundBorder replaceEtched(Border border, CompoundBorder compoundBorder) {
        CompoundBorder compoundBorder2 = null;
        if (compoundBorder.getInsideBorder() instanceof EtchedBorder) {
            compoundBorder2 = BorderFactory.createCompoundBorder(compoundBorder.getOutsideBorder(), border);
        } else if (compoundBorder.getOutsideBorder() instanceof EtchedBorder) {
            compoundBorder2 = BorderFactory.createCompoundBorder(border, compoundBorder.getInsideBorder());
        } else if (compoundBorder.getInsideBorder() instanceof TitledBorder && ((TitledBorder)compoundBorder.getInsideBorder()).getBorder() instanceof EtchedBorder) {
            compoundBorder2 = BorderFactory.createCompoundBorder(compoundBorder.getOutsideBorder(), BorderUtils.createNewTitledBorder(border, (TitledBorder)compoundBorder.getInsideBorder()));
        } else if (compoundBorder.getOutsideBorder() instanceof TitledBorder && ((TitledBorder)compoundBorder.getOutsideBorder()).getBorder() instanceof EtchedBorder) {
            compoundBorder2 = BorderFactory.createCompoundBorder(BorderUtils.createNewTitledBorder(border, (TitledBorder)compoundBorder.getOutsideBorder()), compoundBorder.getInsideBorder());
        }
        assert (compoundBorder2 != null) : "Shouldn't be null";
        return compoundBorder2;
    }

    private BorderUtils() {
    }
}

