/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk11;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.security.BoxedCode;
import ice.util.security.jdk11.URLClassLoader_jdk11;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;

public class SecurityManager_jdk11
extends SecurityManager {
    private final Class OEAB = class$java$lang$Runtime == null ? (class$java$lang$Runtime = SecurityManager_jdk11.class$("java.lang.Runtime")) : class$java$lang$Runtime;
    private final Class Z = class$java$lang$System == null ? (class$java$lang$System = SecurityManager_jdk11.class$("java.lang.System")) : class$java$lang$System;
    private final Class _threadGroup = class$java$lang$Thread == null ? (class$java$lang$Thread = SecurityManager_jdk11.class$("java.lang.Thread")) : class$java$lang$Thread;
    private final Class append = class$java$lang$ThreadGroup == null ? (class$java$lang$ThreadGroup = SecurityManager_jdk11.class$("java.lang.ThreadGroup")) : class$java$lang$ThreadGroup;
    private final String bug = (class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy == null ? (class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy = SecurityManager_jdk11.class$("ice.util.security.jdk11.SecurityManager_jdk11$PrivilegedProxy")) : class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy).getName();
    private final String callPrivileged = (class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy == null ? (class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy = SecurityManager_jdk11.class$("ice.util.security.jdk11.SecurityManager_jdk11$UntrustedProxy")) : class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy).getName();
    private final Object callUntrusted = new Object();
    private ThreadGroup checkConnect;
    private int class$ = Thread.currentThread().getPriority();
    private boolean classDepth;
    static Class class$java$lang$Runtime;
    static Class class$java$lang$System;
    static Class class$java$lang$Thread;
    static Class class$java$lang$ThreadGroup;
    static Class class$ice$util$security$jdk11$SecurityManager_jdk11$PrivilegedProxy;
    static Class class$ice$util$security$jdk11$SecurityManager_jdk11$UntrustedProxy;

    private SecurityException OEAB() {
        if (Debug.trace) {
            Debug.traceStack("constructing SecurityException");
        }
        return new SecurityException();
    }

    private boolean Z() {
        return this._threadGroup() < 0;
    }

    private int _threadGroup() {
        int n;
        int n2 = this.classDepth(this.callPrivileged);
        int n3 = this.classLoaderDepth();
        if (n2 >= 0) {
            if (0 <= n3 && n3 < n2) {
                n2 = n3;
            }
        } else {
            n2 = n3;
        }
        if (n2 >= 0 && 0 <= (n = this.classDepth(this.bug)) && n < n2) {
            n2 = -1;
        }
        return n2;
    }

    Object doPrivileged(BoxedCode boxedCode) {
        int n;
        if (2 != this.classDepth("ice.util.security.SecurityKit")) {
            Debug.bug();
        }
        if (0 <= (n = this.classLoaderDepth()) && n <= 4) {
            throw this.OEAB();
        }
        return PrivilegedProxy.callPrivileged(boxedCode);
    }

    Object doUntrusted(BoxedCode boxedCode) {
        return UntrustedProxy.callUntrusted(boxedCode);
    }

    private URLClassLoader_jdk11 append() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader instanceof URLClassLoader_jdk11) {
            return (URLClassLoader_jdk11)classLoader;
        }
        return null;
    }

    public Object getSecurityContext() {
        URLClassLoader_jdk11 uRLClassLoader_jdk11 = this.append();
        if (uRLClassLoader_jdk11 != null) {
            return uRLClassLoader_jdk11.getSecurityContext();
        }
        return null;
    }

    public void checkCreateClassLoader() {
        if (this.Z()) {
            return;
        }
        throw this.OEAB();
    }

    public void checkAccess(Thread thread) {
        if (this.Z()) {
            return;
        }
        String string = thread.getClass().getName();
        if (!string.equals("java.awt.EventDispatchThread")) {
            return;
        }
        throw this.OEAB();
    }

    public ThreadGroup getThreadGroup() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (this.Z()) {
            return threadGroup;
        }
        URLClassLoader_jdk11 uRLClassLoader_jdk11 = this.append();
        if (uRLClassLoader_jdk11 != null) {
            Object object = this.callUntrusted;
            synchronized (object) {
                this.classDepth = true;
                try {
                    threadGroup = this.bug(uRLClassLoader_jdk11);
                    Object var6_5 = null;
                    this.classDepth = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.classDepth = false;
                    throw throwable;
                }
            }
            return threadGroup;
        }
        throw this.OEAB();
    }

    private ThreadGroup bug(URLClassLoader_jdk11 uRLClassLoader_jdk11) {
        ThreadGroup threadGroup = uRLClassLoader_jdk11._threadGroup;
        if (threadGroup == null) {
            if (this.checkConnect == null) {
                this.checkConnect = new ThreadGroup("Untrusted threads root");
            }
            if ((threadGroup = new UnprivilegedGroup(this.checkConnect)).getMaxPriority() > this.class$) {
                threadGroup.setMaxPriority(this.class$);
            }
            uRLClassLoader_jdk11._threadGroup = threadGroup;
        }
        return threadGroup;
    }

    public void checkAccess(ThreadGroup threadGroup) {
        Class<?>[] classArray;
        int n = this._threadGroup();
        if (n < 0) {
            return;
        }
        Object object = this.callUntrusted;
        synchronized (object) {
            if (this.classDepth) {
                return;
            }
        }
        if (threadGroup instanceof UnprivilegedGroup && (classArray = this.getClassContext())[1] == this.append && classArray[2] == this._threadGroup) {
            return;
        }
        int n2 = this.classDepth("sun.awt.image.ImageFetcher");
        if (0 <= n2 && n2 < n) {
            return;
        }
        throw this.OEAB();
    }

    public void checkExit(int n) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkExec(String string) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkLink(String string) {
        int n = this._threadGroup();
        if (n < 0) {
            return;
        }
        Class<?>[] classArray = this.getClassContext();
        if (classArray[1] == this.OEAB) {
            int n2 = 2;
            if (classArray[n2] == this.Z) {
                ++n2;
            }
            if (n2 < n) {
                String string2;
                if (classArray[n2].getClassLoader() != null) {
                    Debug.bug();
                }
                if ((string2 = classArray[n2].getName()).startsWith("java.")) {
                    return;
                }
            }
        }
        throw this.OEAB();
    }

    public void checkPropertiesAccess() {
        if (this.Z()) {
            return;
        }
    }

    public void checkPropertyAccess(String string) {
        if (this.Z()) {
            return;
        }
        if (string.equals("java.home") || string.equals("java.class.path") || string.startsWith("user.")) {
            throw this.OEAB();
        }
    }

    public void checkRead(String string) {
        this.callPrivileged(string, null);
    }

    public void checkRead(String string, Object object) {
        this.callPrivileged(string, object);
    }

    private void callPrivileged(String string, Object object) {
        int n = this._threadGroup();
        if (n < 0) {
            return;
        }
        int n2 = this.classDepth("java.util.ResourceBundle");
        if (0 <= n2 && n2 < n) {
            return;
        }
        throw this.OEAB();
    }

    public void checkWrite(String string) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkDelete(String string) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (fileDescriptor.valid()) {
            int n = this._threadGroup();
            if (n < 0) {
                return;
            }
            int n2 = this.classDepth("java.net.SocketInputStream");
            if (0 <= n2 && n2 < n) {
                return;
            }
        }
        throw this.OEAB();
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (fileDescriptor.valid()) {
            int n = this._threadGroup();
            if (n < 0) {
                return;
            }
            int n2 = this.classDepth("java.net.SocketOutputStream");
            if (0 <= n2 && n2 < n) {
                return;
            }
        }
        throw this.OEAB();
    }

    public void checkListen(int n) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkAccept(String string, int n) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkConnect(String string, int n) {
        this.checkConnect(string, n, this.getSecurityContext());
    }

    public void checkConnect(String string, int n, Object object) {
        URL uRL;
        String string2;
        if (this.Z()) {
            return;
        }
        if (object instanceof URL && this.callUntrusted(string2 = (uRL = (URL)object).getHost(), string)) {
            return;
        }
        throw this.OEAB();
    }

    private boolean callUntrusted(String string, String string2) {
        boolean bl;
        Object object = this.callUntrusted;
        synchronized (object) {
            try {
                this.inCheck = true;
                bl = SecurityManager_jdk11.checkConnect(string, string2);
                Object var6_5 = null;
                this.inCheck = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.inCheck = false;
                throw throwable;
            }
        }
        return bl;
    }

    private static boolean checkConnect(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (string2.length() == 0) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            InetAddress inetAddress2 = InetAddress.getByName(string);
            if (inetAddress2.equals(inetAddress)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public boolean checkTopLevelWindow(Object object) {
        return this.Z();
    }

    public void checkPackageAccess(String string) {
        if (this.Z()) {
            return;
        }
        boolean bl = false;
        if (string.startsWith("ice.util.security")) {
            bl = true;
        } else {
            String string2;
            int n = -1;
            do {
                string2 = (n = string.indexOf(46, n + 1)) < 0 ? string : string.substring(0, n);
                if (!Defs.sysPropertyBoolean("package.restrict.access." + string2)) continue;
                bl = true;
                break;
            } while (string2 != string);
        }
        if (bl) {
            throw this.OEAB();
        }
    }

    public void checkPackageDefinition(String string) {
        if (this.Z()) {
            return;
        }
        boolean bl = false;
        if (string.startsWith("ice.util.security")) {
            bl = true;
        } else if (string.startsWith("java.")) {
            bl = true;
        } else {
            String string2;
            int n = -1;
            do {
                string2 = (n = string.indexOf(46, n + 1)) < 0 ? string : string.substring(0, n);
                if (!Defs.sysPropertyBoolean("package.restrict.definition." + string2)) continue;
                bl = true;
                break;
            } while (string2 != string);
        }
        if (bl) {
            throw this.OEAB();
        }
    }

    public void checkSetFactory() {
        if (this.Z()) {
            return;
        }
        throw this.OEAB();
    }

    public void checkPrintJobAccess() {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkSystemClipboardAccess() {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        ClassLoader classLoader;
        boolean bl = false;
        String string = clazz.getName();
        if (string.startsWith("ice.util.security.")) {
            bl = true;
        }
        if (n != 0 && (classLoader = this.currentClassLoader()) != null && classLoader != clazz.getClassLoader()) {
            bl = true;
        }
        if (bl) {
            throw this.OEAB();
        }
    }

    public void checkSecurityAccess(String string) {
        if (!this.Z()) {
            throw this.OEAB();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class UntrustedProxy {
        private UntrustedProxy() {
        }

        static Object callUntrusted(BoxedCode boxedCode) {
            try {
                return boxedCode.run();
            }
            catch (RuntimeException runtimeException) {
                if (Debug.trace) {
                    Debug.trace("Exception in " + boxedCode + ": " + runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    private static class PrivilegedProxy {
        private PrivilegedProxy() {
        }

        static Object callPrivileged(BoxedCode boxedCode) {
            try {
                return boxedCode.run();
            }
            catch (RuntimeException runtimeException) {
                if (Debug.trace) {
                    Debug.trace("Exception in " + boxedCode + ": " + runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    private static class UnprivilegedGroup
    extends ThreadGroup {
        UnprivilegedGroup(ThreadGroup threadGroup) {
            super(threadGroup, "");
        }
    }
}

