/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class ExcludingLookup
extends Lookup {
    private Lookup delegate;
    private Object classes;

    ExcludingLookup(Lookup lookup, Class[] classArray) {
        this.delegate = lookup;
        this.classes = classArray.length == 1 ? classArray[0] : classArray;
    }

    public String toString() {
        return "ExcludingLookup: " + this.delegate + " excludes: " + Arrays.asList(this.classes());
    }

    @Override
    public Lookup.Result lookup(Lookup.Template template) {
        if (template == null) {
            throw new NullPointerException();
        }
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return Lookup.EMPTY.lookup(template);
        }
        return new R(template.getType(), this.delegate.lookup(template));
    }

    @Override
    public Object lookup(Class clazz) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(clazz)) {
            return null;
        }
        Object object = this.delegate.lookup(clazz);
        if (this.isObjectAccessible(clazz, object, 0)) {
            return object;
        }
        return null;
    }

    @Override
    public Lookup.Item lookupItem(Lookup.Template template) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return null;
        }
        Lookup.Item item = this.delegate.lookupItem(template);
        if (this.isObjectAccessible(template.getType(), item, 2)) {
            return item;
        }
        return null;
    }

    private boolean areSubclassesOfThisClassAlwaysExcluded(Class clazz) {
        Class[] classArray = this.classes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    final Class[] classes() {
        if (this.classes instanceof Class[]) {
            return (Class[])this.classes;
        }
        return new Class[]{(Class)this.classes};
    }

    private static boolean isAccessible(Class[] classArray, Class clazz, Class clazz2) {
        if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (clazz2 != classArray[i]) continue;
            return false;
        }
        if (clazz == clazz2) {
            return true;
        }
        if (ExcludingLookup.isAccessible(classArray, clazz, clazz2.getSuperclass())) {
            return true;
        }
        Class<?>[] classArray2 = clazz2.getInterfaces();
        for (int i = 0; i < classArray2.length; ++i) {
            if (!ExcludingLookup.isAccessible(classArray, clazz, classArray2[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean isObjectAccessible(Class clazz, Object object, int n) {
        if (object == null) {
            return false;
        }
        return ExcludingLookup.isObjectAccessible(this.classes(), clazz, object, n);
    }

    static final boolean isObjectAccessible(Class[] classArray, Class clazz, Object object, int n) {
        if (object == null) {
            return false;
        }
        switch (n) {
            case 0: {
                return ExcludingLookup.isAccessible(classArray, clazz, object.getClass());
            }
            case 1: {
                return ExcludingLookup.isAccessible(classArray, clazz, (Class)object);
            }
            case 2: {
                Lookup.Item item = (Lookup.Item)object;
                return ExcludingLookup.isAccessible(classArray, clazz, item.getType());
            }
        }
        throw new IllegalStateException("Type: " + n);
    }

    final Collection filter(Class[] classArray, Class clazz, Collection hashSet, int n) {
        AbstractCollection abstractCollection = null;
        while (true) {
            for (Object e : hashSet) {
                if (!ExcludingLookup.isObjectAccessible(classArray, clazz, e, n)) {
                    if (abstractCollection != null) continue;
                    if (n == 1) {
                        abstractCollection = new HashSet();
                        continue;
                    }
                    abstractCollection = new ArrayList(hashSet.size());
                    continue;
                }
                if (abstractCollection == null) continue;
                abstractCollection.add(e);
            }
            break;
        }
        return abstractCollection != null ? abstractCollection : hashSet;
    }

    private final class R
    extends WaitableResult
    implements LookupListener {
        private Lookup.Result result;
        private Object listeners;
        private Class from;

        R(Class clazz, Lookup.Result result) {
            this.from = clazz;
            this.result = result;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            if (this.result instanceof WaitableResult) {
                ((WaitableResult)this.result).beforeLookup(template);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener lookupListener) {
            boolean bl;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(true, lookupListener, this.listeners);
                bl = this.listeners != null;
            }
            if (bl) {
                this.result.addLookupListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            boolean bl;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(false, lookupListener, this.listeners);
                bl = this.listeners == null;
            }
            if (bl) {
                this.result.removeLookupListener(this);
            }
        }

        @Override
        public Collection allInstances() {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allInstances(), 0);
        }

        @Override
        public Set allClasses() {
            return (Set)ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allClasses(), 1);
        }

        @Override
        public Collection allItems() {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allItems(), 2);
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            if (lookupEvent.getSource() == this.result) {
                this.collectFires(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection collection) {
            Object[] objectArray = this;
            synchronized (this) {
                Serializable serializable;
                Object[] objectArray2;
                if (this.listeners == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    objectArray2 = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    serializable = (ArrayList)this.listeners;
                    objectArray2 = serializable.toArray(new LookupListener[serializable.size()]);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                objectArray = objectArray2;
                serializable = new LookupEvent((Lookup.Result)this);
                AbstractLookup.notifyListeners(objectArray, (LookupEvent)serializable, collection);
                return;
            }
        }
    }
}

