/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class WeakIdentityMap {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object put(Object object, Object object2) {
        this.processQueue();
        return this.map.put(Key.create(object, this.queue), object2);
    }

    public Object get(Object object) {
        this.processQueue();
        return this.map.get(Key.create(object, null));
    }

    public Object remove(Object object) {
        this.processQueue();
        return this.map.remove(Key.create(object, null));
    }

    public Collection values() {
        this.processQueue();
        return this.map.values();
    }

    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    private void processQueue() {
        Key key;
        while ((key = (Key)this.queue.poll()) != null) {
            this.map.remove(key);
        }
    }

    private static class Key
    extends WeakReference {
        private final int hash;

        static Key create(Object object, ReferenceQueue referenceQueue) {
            if (object == null) {
                return null;
            }
            if (referenceQueue == null) {
                return new Key(object);
            }
            return new Key(object, referenceQueue);
        }

        private Key(Object object) {
            super(object);
            this.hash = System.identityHashCode(object);
        }

        private Key(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = System.identityHashCode(object);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Object t = this.get();
            Object t2 = ((Key)object).get();
            return t != null && t2 != null && t == t2;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

