/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.tabcompletion;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.tabcompletion.TabCompletion;
import com.mathworks.jmi.tabcompletion.TabCompletionImpl;
import com.mathworks.jmi.tabcompletion.TabCompletionResults;
import com.mathworks.mlwidgets.tabcompletion.MatlabTabContext;
import com.mathworks.mlwidgets.tabcompletion.SystemTabCompletionResult;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionExecutionListener;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionInterface;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionPrefs;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionResult;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionView;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Log;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.apache.commons.lang.Validate;

public class TabCompletionAction
extends MJAbstractAction {
    private final TabCompletion fCompletion;
    private TabCompletionInterface fTabCompletionImplementation;
    private TabCompletionView fView;
    private TabFinishedActionListener fTabFinish = new TabFinishedActionListener();
    public static final String TAB_ACTION = "insert-tab";
    private int fStartOffset = -1;
    private boolean fTesting = false;
    private String fWholeLine;
    private final TextInsertedAfterTabListener fTextInsertListener;

    public TabCompletionAction(TabCompletionInterface tabCompletionInterface) {
        super(TAB_ACTION);
        Validate.notNull((Object)tabCompletionInterface, (String)"tabCompletionInterface cannot be null.");
        this.fTabCompletionImplementation = tabCompletionInterface;
        TabCompletionExecutionListener.getInstance();
        this.fTextInsertListener = new TextInsertedAfterTabListener();
        this.fCompletion = new TabCompletionImpl();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (TabCompletionExecutionListener.getInstance().isInInputMode() || TabCompletionExecutionListener.getInstance().isCommandBusy() || this.fView != null && this.fView.isWaitingForCompletions() || this.fTabCompletionImplementation.isComposing()) {
            return;
        }
        if (!this.fTabCompletionImplementation.isTabCompletionEnabled()) {
            Action action = (Action)this.fTabCompletionImplementation.getDefaultInsertTabAction();
            action.actionPerformed(actionEvent);
            return;
        }
        if (this.fView == null) {
            this.fView = new TabCompletionView(this.fTabCompletionImplementation);
            this.fView.addTabFinishListener(this.fTabFinish);
        }
        this.fView.setTabKeyAction();
        this.fView.setWaitingForCompletions(true);
        this.fTabCompletionImplementation.tabCompletionStarted();
        this.getStringMatches();
    }

    private void getStringMatches() {
        Segment segment = new Segment();
        this.fStartOffset = this.fTabCompletionImplementation.getComponent().getCaret().getDot();
        this.fView.setStartOffset(this.fStartOffset);
        int n = this.fTabCompletionImplementation.getTabCompletionStartOffset();
        assert (n <= this.fStartOffset) : "Start tab context offset must be less than caret position";
        int n2 = this.fStartOffset - n;
        try {
            this.fTabCompletionImplementation.getComponent().getDocument().getText(n, n2, segment);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            this.cleanup();
            return;
        }
        if (TabCompletionAction.isWhitespace(segment)) {
            this.cleanUpState();
            return;
        }
        int n3 = segment.getBeginIndex() + n2;
        int n4 = TabCompletionAction.getWordStart(segment, n3);
        if (n4 == -1) {
            Log.printLn((String)"Unable to find value for offset to whole word in tab completion");
            this.cleanUpState();
            return;
        }
        this.fView.setWordOffset(this.fStartOffset - (n3 - n4));
        this.fWholeLine = segment.toString();
        this.fView.setWaitingForCompletions(true);
        if (!TabCompletionExecutionListener.getInstance().isInInputMode()) {
            if (!this.fTesting) {
                this.fTextInsertListener.reset();
                this.fTabCompletionImplementation.getComponent().addKeyListener(this.fTextInsertListener);
                this.fCompletion.setMaxResultsBeforeWarning(TabCompletionPrefs.getTooManyTabResultsWarning());
                final Future future = this.fCompletion.getCompletions(this.fWholeLine);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TabCompletionResults tabCompletionResults = (TabCompletionResults)future.get();
                            MatlabTabContext.setStatus(tabCompletionResults.getStatus());
                            TabCompletionAction.this.completed(TabCompletionAction.convertResults(tabCompletionResults.getStrings()));
                        }
                        catch (Exception exception) {
                            Log.logException((Exception)exception);
                        }
                    }
                }).start();
            }
        } else {
            this.fView.cleanup();
        }
    }

    public void cleanup() {
        if (this.fView != null) {
            this.fView.removeTabFinishListenerAndCleanup();
        }
        this.fTabFinish = null;
        this.fTabCompletionImplementation = null;
        this.fView = null;
    }

    static boolean isWhitespace(CharacterIterator characterIterator) {
        char c = characterIterator.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c)) {
                return false;
            }
            c = characterIterator.next();
        }
        return true;
    }

    static int getWordStart(Segment segment, int n) {
        char c;
        segment.setIndex(n);
        int n2 = -1;
        while ((c = segment.previous()) != '\uffff') {
            if (c != '\'' && c != '(' && c != ' ' && c != File.separatorChar && c != '!' && c != '~') continue;
            n2 = segment.getIndex() + 1;
            break;
        }
        if (c == '\uffff') {
            n2 = segment.getBeginIndex();
        }
        return n2;
    }

    private static List<TabCompletionResult> convertResults(List<String> list) {
        ArrayList<TabCompletionResult> arrayList = new ArrayList<TabCompletionResult>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new SystemTabCompletionResult(list.get(i), i));
        }
        return arrayList;
    }

    private void completed(final List<TabCompletionResult> list) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TabCompletionAction.this.fTabCompletionImplementation.getComponent().removeKeyListener(TabCompletionAction.this.fTextInsertListener);
                if (TabCompletionAction.this.fTextInsertListener.textInserted()) {
                    TabCompletionAction.this.cleanUpState();
                } else {
                    List<TabCompletionResult> list2 = TabCompletionAction.this.fTabCompletionImplementation.getAdditionalTabCompletions(TabCompletionAction.this.fStartOffset, TabCompletionAction.this.fWholeLine);
                    TabCompletionAction.this.fView.showPopup(list, list2, TabCompletionAction.this.fStartOffset);
                }
            }
        });
    }

    private void cleanUpState() {
        this.fView.setWaitingForCompletions(false);
    }

    private void insertStringOnEventThread(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = TabCompletionAction.this.fTabCompletionImplementation.getComponent().getCaret().getDot();
                try {
                    if (TabCompletionAction.this.fStartOffset < n) {
                        TabCompletionAction.this.fTabCompletionImplementation.getComponent().getDocument().remove(TabCompletionAction.this.fStartOffset, n - TabCompletionAction.this.fStartOffset);
                    }
                    TabCompletionAction.this.fTabCompletionImplementation.getComponent().getDocument().insertString(TabCompletionAction.this.fStartOffset, string, null);
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                    TabCompletionAction.this.fView.cleanup();
                }
            }
        });
    }

    private void setTestingFlag(boolean bl) {
        this.fTesting = bl;
    }

    private class TextInsertedAfterTabListener
    extends KeyAdapter {
        private boolean iKeyPressedWhileWaiting;
        private boolean iTabHit;

        private TextInsertedAfterTabListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            KeyBindingManager keyBindingManager = MatlabKeyBindings.getManager();
            List list = keyBindingManager.getCurrentKeyBindingSet().getKeyBindings(TabCompletionAction.this.fTabCompletionImplementation.getKeybindingContext(), keyBindingManager.getActionData(TabCompletionAction.TAB_ACTION));
            boolean bl = false;
            for (KeyStrokeList keyStrokeList : list) {
                for (KeyStroke keyStroke : keyStrokeList.getKeyStrokes()) {
                    bl = bl || keyEvent.getKeyCode() == keyStroke.getKeyCode() && keyEvent.getModifiers() == keyStroke.getModifiers();
                }
            }
            if (bl) {
                this.iTabHit = true;
            } else if (this.iTabHit) {
                this.iKeyPressedWhileWaiting = true;
            }
        }

        private void reset() {
            this.iTabHit = false;
            this.iKeyPressedWhileWaiting = false;
        }

        private boolean textInserted() {
            return this.iKeyPressedWhileWaiting;
        }
    }

    private class TabCompletionStringReadyObserver
    implements CompletionObserver {
        private TabCompletionStringReadyObserver() {
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            TabCompletionAction.this.insertStringOnEventThread(string);
            TabCompletionAction.this.cleanUpState();
        }
    }

    private class TabFinishedActionListener
    extends MJAbstractAction {
        private TabFinishedActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = new Integer(actionEvent.getActionCommand());
            if (n == -2) {
                TabCompletionAction.this.cleanUpState();
            } else if (n == -3) {
                TabCompletionAction.this.cleanUpState();
                TabCompletionAction.this.getStringMatches();
            } else if (!TabCompletionAction.this.fTesting) {
                this.insertCompletion(n);
            }
        }

        private void insertCompletion(int n) {
            TabCompletionAction.this.fView.readySelectionForInsertion(new TabCompletionStringReadyObserver(), n);
        }
    }
}

