/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutTreePanel;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.WindowUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ShortcutsOrganizer
extends MJFrame {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");
    private static ShortcutsOrganizer sMe;
    private ShortcutTreePanel fTree;
    private MJButton fNewCatButton;
    private MJButton fMoveButton;
    private MJButton fEditButton;
    private MJButton fDeleteButton;
    private MJButton fMoveUpButton;
    private MJButton fMoveDownButton;

    private ShortcutsOrganizer(Frame frame) {
        sMe = this;
        this.setName("ShortcutsOrganizer");
        this.getAccessibleContext().setAccessibleName("Shortcut Organizer");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, 4dlu, fill:pref:grow, 4dlu, pref", "fill:pref:grow"));
        panelBuilder.setDefaultDialogBorder();
        this.setContentPane(panelBuilder.getPanel());
        this.fTree = new ShortcutTreePanel();
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 0;
        MJPanel mJPanel2 = new MJPanel((LayoutManager)gridBagLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.getContentPane().add((Component)mJPanel, cellConstraints.xy(1, 1));
        this.getContentPane().add((Component)((Object)this.fTree), cellConstraints.xy(3, 1));
        panelBuilder.add((Component)mJPanel2, cellConstraints.xy(5, 1));
        this.fTree.setName("ShortcutTreePanel");
        this.fNewCatButton = new MJButton((Action)((Object)new CreateFavoriteCatAction()));
        this.fNewCatButton.setName("NewCatButton");
        this.fNewCatButton.getAccessibleContext().setAccessibleName(sRes.getString("acc.NewCategory"));
        this.fNewCatButton.setToolTipText(null);
        MJButton mJButton = new MJButton((Action)((Object)new CreateShortcutAction()));
        mJButton.setName("NewShortcutButton");
        mJButton.getAccessibleContext().setAccessibleName(sRes.getString("acc.NewShortcut"));
        mJButton.setToolTipText(null);
        this.fEditButton = new MJButton((Action)((Object)new EditFavoriteAction()));
        this.fEditButton.setName("EditButton");
        this.fEditButton.getAccessibleContext().setAccessibleName(sRes.getString("action.EditFavToolTip"));
        this.fEditButton.setToolTipText(null);
        this.fMoveButton = new MJButton((Action)((Object)new MoveFavoriteAction()));
        this.fMoveButton.setName("MoveButton");
        this.fMoveButton.getAccessibleContext().setAccessibleName(sRes.getString("acc.Move"));
        this.fMoveButton.setToolTipText(null);
        this.fDeleteButton = new MJButton((Action)((Object)new RemoveFavoriteAction()));
        this.fDeleteButton.setName("DeleteButton");
        this.fDeleteButton.getAccessibleContext().setAccessibleName(sRes.getString("acc.Delete"));
        this.fDeleteButton.setToolTipText(null);
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addButtons(new JButton[]{this.fNewCatButton, mJButton, this.fEditButton, this.fMoveButton, this.fDeleteButton});
        mJPanel.add((Component)buttonStackBuilder.getPanel(), (Object)"North");
        this.fMoveUpButton = new MJButton((Action)((Object)new MoveUpAx()));
        this.fMoveUpButton.setName("MoveUpButton");
        this.fMoveUpButton.getAccessibleContext().setAccessibleName(sRes.getString("action.MoveUp"));
        this.fMoveDownButton = new MJButton((Action)((Object)new MoveDownAx()));
        this.fMoveDownButton.setName("MoveDownButton");
        this.fMoveDownButton.getAccessibleContext().setAccessibleName(sRes.getString("action.MoveDown"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 0, 2, 0);
        gridBagLayout.setConstraints((Component)this.fMoveUpButton, gridBagConstraints);
        this.fMoveUpButton.setMargin(new Insets(2, 2, 2, 2));
        mJPanel2.add((Component)this.fMoveUpButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.insets = new Insets(2, 0, 4, 0);
        gridBagLayout.setConstraints((Component)this.fMoveDownButton, gridBagConstraints);
        mJPanel2.add((Component)this.fMoveDownButton);
        this.fMoveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.fMoveDownButton.setDefaultCapable(false);
        this.fMoveUpButton.setDefaultCapable(false);
        ShortcutsOrganizer.enableDisableMoveToCatButton(false);
        ShortcutsOrganizer.enableDisableEditButton(false);
        ShortcutsOrganizer.enableDisableDeleteButton(false, false);
        ShortcutsOrganizer.enableDisableMoveUpButton(false);
        ShortcutsOrganizer.enableDisableMoveDownButton(false);
        MJButton mJButton2 = new MJButton((Action)((Object)new CloseAction()));
        mJButton2.setName("CloseButton");
        mJButton2.getAccessibleContext().setAccessibleName(sRes.getString("button.Close"));
        mJButton2.setToolTipText(null);
        MJButton mJButton3 = new MJButton((Action)((Object)new HelpAction()));
        mJButton3.setName("HelpButton");
        mJButton3.getAccessibleContext().setAccessibleName(sRes.getString("acc.Help"));
        mJButton3.setNextFocusableComponent((Component)this.fTree.getTree());
        mJButton3.setToolTipText(null);
        if (this.fMoveUpButton.isEnabled()) {
            this.fTree.setNextFocusableComponent((Component)this.fMoveUpButton);
        } else {
            this.fTree.setNextFocusableComponent((Component)this.fNewCatButton);
        }
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.add((Component)mJButton2);
        mJPanel3.add((Component)mJButton3);
        mJPanel.add((Component)mJPanel3, (Object)"South");
        this.pack();
        this.setTitle(sRes.getString("organizer.Title"));
        WindowUtils.centerWindowOnScreen((Window)((Object)this));
        this.setVisible(true);
    }

    public static void invoke(Frame frame) {
        if (sMe == null) {
            sMe = new ShortcutsOrganizer(frame);
        } else {
            sMe.setVisible(true);
        }
    }

    static void enableDisableMoveToCatButton(boolean bl) {
        if (sMe != null) {
            ShortcutsOrganizer.sMe.fMoveButton.setEnabled(bl);
        }
    }

    static void enableDisableEditButton(boolean bl) {
        if (sMe != null) {
            ShortcutsOrganizer.sMe.fEditButton.setEnabled(bl);
        }
    }

    static void enableDisableMoveUpButton(boolean bl) {
        if (sMe != null) {
            ShortcutsOrganizer.sMe.fMoveUpButton.setEnabled(bl);
            if (bl) {
                ShortcutsOrganizer.sMe.fTree.setNextFocusableComponent((Component)ShortcutsOrganizer.sMe.fMoveUpButton);
            } else {
                ShortcutsOrganizer.sMe.fTree.setNextFocusableComponent((Component)ShortcutsOrganizer.sMe.fNewCatButton);
            }
        }
    }

    static void enableDisableMoveDownButton(boolean bl) {
        if (sMe != null) {
            ShortcutsOrganizer.sMe.fMoveDownButton.setEnabled(bl);
        }
    }

    static void enableDisableDeleteButton(boolean bl, boolean bl2) {
        if (sMe != null) {
            ShortcutsOrganizer.sMe.fDeleteButton.setEnabled(bl);
            if (bl2) {
                ShortcutsOrganizer.sMe.fDeleteButton.setText(sRes.getString("button.DeleteCat"));
                ShortcutsOrganizer.sMe.fEditButton.setText(sRes.getString("button.EditCat"));
            } else {
                ShortcutsOrganizer.sMe.fDeleteButton.setText(sRes.getString("button.Delete"));
                ShortcutsOrganizer.sMe.fEditButton.setText(sRes.getString("button.Edit"));
            }
        }
    }

    static void restoreDefaults() {
        int n = MJOptionPane.showConfirmDialog((Component)((Object)sMe), (Object)sRes.getString("alert.restoreDefault"), (String)sRes.getString("alert.restoreDefaultTitle"), (int)2);
        if (n == 0) {
            ShortcutUtils.restoreDefaults();
            ShortcutsOrganizer.sMe.fTree.refreshTree();
        }
    }

    class MoveDownAx
    extends MJAbstractAction {
        public MoveDownAx() {
            this.setButtonOnlyIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/mathworks/mwswing/resources/move_down.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsOrganizer.this.fTree.moveDown();
        }
    }

    class MoveUpAx
    extends MJAbstractAction {
        public MoveUpAx() {
            this.setButtonOnlyIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/mathworks/mwswing/resources/move_up.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsOrganizer.this.fTree.moveUp();
        }
    }

    class HelpAction
    extends MJAbstractAction {
        public HelpAction() {
            super(sRes.getString("button.Help"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HelpUtils.getMapfileName("matlab", "env_csh");
            MLHelpServices.cshDisplayTopic((String)string, (String)"shortcuts_organize_edit");
        }
    }

    class CloseAction
    extends MJAbstractAction {
        public CloseAction() {
            super(sRes.getString("button.Close"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            sMe.setVisible(false);
        }
    }

    class CreateShortcutAction
    extends MJAbstractAction {
        public CreateShortcutAction() {
            super(sRes.getString("button.CreateShortcut"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutEditor.invoke();
        }
    }

    class CreateFavoriteCatAction
    extends MJAbstractAction {
        public CreateFavoriteCatAction() {
            super(sRes.getString("button.CreateCat"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = MJOptionPane.showInputDialog((Component)((Object)sMe), (Object)sRes.getString("alert.NewCatMsg"), (String)sRes.getString("alert.NewCatTitle"), (int)3);
            boolean bl = false;
            if (string != null) {
                bl = ShortcutUtils.addNewCategory(string);
            }
            if (!bl && string != null) {
                MJOptionPane.showMessageDialog((Component)((Object)sMe), (Object)sRes.getString("alert.BadCategoryName"), (String)sRes.getString("alert.BadCategoryNameTitle"), (int)2);
            }
        }
    }

    class MoveFavoriteAction
    extends MJAbstractAction {
        public MoveFavoriteAction() {
            super(sRes.getString("button.Move"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ShortcutUtils.getShortcutCategories();
            String string = (String)MJOptionPane.showInputDialog((Component)((Object)sMe), (Object)sRes.getString("chooser.SelectCat"), (String)sRes.getString("chooser.Title"), (int)3, null, (Object[])objectArray, (Object)objectArray[0]);
            if (string != null) {
                ShortcutsOrganizer.this.fTree.moveSelectedFavorite(string);
            }
        }
    }

    class EditFavoriteAction
    extends MJAbstractAction {
        public EditFavoriteAction() {
            super(sRes.getString("button.Edit"));
            this.setTip(sRes.getString("action.EditFavToolTip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShortcutsOrganizer.this.fTree != null) {
                ShortcutsOrganizer.this.fTree.editSelectedFavorite();
            }
        }
    }

    class RemoveFavoriteAction
    extends MJAbstractAction {
        public RemoveFavoriteAction() {
            super(sRes.getString("button.Delete"));
            this.setTip(sRes.getString("action.RemoveFavToolTip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShortcutsOrganizer.this.fTree != null) {
                ShortcutsOrganizer.this.fTree.removeFavorite();
            }
        }
    }
}

