/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.inspector.AbstractTreeTableNode;
import com.mathworks.mlwidgets.inspector.AutopilotPropertyValue;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mwswing.MJPanel;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

class PropertyItemNode
extends AbstractTreeTableNode
implements AutopilotPropertyValue {
    private final PropertyCell fCell;
    private final boolean fHasChildren;
    private List<PropertyItemNode> fChildrenList = null;
    private final int fColumn;
    private String fGroupName;

    public PropertyItemNode(int n, PropertyCell propertyCell, boolean bl) {
        this.fCell = propertyCell;
        this.fCell.setItemNode(this);
        this.fHasChildren = bl;
        this.fColumn = n;
    }

    @Override
    public PropertyCell getPropertyCell() {
        return this.fCell;
    }

    @Override
    public JComponent getRendererComponent() {
        if (this.fCell != null) {
            MJPanel mJPanel = this.fCell.getRendererComponent();
            if (mJPanel != null) {
                mJPanel.setName(this.fCell.getName());
            }
            return mJPanel;
        }
        return null;
    }

    @Override
    public boolean isExpanded() {
        assert (false);
        return false;
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.fCell != null) {
            MJPanel mJPanel = this.fCell.getEditorComponent();
            if (mJPanel != null) {
                mJPanel.setName(this.fCell.getName());
            }
            return mJPanel;
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return !this.fHasChildren;
    }

    void setGroupName(String string) {
        this.fGroupName = string;
    }

    String getGroupName() {
        return this.fGroupName;
    }

    public synchronized void expand() {
        this.loadChildrenMatlabThread();
    }

    @Override
    public synchronized void loadChildrenMatlabThread() {
        assert (NativeMatlab.nativeIsMatlabThread());
        this.setQueriedChildren(true);
        if (this.fHasChildren && this.fChildrenList == null) {
            this.fChildrenList = new ArrayList<PropertyItemNode>();
            Vector vector = this.fCell.expand(this.fColumn);
            for (PropertyCell propertyCell : vector) {
                if (propertyCell == null) continue;
                PropertyItemNode propertyItemNode = new PropertyItemNode(this.fColumn + 1, propertyCell, propertyCell.hasChildren());
                this.fChildrenList.add(propertyItemNode);
            }
            this.setChildren(PropertyItemNode.castToAbstractTreeTableNode(this.fChildrenList.toArray()));
        }
    }

    @Override
    public String getValueAsText() {
        if (this.fCell != null && this.fCell.getEditor() != null) {
            return this.fCell.getEditor().getAsText();
        }
        return null;
    }

    @Override
    public boolean isEditable() {
        if (this.fCell != null) {
            return this.fCell.isEditable();
        }
        return false;
    }

    @Override
    public String getName() {
        return this.fCell.getName();
    }

    public String toString() {
        return this.getName();
    }

    public String toString1() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        stringBuilder.append("PropertyItemNode: " + this.getName());
        stringBuilder.append(" (");
        stringBuilder.append("Group=" + this.getGroupName() + ",");
        stringBuilder.append("Column=" + this.fColumn + ",");
        stringBuilder.append("Value As Text=" + this.getValueAsText() + ",");
        stringBuilder.append("Editable=" + this.isEditable());
        stringBuilder.append(")" + string);
        stringBuilder.append("Renderer: ");
        JComponent jComponent = this.getRendererComponent();
        if (jComponent != null) {
            stringBuilder.append(jComponent.getClass().getName());
        } else {
            stringBuilder.append("none");
        }
        stringBuilder.append(string);
        jComponent = this.getEditorComponent();
        stringBuilder.append("Editor: ");
        if (jComponent != null) {
            stringBuilder.append(jComponent.getClass().getName());
        } else {
            stringBuilder.append("none");
        }
        stringBuilder.append(string);
        PropertyEditor propertyEditor = this.fCell.getEditor();
        stringBuilder.append("Property Editor: ");
        if (propertyEditor != null) {
            stringBuilder.append(propertyEditor.getClass().getName());
        } else {
            stringBuilder.append("none");
        }
        stringBuilder.append(string);
        int n = 0;
        if (this.fChildrenList != null) {
            n = this.fChildrenList.size();
        }
        stringBuilder.append("Number of children: " + n + string);
        if (n > 0) {
            for (PropertyItemNode propertyItemNode : this.fChildrenList) {
                stringBuilder.append(propertyItemNode.toString1());
            }
        }
        return stringBuilder.toString();
    }
}

