/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.TargetTypeDropDownButton;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JTable;

public class SpreadsheetTableHeaderRenderer
extends VariableHeaderRenderer {
    private TargetTypeDropDownButton fTargetTypeViewTSDropDownButton;
    private TargetTypeDropDownButton fTargetTypeEditTSDropDownButton;
    private SpreadsheetImportDataHeader fLastEditedImportDataHeader;
    private int fLastItemListColumn = -1;
    private boolean fShowCellArrays = true;
    private int fTargetTypeHoverColumn = -1;
    private boolean fShowTargetTypes = true;

    public SpreadsheetTableHeaderRenderer(WorksheetTable worksheetTable) {
        super((JTable)((Object)worksheetTable));
        this.getVarNameLabel().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.getVarNameEditorTextField().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.fTargetTypeViewTSDropDownButton = new TargetTypeDropDownButton(worksheetTable.getTableHeader());
        this.fTargetTypeEditTSDropDownButton = new TargetTypeDropDownButton(worksheetTable.getTableHeader());
        this.getPanel().add((Component)((Object)this.fTargetTypeViewTSDropDownButton));
        this.getEditorPanel().add((Component)((Object)this.fTargetTypeEditTSDropDownButton));
    }

    @Override
    protected void updatePanelLayout() {
        super.updatePanelLayout();
        if (this.fShowTargetTypes) {
            this.getPanel().add((Component)((Object)this.fTargetTypeViewTSDropDownButton));
            this.getEditorPanel().add((Component)((Object)this.fTargetTypeEditTSDropDownButton));
            this.getPanel().validate();
            this.getEditorPanel().validate();
        }
    }

    public boolean getShowCellArrays() {
        return this.fShowCellArrays;
    }

    public void setShowCellArrays(boolean bl) {
        this.fShowCellArrays = bl;
    }

    public boolean getShowTargetTypes() {
        return this.fShowTargetTypes;
    }

    public void setShowTargetTypes(boolean bl) {
        this.fShowTargetTypes = bl;
        this.updatePanelLayout();
    }

    public void showListItemPopup(int n) {
        this.updateDataTypeViewTSDropDownButton(n);
        this.fTargetTypeViewTSDropDownButton.showListItemPopup(n, this.fShowCellArrays);
        this.fLastItemListColumn = n;
    }

    private void updateDataTypeViewTSDropDownButton(int n) {
        SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetImportDataHeader)this.getTable().getColumnModel().getColumn(n).getHeaderValue();
        this.fTargetTypeViewTSDropDownButton.removeAllItems();
        if (spreadsheetImportDataHeader.getColumnTarget() == SpreadsheetColumnTargetType.CELL_ARRAY) {
            this.fTargetTypeViewTSDropDownButton.addItem(ImportToolUtils.getResourceString("targettype.cellarrays"));
            this.fTargetTypeViewTSDropDownButton.setText(ImportToolUtils.getResourceString("targettype.cellarrays"));
        } else {
            this.fTargetTypeViewTSDropDownButton.addItem(ImportToolUtils.getResourceString("targettype.numericarrays"));
            this.fTargetTypeViewTSDropDownButton.setText(ImportToolUtils.getResourceString("targettype.numericarrays"));
        }
        this.fTargetTypeViewTSDropDownButton.validate();
    }

    public void hideListItemPopup() {
        this.fTargetTypeViewTSDropDownButton.hideListItem();
        this.fLastItemListColumn = -1;
    }

    public int getLastItemListColumn() {
        return this.fLastItemListColumn;
    }

    public boolean clickInListPopup(Point point) {
        EditablePopupList editablePopupList = this.fTargetTypeViewTSDropDownButton.getPopupList();
        if (editablePopupList != null && editablePopupList.isVisible()) {
            return editablePopupList.containsScreenPoint(point);
        }
        return false;
    }

    public Rectangle getTargetTypeDropDownBounds(int n, Object object) {
        if (!this.fShowTargetTypes) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.getTable().getTableHeader().getHeaderRect(n);
        this.getPanel().setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.getTable(), object, false, false, 0, n);
        this.getPanel().getLayout().layoutContainer((Container)this.getPanel());
        return this.fTargetTypeViewTSDropDownButton.getBounds();
    }

    @Override
    public boolean isSelectionArea(Point point, int n, Object object) {
        Rectangle rectangle = this.getTable().getTableHeader().getHeaderRect(n);
        this.getPanel().setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.getTable(), object, false, false, 0, n);
        this.getPanel().getLayout().layoutContainer((Container)this.getPanel());
        Rectangle rectangle2 = this.fTargetTypeViewTSDropDownButton.getBounds();
        Rectangle rectangle3 = this.getVarNameLabel().getBounds();
        return !rectangle3.contains(point) && !rectangle2.contains(point);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        WorksheetTable worksheetTable = (WorksheetTable)((Object)jTable);
        if (this.getTable() != null) {
            worksheetTable = (WorksheetTable)((Object)this.getTable());
        }
        if (object instanceof SpreadsheetImportDataHeader) {
            SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetImportDataHeader)object;
            this.fTargetTypeViewTSDropDownButton.removeAllItems();
            if (spreadsheetImportDataHeader.getColumnTarget() == SpreadsheetColumnTargetType.CELL_ARRAY) {
                this.fTargetTypeViewTSDropDownButton.addItem(ImportToolUtils.getResourceString("targettype.cellarrays"));
                this.fTargetTypeViewTSDropDownButton.setText(ImportToolUtils.getResourceString("targettype.cellarrays"));
            } else {
                this.fTargetTypeViewTSDropDownButton.addItem(ImportToolUtils.getResourceString("targettype.numericarrays"));
                this.fTargetTypeViewTSDropDownButton.setText(ImportToolUtils.getResourceString("targettype.numericarrays"));
            }
        }
        if (n2 == this.fTargetTypeViewTSDropDownButton.getPopupColumn()) {
            this.fTargetTypeViewTSDropDownButton.listVisibilityChanged(true);
            this.fTargetTypeEditTSDropDownButton.listVisibilityChanged(true);
        } else {
            this.fTargetTypeViewTSDropDownButton.listVisibilityChanged(false);
            this.fTargetTypeEditTSDropDownButton.listVisibilityChanged(false);
        }
        if (this.fTargetTypeHoverColumn == n2) {
            this.fTargetTypeViewTSDropDownButton.setBackground(Color.WHITE);
            this.fTargetTypeViewTSDropDownButton.setBorder(this.fBevelBorder);
        } else {
            this.fTargetTypeViewTSDropDownButton.setBackground(this.getTable().isColumnSelected(n2) ? this.fRowHeaderColorSelected : this.fRowHeaderColorUnselected);
            this.fTargetTypeViewTSDropDownButton.setBorder(null);
        }
        this.getPanel().revalidate();
        return this.getPanel();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        if (object instanceof SpreadsheetImportDataHeader) {
            SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetImportDataHeader)object;
            this.fTargetTypeEditTSDropDownButton.removeAllItems();
            if (spreadsheetImportDataHeader.getColumnTarget() == SpreadsheetColumnTargetType.CELL_ARRAY) {
                this.fTargetTypeEditTSDropDownButton.addItem(ImportToolUtils.getResourceString("targettype.cellarrays"));
                this.fTargetTypeEditTSDropDownButton.setText(ImportToolUtils.getResourceString("targettype.cellarrays"));
            } else {
                this.fTargetTypeEditTSDropDownButton.addItem(ImportToolUtils.getResourceString("targettype.numericarrays"));
                this.fTargetTypeEditTSDropDownButton.setText(ImportToolUtils.getResourceString("targettype.numericarrays"));
            }
            this.fLastEditedImportDataHeader = (SpreadsheetImportDataHeader)object;
            return this.getEditorPanel();
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return new SpreadsheetImportDataHeader(this.fLastEditedImportDataHeader.getColumn(), this.getVarNameEditorTextField().getText(), this.fLastEditedImportDataHeader.getColumnTarget());
    }

    @Override
    protected void setLabelState(boolean bl) {
        super.setLabelState(bl);
        if (bl) {
            this.fTargetTypeViewTSDropDownButton.setBackground(this.getPanel().getBackground());
            this.fTargetTypeEditTSDropDownButton.setBackground(this.getPanel().getBackground());
        } else {
            this.fTargetTypeViewTSDropDownButton.setBackground(new Color(250, 250, 250));
            this.fTargetTypeEditTSDropDownButton.setBackground(new Color(250, 250, 250));
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    public void setTargetTypeHoverColumn(int n) {
        this.fTargetTypeHoverColumn = n;
    }

    public int getTargetTypeHoverColumn() {
        return this.fTargetTypeHoverColumn;
    }

    public static class SpreadsheetImportDataHeader
    extends VariableHeaderRenderer.ImportDataHeader {
        SpreadsheetColumnTargetType iColumnTarget = SpreadsheetColumnTargetType.CELL_ARRAY;

        public SpreadsheetImportDataHeader(int n, String string, SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
            super(n, string);
            this.iColumnTarget = spreadsheetColumnTargetType;
        }

        public SpreadsheetColumnTargetType getColumnTarget() {
            return this.iColumnTarget;
        }

        public void setColumnTarget(SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
            this.iColumnTarget = spreadsheetColumnTargetType;
        }
    }

    public static enum SpreadsheetColumnTargetType {
        CELL_ARRAY(ImportToolUtils.getResourceString("targettype.cellarrays")),
        NUMERIC_ARRAY(ImportToolUtils.getResourceString("targettype.numericarrays"));

        private String fName = "";

        private SpreadsheetColumnTargetType(String string2) {
            this.fName = string2;
        }

        public String toString() {
            return this.fName;
        }
    }
}

