/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoParser;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.HelpLocale;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.DemoSearchField;
import com.mathworks.mlwidgets.help.search.lucene.AnalyzerSource;
import com.mathworks.mlwidgets.help.search.lucene.DemoHandler;
import com.mathworks.mlwidgets.help.search.lucene.HtmlDemoHandler;
import com.mathworks.mlwidgets.help.search.lucene.LuceneIndexServices;
import com.mathworks.mlwidgets.help.search.lucene.MFileDemoHandler;
import com.mathworks.mlwidgets.help.search.lucene.MWIndexWriter;
import com.mathworks.mlwidgets.help.search.lucene.ModelDemoHandler;
import com.mathworks.mlwidgets.html.LanguageLocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LuceneDemoIndexer {
    private static final int NUM_RETRIES = 5;
    private static final long WAIT_BETWEEN_INDEX_ATTEMPTS = 5000L;
    private static DocumentBuilder sDocumentBuilder = null;
    private final AnalyzerSource fAnalyzerSource;
    private final LanguageLocale fLanguageLocale;

    private LuceneDemoIndexer(String string) {
        this.fLanguageLocale = string == null ? LanguageLocale.ENGLISH : LanguageLocale.getSupportedLanguageLocale(string);
        this.fAnalyzerSource = new AnalyzerSource(this.fLanguageLocale);
    }

    private LuceneDemoIndexer() {
        this(null);
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        if (sDocumentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                sDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            sDocumentBuilder.setErrorHandler(new DemoErrorHandler());
        }
        return sDocumentBuilder;
    }

    static void indexDemos(String string) throws IOException, SAXException {
        LuceneDemoIndexer.indexDemos(string, HelpUtils.getLocaleString());
    }

    static void indexDemos(String string, String string2) throws IOException, SAXException {
        LuceneDemoIndexer luceneDemoIndexer = new LuceneDemoIndexer(string2);
        luceneDemoIndexer.index(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(String string) throws IOException, SAXException {
        RAMDirectory rAMDirectory = this.populateRAMDirectory(string);
        String string2 = new File(string).getParent();
        File file = new File(string2, "demosearch");
        System.setProperty("org.apache.lucene.lockDir", string2);
        IOException iOException = null;
        for (int i = 0; i < 5; ++i) {
            MWIndexWriter mWIndexWriter = null;
            try {
                FSDirectory fSDirectory = FSDirectory.getDirectory((File)file, (boolean)true);
                mWIndexWriter = this.getIndexWriter((Directory)fSDirectory);
                mWIndexWriter.addIndex((Directory)rAMDirectory);
                iOException = null;
                break;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            finally {
                if (mWIndexWriter != null) {
                    mWIndexWriter.close();
                }
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RAMDirectory populateRAMDirectory(String string) throws IOException, SAXException {
        RAMDirectory rAMDirectory = new RAMDirectory();
        MWIndexWriter mWIndexWriter = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            DocumentBuilder documentBuilder = LuceneDemoIndexer.getDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(fileInputStream));
            DemoTreeItem demoTreeItem = DemoParser.processDocument(string, document);
            mWIndexWriter = this.getIndexWriter((Directory)rAMDirectory);
            mWIndexWriter.addMetaData("productname", demoTreeItem.getProduct());
            mWIndexWriter.addMetaData("producttype", demoTreeItem.getProductType());
            this.indexDemoItem(demoTreeItem, mWIndexWriter);
            mWIndexWriter.optimize();
        }
        finally {
            if (mWIndexWriter != null) {
                mWIndexWriter.close();
            }
            ((InputStream)fileInputStream).close();
        }
        return rAMDirectory;
    }

    private void indexDemoItem(DemoTreeItem demoTreeItem, MWIndexWriter mWIndexWriter) {
        block14: {
            String string;
            block13: {
                Collection<DemoTreeItem> collection = demoTreeItem.getChildren();
                if (collection == null) break block13;
                for (DemoTreeItem demoTreeItem2 : collection) {
                    this.indexDemoItem(demoTreeItem2, mWIndexWriter);
                }
                break block14;
            }
            String string2 = null;
            String string3 = DemoInfoUtils.getFileToIndex(demoTreeItem, HelpLocale.getDemosDirectoryName(this.fLanguageLocale));
            if (string3 != null) {
                string2 = this.getDemoText(string3);
            }
            if (demoTreeItem.getLabel() == null) break block14;
            if (string2 == null) {
                string2 = demoTreeItem.getLabel();
            }
            org.apache.lucene.document.Document document = new org.apache.lucene.document.Document();
            document.add(LuceneIndexServices.createField(DemoSearchField.BODY, string2));
            document.add(LuceneIndexServices.createField(DemoSearchField.LABEL, demoTreeItem.getLabel()));
            if (demoTreeItem.getProduct() != null) {
                document.add(LuceneIndexServices.createField(DemoSearchField.PRODUCT, demoTreeItem.getProduct()));
            }
            if (demoTreeItem.getProductType() != null) {
                document.add(LuceneIndexServices.createField(DemoSearchField.PRODUCT_TYPE, demoTreeItem.getProductType()));
            }
            if (demoTreeItem.getFilename() != null) {
                document.add(LuceneIndexServices.createField(DemoSearchField.FILENAME, demoTreeItem.getRelativeFilename()));
            }
            if (demoTreeItem.getSource() != null) {
                document.add(LuceneIndexServices.createField(DemoSearchField.SOURCE, demoTreeItem.getSource()));
            }
            if (demoTreeItem.getTextDescription() != null) {
                document.add(LuceneIndexServices.createField(DemoSearchField.TEXT_DESCRIPTION, demoTreeItem.getTextDescription()));
            }
            if (demoTreeItem.getType() != null) {
                document.add(LuceneIndexServices.createField(DemoSearchField.TYPE, demoTreeItem.getType()));
            }
            if ((string = demoTreeItem.getCallback()) == null || string.length() == 0) {
                string = demoTreeItem.getSource();
            }
            if (string != null && string.length() > 0) {
                document.add(LuceneIndexServices.createField(DemoSearchField.CALLBACK, string));
            }
            try {
                mWIndexWriter.addDocument(document);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private String getDemoText(String string) {
        DemoHandler demoHandler = null;
        if (string.endsWith(".html")) {
            demoHandler = new HtmlDemoHandler();
        } else if (string.endsWith(".m")) {
            demoHandler = new MFileDemoHandler();
        } else if (string.endsWith(".mdl")) {
            demoHandler = new ModelDemoHandler();
        }
        if (demoHandler != null) {
            return this.getText(demoHandler, string);
        }
        return null;
    }

    private String getText(DemoHandler demoHandler, String string) {
        try {
            String string2 = this.getDefaultEncoding();
            if (string2 != null) {
                return demoHandler.getDemoSource(string, string2);
            }
            return demoHandler.getDemoSource(string);
        }
        catch (Exception exception) {
            System.out.println("An error occurred while indexing the file " + string);
            System.out.println("\t" + exception.toString());
            return null;
        }
    }

    private String getDefaultEncoding() {
        switch (this.fLanguageLocale) {
            case JAPANESE: {
                return "SJIS";
            }
        }
        return null;
    }

    public static void main(String[] stringArray) throws IOException, SAXException {
        String string = LuceneDemoIndexer.getArgument(stringArray, "japanese");
        String string2 = LuceneDemoIndexer.getArgument(stringArray, "lang");
        if (string != null && string.toLowerCase(Locale.ENGLISH).startsWith("t")) {
            System.out.println("WARNING: \"-japanese=true\" is deprecated for LuceneDocIndexer. Use \"-lang=ja\" instead.");
            if (string2 == null) {
                string2 = LanguageLocale.JAPANESE.getLanguage();
            } else if (!string2.equalsIgnoreCase(LanguageLocale.JAPANESE.getLanguage()) && !string2.equalsIgnoreCase(LanguageLocale.JAPANESE.getLocaleString())) {
                System.out.println("WARNING: \"-lang=" + string2 + "\" overriding \"-japanese=true\". Will use " + string2 + " indexer.");
            }
        }
        LuceneDemoIndexer luceneDemoIndexer = new LuceneDemoIndexer(string2);
        System.out.println("Attempting to index demos.xml file at [" + stringArray[0] + "]");
        File file = new File(stringArray[0]);
        System.out.println("Path to demos.xml file resolves to " + file.getAbsolutePath());
        System.out.println("Check that parent directory exists: " + file.getParentFile().exists());
        if (file.getParentFile().exists()) {
            System.out.println("File listing for parent directory");
            for (String string3 : file.getParentFile().list()) {
                System.out.println("\t" + string3);
            }
        }
        System.out.println("Check for file existing: " + file.exists());
        if (file.exists()) {
            System.out.print("Indexing file at " + file.getAbsolutePath() + " using ");
            System.out.println((string2 == null ? LanguageLocale.ENGLISH.getLanguage() : string2) + " indexer.");
            long l = System.currentTimeMillis();
            luceneDemoIndexer.index(file.getAbsolutePath());
            long l2 = System.currentTimeMillis();
            System.out.println("Completed indexing in " + (l2 - l) + " milliseconds");
        } else {
            System.out.println("Could not find demos.xml file at " + file.getAbsolutePath());
        }
    }

    private static String getArgument(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            String string3;
            String string4 = string2.toLowerCase();
            if (!string4.startsWith(string3 = string.toLowerCase()) && !string4.startsWith("-" + string3)) continue;
            return string2.substring(string2.indexOf(61) + 1);
        }
        return null;
    }

    private MWIndexWriter getIndexWriter(Directory directory) throws IOException {
        return new MWIndexWriter(directory, this.fAnalyzerSource.getIndexAnalyzer(), true);
    }

    private static class DemoErrorHandler
    implements ErrorHandler {
        private DemoErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }
    }
}

