/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.ContainerHelpTreeItem;
import com.mathworks.mlwidgets.help.ContentsDataParser;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpTreeItemVisitor;
import com.mathworks.mlwidgets.help.HelpUtils;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class ProductHelpTreeItem
extends ContainerHelpTreeItem {
    private String fFilename;
    private int fNumAddons = 0;
    private HelpInfoItem fItem;

    public ProductHelpTreeItem(HelpInfoItem helpInfoItem, Icon icon, String string) {
        this(helpInfoItem.getProductName(), icon, string);
        this.fItem = helpInfoItem;
    }

    public ProductHelpTreeItem(String string, Icon icon, String string2) {
        super(string, icon, string2);
    }

    @Override
    protected void populate() {
        String string = this.getHelpLoc();
        if (string.length() != 0 && this.getHelpTocFilename() != null) {
            ContentsDataParser.loadProduct(this);
        }
    }

    @Override
    public boolean isPopulated() {
        return this.fFilename != null;
    }

    protected String getHelpLoc() {
        return this.fItem.getHelpLoc();
    }

    protected String getHelpTocFilename() {
        return HelpUtils.getInputFilename(this.getHelpLoc(), "helptoc.xml", "helptoc.student.xml");
    }

    void setFilename(String string) {
        this.fFilename = string;
    }

    @Override
    public void addChild(TreeNode treeNode) {
        int n = this.getChildCount(false) - this.fNumAddons;
        this.addChild(n, treeNode);
    }

    public void addAddon(ProductHelpTreeItem productHelpTreeItem) {
        ++this.fNumAddons;
        super.addChild(productHelpTreeItem);
    }

    public String getFilename() {
        this.populateIfNecessary();
        return this.fFilename;
    }

    @Override
    public void accept(HelpTreeItemVisitor helpTreeItemVisitor) {
        helpTreeItemVisitor.visit(this);
    }
}

