/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class HelpInfoItem
implements Comparable<HelpInfoItem> {
    private final String fProductName;
    private final String fHelpLoc;
    private final String fHelpIconLoc;
    private final String fShortName;
    private final String fUrlPrefix;
    private final String fCategory;
    private final int fPathPos;
    private Collection<String> fAlternateShortNames;
    private boolean fSelected;
    private boolean fIsToplevel = true;
    private HelpInfoItem[] fHelpAddons = null;
    private HelpInfoItem fParent = null;
    private boolean fHasRefPages = true;

    public HelpInfoItem(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, 0);
    }

    public HelpInfoItem(String string, String string2, String string3, String string4, int n) {
        String string5;
        String string6 = HelpUtils.getLocalizedFilename(string2);
        if (string6 != null) {
            string2 = string6.replace('\\', '/');
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((string5 = string2.substring(string2.lastIndexOf(47) + 1)).equals("techdoc")) {
            string5 = "matlab";
        }
        this.fShortName = string5;
        this.fHelpLoc = string2 + "/";
        this.fHelpIconLoc = string3;
        this.fCategory = string4;
        this.fProductName = string;
        this.fUrlPrefix = HelpUtils.convertPathToUrlPrefix(this.fHelpLoc);
        this.fSelected = HelpPrefs.isProductSelected(this.fProductName);
        this.fPathPos = n;
    }

    public int getPathPosition() {
        HelpInfoItem helpInfoItem = this;
        while (helpInfoItem.getParent() != null) {
            helpInfoItem = helpInfoItem.getParent();
        }
        return helpInfoItem.getLocalPathPosition();
    }

    private HelpInfoItem getParent() {
        return this.fParent;
    }

    private int getLocalPathPosition() {
        return this.fPathPos;
    }

    void addHelpAddons(HelpInfoItem[] helpInfoItemArray) {
        if (helpInfoItemArray != null) {
            this.fHelpAddons = new HelpInfoItem[helpInfoItemArray.length];
            System.arraycopy(helpInfoItemArray, 0, this.fHelpAddons, 0, helpInfoItemArray.length);
        } else {
            this.fHelpAddons = null;
        }
    }

    HelpInfoItem[] getHelpAddons() {
        if (this.fHelpAddons != null) {
            HelpInfoItem[] helpInfoItemArray = new HelpInfoItem[this.fHelpAddons.length];
            System.arraycopy(this.fHelpAddons, 0, helpInfoItemArray, 0, this.fHelpAddons.length);
            return helpInfoItemArray;
        }
        return null;
    }

    void setParent(HelpInfoItem helpInfoItem) {
        this.fParent = helpInfoItem;
    }

    void setToplevel(boolean bl) {
        this.fIsToplevel = bl;
    }

    boolean isToplevel() {
        return this.fIsToplevel;
    }

    public boolean isDescendentOf(HelpInfoItem helpInfoItem) {
        return this.fParent != null && (this.fParent.equals(helpInfoItem) || this.fParent.isDescendentOf(helpInfoItem));
    }

    public boolean isAncestorOf(HelpInfoItem helpInfoItem) {
        return helpInfoItem.isDescendentOf(this);
    }

    public void setSelected(boolean bl) {
        this.fSelected = bl;
    }

    public boolean isSelected() {
        boolean bl = this.fSelected;
        if (!this.isToplevel() && this.fParent != null) {
            bl = this.fParent.isSelected();
        }
        return bl;
    }

    public String getCategory() {
        return this.fCategory;
    }

    public String getProductName() {
        return this.fProductName;
    }

    public String getHelpLoc() {
        return this.fHelpLoc;
    }

    public String getHelpIconLoc() {
        if (this.fHelpIconLoc != null && this.fHelpIconLoc.length() > 0) {
            return this.fHelpIconLoc;
        }
        String string = "$toolbox/matlab/icons/book_mat.png";
        if (this.getCategory().equalsIgnoreCase("blockset") || this.getCategory().equalsIgnoreCase("simulink")) {
            string = "$toolbox/matlab/icons/book_sim.png";
        } else if (this.getCategory().equalsIgnoreCase("links_targets")) {
            string = "$toolbox/matlab/icons/book_link.png";
        }
        return string;
    }

    public String getUrlPrefix() {
        return this.fUrlPrefix;
    }

    public String getShortName() {
        return this.fShortName;
    }

    void setAlternateShortNames(Collection<String> collection) {
        if (this.fAlternateShortNames == null) {
            this.fAlternateShortNames = new HashSet<String>();
        }
        this.fAlternateShortNames.addAll(collection);
        this.fAlternateShortNames.remove(this.getShortName());
    }

    private Collection<String> getAlternateShortNames() {
        if (this.fAlternateShortNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.fAlternateShortNames);
    }

    Collection<String> getAllPossibleShortNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getShortName());
        arrayList.addAll(this.getAlternateShortNames());
        return arrayList;
    }

    public boolean hasRefPages() {
        return this.fHasRefPages;
    }

    void setHasRefPages(boolean bl) {
        this.fHasRefPages = bl;
    }

    @Override
    public int compareTo(HelpInfoItem helpInfoItem) {
        return this.getProductName().compareTo(helpInfoItem.getProductName());
    }
}

