/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.buildtools.BaseCodeJavaScriptBuilder;
import com.mathworks.help.helpui.search.index.DocCenterIndexMergeTool;
import com.mathworks.html.EncodingUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.product.util.ProductIdentifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocCenterUtils {
    private static final String QUERY_STRING_PROD_FILTER_FIELD = "prodfilter";
    private static final String QUERY_STRING_QDOC_FIELD = "qdoc";
    private static final String QUERY_STRING_SEARCH_FIELD = "submitsearch";
    private static final String QUERY_STRING_SEARCH_VALUE = "Search";
    private static DependencyProvider sDependencyProvider = new DefaultDependencyProvider();

    private DocCenterUtils() {
    }

    public static String getReleaseFromUrl(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("^.*(R20\\d\\d[ab]).*$");
        Matcher matcher = pattern.matcher(charSequence);
        String string = null;
        if (matcher.find()) {
            string = matcher.group(1);
        }
        return string;
    }

    public static String getReleaseFromDocCenterUrl() {
        return DocCenterUtils.getReleaseFromUrl(DocCenterUtils.getDependencyProvider().getDocCenterRoot());
    }

    public static String buildDocCenterUrl() {
        return DocCenterUtils.buildDocCenterUrl(DocCenterUtils.getDependencyProvider().getDocCenterRoot());
    }

    public static String buildDocCenterUrl(String string) {
        String string2 = HelpBrowserUtils.buildUrl((String)string);
        string2 = DocCenterUtils.appendInProductQueryStringsToUrl(string2);
        return string2;
    }

    private static String appendInProductQueryStringsToUrl(String string) {
        String string2 = string;
        if (HelpBrowserUtils.isWebAddress((String)string2)) {
            String string3;
            String string4 = DocCenterUtils.getAnchorFromUrl(string2);
            if (string4 != null && string4.length() > 0) {
                string2 = DocCenterUtils.removeAnchorFromUrl(string2, string4);
            }
            if ((string3 = DocCenterUtils.getReleaseFromUrl(string2)) == null) {
                string3 = DocCenterUtils.getDependencyProvider().getDefaultDocRelease();
            }
            string2 = HelpBrowserUtils.appendQueryStringToUrl((String)string2, (String)string3, (String)HelpUtils.getLocaleWebQueryString());
            string2 = DocCenterUtils.appendProductFilterQueryStringToUrl(string2);
            if (string4 != null && string4.length() > 0) {
                string2 = string2 + "#" + string4;
            }
        }
        return string2;
    }

    public static String getAnchorFromUrl(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceFirst("^.*?#", "");
    }

    public static String removeAnchorFromUrl(String string, String string2) {
        if (string == null) {
            return null;
        }
        return string.replaceFirst("#" + Pattern.quote(string2) + "$", "");
    }

    public static String buildDocCenterFacetSearchUrl(String string, String string2) {
        String string3 = DocCenterUtils.buildDocCenterSearchUrl(string);
        String string4 = HelpBrowserUtils.addToUrlQueryString((String)string3, (String)QUERY_STRING_QDOC_FIELD, (String)"type", (String)string2);
        return DocCenterUtils.appendProductFilterQueryStringToUrl(string4);
    }

    public static String buildDocCenterSearchUrl(String string) {
        return DocCenterUtils.buildDocCenterSearchUrl(string, null);
    }

    public static String buildDocCenterSearchUrl(String string, String[] stringArray) {
        String string2 = DocCenterUtils.getDependencyProvider().getDocCenterSearchPath();
        if (EncodingUtils.needsEncoding((String)(string2 = DocCenterUtils.appendSearchQueryStringToUrl(string2, string, stringArray)))) {
            string2 = EncodingUtils.encodeUrl((String)string2);
        }
        return string2;
    }

    public static String appendSearchQueryStringToUrl(String string, String string2, String[] stringArray) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        String string3 = string;
        string3 = HelpBrowserUtils.addToUrlQueryString((String)string3, (String)QUERY_STRING_QDOC_FIELD, (String)string2);
        string3 = HelpBrowserUtils.addToUrlQueryString((String)string3, (String)QUERY_STRING_SEARCH_FIELD, (String)QUERY_STRING_SEARCH_VALUE);
        string3 = HelpBrowserUtils.appendQueryStringToUrl((String)string3, (String)DocCenterUtils.getDependencyProvider().getDefaultDocRelease(), (String)HelpUtils.getLocaleWebQueryString());
        string3 = DocCenterUtils.appendProductFilterQueryStringToUrl(string3, stringArray);
        return string3;
    }

    public static String appendProductFilterQueryStringToUrl(String string) {
        return DocCenterUtils.appendProductFilterQueryStringToUrl(string, DocCenterUtils.getSelectedProductList());
    }

    private static String appendProductFilterQueryStringToUrl(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return DocCenterUtils.appendProductFilterQueryStringToUrl(string, DocCenterUtils.getSelectedProductList());
        }
        return DocCenterUtils.appendProductFilterQueryStringToUrl(string, DocCenterUtils.convertProductsToProductIdentifiers(stringArray));
    }

    private static Collection<ProductIdentifier> convertProductsToProductIdentifiers(String[] stringArray) {
        EnumSet<ProductIdentifier> enumSet = EnumSet.noneOf(ProductIdentifier.class);
        for (String string : stringArray) {
            ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
            if (productIdentifier == null) continue;
            enumSet.add(productIdentifier);
        }
        return enumSet;
    }

    private static String appendProductFilterQueryStringToUrl(String string, Collection<ProductIdentifier> collection) {
        String string2 = DocCenterUtils.getQueryStringProductsValue(collection);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return HelpBrowserUtils.addToUrlQueryString((String)string, (String)QUERY_STRING_PROD_FILTER_FIELD, (String)string2);
    }

    private static String getQueryStringProductsValue(Collection<ProductIdentifier> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductIdentifier productIdentifier : collection) {
            stringBuilder.append(productIdentifier.getBaseCode()).append("+");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static Collection<ProductIdentifier> getSelectedProductList() {
        ArrayList<ProductIdentifier> arrayList = new ArrayList<ProductIdentifier>();
        arrayList.addAll(DocCenterUtils.getSelectedInstalledProductIdentifiers());
        if (DocCenterUtils.getDependencyProvider().getDocCenterLocation() == DocLocation.WEB && DocCenterUtils.getDependencyProvider().isShowUninstalledProducts()) {
            arrayList.addAll(DocCenterUtils.getSelectedUninstalledProductIdentifiers());
        }
        return arrayList;
    }

    public static Collection<ProductIdentifier> getSelectedInstalledProductIdentifiers() {
        String[] stringArray = DocCenterUtils.getDependencyProvider().getSelectedInstalledProducts();
        return DocCenterUtils.getProductIdentifiersFromProductList(stringArray);
    }

    public static Collection<ProductIdentifier> getSelectedUninstalledProductIdentifiers() {
        String[] stringArray = DocCenterUtils.getDependencyProvider().getSelectedUninstalledProducts();
        return DocCenterUtils.getProductIdentifiersFromProductList(stringArray);
    }

    private static Collection<ProductIdentifier> getProductIdentifiersFromProductList(String[] stringArray) {
        EnumSet<ProductIdentifier> enumSet = EnumSet.noneOf(ProductIdentifier.class);
        for (String string : stringArray) {
            ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
            if (productIdentifier == null) continue;
            enumSet.add(productIdentifier);
        }
        return enumSet;
    }

    public static boolean hasClassicDoc() {
        return DocCenterUtils.hasThirdPartyDoc() || DocCenterUtils.hasThirdPartyDemos();
    }

    private static boolean hasThirdPartyDoc() {
        HelpInfoItem[] helpInfoItemArray = ClassicHelpDataAccessor.getInstalledProductHelpInfo();
        return helpInfoItemArray.length > 0;
    }

    static boolean hasThirdPartyDemos() {
        List<String> list = DemosData.findDemosXmlFiles();
        return list != null && !list.isEmpty();
    }

    public static void buildSharedDocCenterFiles() throws IOException {
        DocCenterUtils.mergeDocCenterIndexes();
        DocCenterUtils.buildBaseCodeJavaScript();
    }

    public static void mergeDocCenterIndexes() throws IOException {
        File file = new File(MLHelpServices.getDocRoot());
        new DocCenterIndexMergeTool(file).doMerge();
    }

    public static void buildBaseCodeJavaScript() throws IOException {
        File file = new File(MLHelpServices.getDocRoot());
        new BaseCodeJavaScriptBuilder(file).buildJavaScriptFile();
    }

    public static String getExamplesUrlForDemoCommand(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.trim();
        string2 = string2.trim();
        if (string.equals("") && string2.equals("")) {
            string2 = "matlab";
        } else if ((string.equals("matlab") || string.equals("simulink")) && string2.equals("")) {
            string2 = string;
            string = "";
        }
        Product product = ProductInfoUtils.getProductByFirstMatch(string2, string);
        String string3 = null;
        if (product != null && product.getDocDir() != null) {
            String string4 = DocCenterUtils.getDependencyProvider().getDocCenterRoot();
            string4.replaceAll("/$", "");
            String string5 = product.getDocDir();
            string3 = string4 + "/" + string5 + "/examples/index.html";
        }
        return string3;
    }

    private static synchronized void setDependencyProvider(DependencyProvider dependencyProvider) {
        sDependencyProvider = dependencyProvider;
    }

    private static synchronized DependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    private static class DefaultDependencyProvider
    implements DependencyProvider {
        private DefaultDependencyProvider() {
        }

        @Override
        public String getDocCenterRoot() {
            return HelpPrefs.getDocCenterRoot();
        }

        @Override
        public String getDefaultDocRelease() {
            return HelpPrefs.DEFAULT_DOC_RELEASE;
        }

        @Override
        public String getDocCenterSearchPath() {
            return HelpPrefs.getDocCenterSearchPath();
        }

        @Override
        public DocLocation getDocCenterLocation() {
            return HelpPrefs.getDocCenterLocation();
        }

        @Override
        public boolean isShowUninstalledProducts() {
            return HelpPrefs.isShowUninstalledProducts();
        }

        @Override
        public String[] getSelectedInstalledProducts() {
            return HelpPrefs.getSelectedInstalledProducts();
        }

        @Override
        public String[] getSelectedUninstalledProducts() {
            return HelpPrefs.getSelectedUninstalledProducts();
        }
    }

    public static interface DependencyProvider {
        public String getDocCenterRoot();

        public String getDefaultDocRelease();

        public String getDocCenterSearchPath();

        public DocLocation getDocCenterLocation();

        public boolean isShowUninstalledProducts();

        public String[] getSelectedInstalledProducts();

        public String[] getSelectedUninstalledProducts();
    }
}

