/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.matlab.api.explorer.ActionComponentProvider;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionInputSource;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.StateChangeNotifier;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.actions.ApplicableChecker;
import com.mathworks.mlwidgets.explorer.model.actions.CoreActionDefinition;
import com.mathworks.util.Converter;
import com.mathworks.util.ExtendedIterable;
import com.mathworks.util.LazyFilter;
import com.mathworks.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;

final class ActionConfigurationImpl {
    private final ActionDefinition fDefinition;
    private final ActionInputSource fSource;
    private final Map<ActionProvider, ProviderConfiguration> fProviderConfigurations;

    ActionConfigurationImpl(ActionDefinition actionDefinition, ActionInputSource actionInputSource) {
        this.fDefinition = actionDefinition;
        this.fSource = actionInputSource;
        this.fProviderConfigurations = new LinkedHashMap<ActionProvider, ProviderConfiguration>();
    }

    public ActionDefinition getDefinition() {
        return this.fDefinition;
    }

    synchronized ActionConfiguration getBinding(ActionProvider actionProvider) {
        ProviderConfiguration providerConfiguration = this.fProviderConfigurations.get(actionProvider);
        if (providerConfiguration == null) {
            providerConfiguration = new ProviderConfiguration(actionProvider);
            this.fProviderConfigurations.put(actionProvider, providerConfiguration);
        }
        return new ProviderBinding(providerConfiguration);
    }

    synchronized StateChangeNotifier getStateChangeNotifier() {
        return new StateChangeNotifier(){

            public void install(ChangeListener changeListener) {
                for (ProviderConfiguration providerConfiguration : ActionConfigurationImpl.this.fProviderConfigurations.values()) {
                    if (providerConfiguration.getStateChangeNotifier() == null) continue;
                    providerConfiguration.getStateChangeNotifier().install(changeListener);
                }
            }

            public void uninstall() {
                for (ProviderConfiguration providerConfiguration : ActionConfigurationImpl.this.fProviderConfigurations.values()) {
                    if (providerConfiguration.getStateChangeNotifier() == null) continue;
                    providerConfiguration.getStateChangeNotifier().uninstall();
                }
            }
        };
    }

    synchronized ActionDefinition lookupAction(CoreActionID coreActionID) {
        return CoreActionDefinition.valueOf(coreActionID.toString()).getDefinition();
    }

    synchronized String getLabel(ActionInput actionInput) {
        for (ProviderConfiguration providerConfiguration : this.fProviderConfigurations.values()) {
            if (providerConfiguration.getLabel(actionInput) == null || !ActionConfigurationImpl.isApplicableToAll(providerConfiguration.getProvider(), actionInput)) continue;
            return providerConfiguration.getLabel(actionInput);
        }
        return null;
    }

    synchronized MenuSection getMenuSection(ActionInput actionInput) {
        for (ProviderConfiguration providerConfiguration : this.fProviderConfigurations.values()) {
            if (providerConfiguration.getSection() == null || !ActionConfigurationImpl.isApplicableToAll(providerConfiguration.getProvider(), actionInput)) continue;
            return providerConfiguration.getSection();
        }
        return null;
    }

    synchronized boolean isEnabled(ApplicableChecker applicableChecker, ActionInput actionInput) {
        for (FileSystemEntry fileSystemEntry : ActionConfigurationImpl.getDocumentList(actionInput)) {
            ProviderConfiguration providerConfiguration = this.flattenConfigurationChain(applicableChecker, fileSystemEntry);
            if (!this.isEnabled(applicableChecker, providerConfiguration, actionInput)) continue;
            return true;
        }
        return false;
    }

    synchronized boolean isVisibleOnContextMenu(ApplicableChecker applicableChecker, ActionInput actionInput) {
        for (FileSystemEntry fileSystemEntry : ActionConfigurationImpl.getDocumentList(actionInput)) {
            ProviderConfiguration providerConfiguration = this.flattenConfigurationChain(applicableChecker, fileSystemEntry);
            if (!this.isVisibleOnContextMenu(applicableChecker, providerConfiguration, actionInput)) continue;
            return true;
        }
        return false;
    }

    synchronized JComponent getMenuComponentFromProvider(ActionInput actionInput) {
        ApplicableChecker applicableChecker = new ApplicableChecker();
        for (FileSystemEntry fileSystemEntry : ActionConfigurationImpl.getDocumentList(actionInput)) {
            ActionComponentProvider actionComponentProvider;
            ProviderConfiguration providerConfiguration = this.flattenConfigurationChain(applicableChecker, fileSystemEntry);
            if (providerConfiguration == null || (actionComponentProvider = providerConfiguration.getMenuComponentProvider()) == null || !this.isVisibleOnContextMenu(applicableChecker, providerConfiguration, actionInput)) continue;
            ActionInput actionInput2 = this.getRelevantInput(actionInput, applicableChecker, providerConfiguration.getProvider());
            return actionComponentProvider.getComponent(actionInput2);
        }
        return null;
    }

    synchronized Status run(ActionInput actionInput) {
        ApplicableChecker applicableChecker = new ApplicableChecker();
        Runner runner = new Runner();
        for (FileSystemEntry fileSystemEntry : ActionConfigurationImpl.getDocumentList(actionInput)) {
            ProviderConfiguration providerConfiguration = this.flattenConfigurationChain(applicableChecker, fileSystemEntry);
            if (providerConfiguration == null || providerConfiguration.getCode() == null || !this.isEnabled(applicableChecker, providerConfiguration, actionInput)) continue;
            runner.add(fileSystemEntry, providerConfiguration.getCode());
        }
        return runner.run(actionInput);
    }

    private static List<FileSystemEntry> getDocumentList(ActionInput actionInput) {
        List list = actionInput.getSelection();
        if (list.isEmpty()) {
            list.add(null);
        }
        return list;
    }

    private synchronized ProviderConfiguration flattenConfigurationChain(ApplicableChecker applicableChecker, FileSystemEntry fileSystemEntry) {
        Predicate<ActionInput> predicate = null;
        Predicate<ActionInput> predicate2 = null;
        StatusRunnable<ActionInput> statusRunnable = null;
        ActionComponentProvider actionComponentProvider = null;
        SelectionMode selectionMode = null;
        ActionProvider actionProvider = null;
        for (Map.Entry<ActionProvider, ProviderConfiguration> entry : this.fProviderConfigurations.entrySet()) {
            ActionProvider actionProvider2 = entry.getKey();
            ProviderConfiguration providerConfiguration = entry.getValue();
            if (predicate == null && providerConfiguration.getEnabled() != null && applicableChecker.isApplicable(actionProvider2, fileSystemEntry)) {
                predicate = providerConfiguration.getEnabled();
            }
            if (predicate2 == null && providerConfiguration.getVisibleOnContextMenu() != null && applicableChecker.isApplicable(actionProvider2, fileSystemEntry)) {
                predicate2 = providerConfiguration.getVisibleOnContextMenu();
            }
            if (selectionMode != null || providerConfiguration.getSelectionMode() == null || !applicableChecker.isApplicable(actionProvider2, fileSystemEntry)) continue;
            selectionMode = providerConfiguration.getSelectionMode();
            statusRunnable = providerConfiguration.getCode();
            actionProvider = actionProvider2;
            actionComponentProvider = providerConfiguration.getMenuComponentProvider();
        }
        if (statusRunnable == null && actionComponentProvider == null) {
            return null;
        }
        return new ProviderConfiguration(actionProvider, selectionMode, statusRunnable, actionComponentProvider, predicate, predicate2);
    }

    private boolean isEnabled(ApplicableChecker applicableChecker, ProviderConfiguration providerConfiguration, ActionInput actionInput) {
        if (providerConfiguration == null) {
            return false;
        }
        SelectionMode selectionMode = providerConfiguration.getSelectionMode();
        Predicate<ActionInput> predicate = providerConfiguration.getEnabled();
        ExtendedIterable<FileSystemEntry> extendedIterable = ActionConfigurationImpl.getLazyRelevantInput(actionInput, applicableChecker, providerConfiguration.getProvider());
        return selectionMode.allowInvocation(extendedIterable) && (predicate == null || predicate.accept((Object)this.getRelevantInput(actionInput, applicableChecker, providerConfiguration.getProvider())));
    }

    private boolean isVisibleOnContextMenu(ApplicableChecker applicableChecker, ProviderConfiguration providerConfiguration, ActionInput actionInput) {
        if (providerConfiguration == null) {
            return false;
        }
        ExtendedIterable<FileSystemEntry> extendedIterable = ActionConfigurationImpl.getLazyRelevantInput(actionInput, applicableChecker, providerConfiguration.getProvider());
        SelectionMode selectionMode = providerConfiguration.getSelectionMode();
        Predicate<ActionInput> predicate = providerConfiguration.getVisibleOnContextMenu();
        if (!selectionMode.allowOnContextMenu(extendedIterable)) {
            return false;
        }
        if (predicate != null && predicate.accept((Object)this.getRelevantInput(actionInput, applicableChecker, providerConfiguration.getProvider()))) {
            return true;
        }
        return predicate == null && selectionMode.allowInvocation(extendedIterable) && this.isEnabled(applicableChecker, providerConfiguration, this.getRelevantInput(actionInput, applicableChecker, providerConfiguration.getProvider()));
    }

    private ActionInput getRelevantInput(ActionInput actionInput, ApplicableChecker applicableChecker, ActionProvider actionProvider) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        ExtendedIterable<FileSystemEntry> extendedIterable = ActionConfigurationImpl.getLazyRelevantInput(actionInput, applicableChecker, actionProvider);
        for (FileSystemEntry fileSystemEntry : extendedIterable) {
            arrayList.add(fileSystemEntry);
        }
        return this.fSource.createInput(arrayList);
    }

    private static ExtendedIterable<FileSystemEntry> getLazyRelevantInput(ActionInput actionInput, final ApplicableChecker applicableChecker, final ActionProvider actionProvider) {
        return new LazyFilter((Collection)actionInput.getSelection(), (Predicate)new Predicate<FileSystemEntry>(){

            public boolean accept(FileSystemEntry fileSystemEntry) {
                return applicableChecker.isApplicable(actionProvider, fileSystemEntry);
            }
        });
    }

    private static boolean isApplicableToAll(ActionProvider actionProvider, ActionInput actionInput) {
        for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
            if (actionProvider.isApplicable(fileSystemEntry)) continue;
            return false;
        }
        return true;
    }

    private class Runner {
        private final Map<StatusRunnable<ActionInput>, List<FileSystemEntry>> fMap = new HashMap<StatusRunnable<ActionInput>, List<FileSystemEntry>>();

        private Runner() {
        }

        void add(FileSystemEntry fileSystemEntry, StatusRunnable<ActionInput> statusRunnable) {
            List<FileSystemEntry> list = this.fMap.get(statusRunnable);
            if (list == null) {
                list = new LinkedList<FileSystemEntry>();
                this.fMap.put(statusRunnable, list);
            }
            list.add(fileSystemEntry);
        }

        Status run(ActionInput actionInput) {
            ArrayList<Status> arrayList = new ArrayList<Status>();
            for (Map.Entry<StatusRunnable<ActionInput>, List<FileSystemEntry>> entry : this.fMap.entrySet()) {
                List<FileSystemEntry> list = entry.getValue();
                if (list.size() == 1 && list.get(0) == null) {
                    list.clear();
                }
                ActionInput actionInput2 = ActionConfigurationImpl.this.fSource.createInput(list);
                Status status = entry.getKey().run((Object)actionInput2);
                if (status.isCompleted() || status.isSuccessfullyCanceled()) continue;
                arrayList.add(status);
            }
            Status status = new Status(arrayList);
            ActionConfigurationImpl.this.fSource.notifyActionPerformed(ActionConfigurationImpl.this.fDefinition, status);
            return status;
        }
    }

    private static class ProviderConfiguration {
        private final ActionProvider fProvider;
        private Converter<ActionInput, String> fLabelLogic;
        private MenuSection fSection;
        private Predicate<ActionInput> fEnabled;
        private Predicate<ActionInput> fVisible;
        private StatusRunnable<ActionInput> fCode;
        private ActionComponentProvider fMenuComponentProvider;
        private SelectionMode fSelectionMode;
        private StateChangeNotifier fStateChangeNotifier;

        ProviderConfiguration(ActionProvider actionProvider) {
            this.fProvider = actionProvider;
        }

        ProviderConfiguration(ActionProvider actionProvider, SelectionMode selectionMode, StatusRunnable<ActionInput> statusRunnable, ActionComponentProvider actionComponentProvider, Predicate<ActionInput> predicate, Predicate<ActionInput> predicate2) {
            this.fProvider = actionProvider;
            this.fSelectionMode = selectionMode;
            this.fEnabled = predicate;
            this.fVisible = predicate2;
            this.fCode = statusRunnable;
            this.fMenuComponentProvider = actionComponentProvider;
        }

        ActionProvider getProvider() {
            return this.fProvider;
        }

        void setLabel(final String string) {
            this.fLabelLogic = new Converter<ActionInput, String>(){

                public String convert(ActionInput actionInput) {
                    return string;
                }
            };
        }

        void setLabel(Converter<ActionInput, String> converter) {
            this.fLabelLogic = converter;
        }

        String getLabel(ActionInput actionInput) {
            return this.fLabelLogic == null ? null : (String)this.fLabelLogic.convert((Object)actionInput);
        }

        void setSection(MenuSection menuSection) {
            this.fSection = menuSection;
        }

        MenuSection getSection() {
            return this.fSection;
        }

        void setEnabled(Predicate<ActionInput> predicate) {
            this.fEnabled = predicate;
        }

        void setVisibleOnContextMenu(Predicate<ActionInput> predicate) {
            this.fVisible = predicate;
        }

        void setCode(SelectionMode selectionMode, StatusRunnable<ActionInput> statusRunnable) {
            this.fSelectionMode = selectionMode;
            this.fCode = statusRunnable;
        }

        void setMenuComponentProvider(SelectionMode selectionMode, ActionComponentProvider actionComponentProvider) {
            this.fSelectionMode = selectionMode;
            this.fMenuComponentProvider = actionComponentProvider;
        }

        void setStatechangeNotifier(StateChangeNotifier stateChangeNotifier) {
            this.fStateChangeNotifier = stateChangeNotifier;
        }

        ActionComponentProvider getMenuComponentProvider() {
            return this.fMenuComponentProvider;
        }

        Predicate<ActionInput> getEnabled() {
            return this.fEnabled;
        }

        Predicate<ActionInput> getVisibleOnContextMenu() {
            return this.fVisible;
        }

        SelectionMode getSelectionMode() {
            return this.fSelectionMode;
        }

        StatusRunnable<ActionInput> getCode() {
            return this.fCode;
        }

        StateChangeNotifier getStateChangeNotifier() {
            return this.fStateChangeNotifier;
        }
    }

    private class ProviderBinding
    implements ActionConfiguration {
        private final ProviderConfiguration iConfiguration;

        ProviderBinding(ProviderConfiguration providerConfiguration) {
            this.iConfiguration = providerConfiguration;
        }

        public ActionDefinition getDefinition() {
            return ActionConfigurationImpl.this.fDefinition;
        }

        public void setLabel(String string) {
            this.iConfiguration.setLabel(string);
        }

        public void setLabel(Converter<ActionInput, String> converter) {
            this.iConfiguration.setLabel(converter);
        }

        public String getLabel(ActionInput actionInput) {
            String string = this.iConfiguration.getLabel(actionInput);
            return string == null ? ActionConfigurationImpl.this.fDefinition.getLabel() : string;
        }

        public void setSection(MenuSection menuSection) {
            this.iConfiguration.setSection(menuSection);
        }

        public void setEnabled(Predicate<ActionInput> predicate) {
            this.iConfiguration.setEnabled(predicate);
        }

        public void setVisibleOnContextMenu(Predicate<ActionInput> predicate) {
            this.iConfiguration.setVisibleOnContextMenu(predicate);
        }

        public void setCode(SelectionMode selectionMode, StatusRunnable<ActionInput> statusRunnable) {
            this.iConfiguration.setCode(selectionMode, statusRunnable);
        }

        public void setMenuComponentProvider(SelectionMode selectionMode, ActionComponentProvider actionComponentProvider) {
            this.iConfiguration.setMenuComponentProvider(selectionMode, actionComponentProvider);
        }

        public boolean isEnabled(ActionInput actionInput) {
            return ActionConfigurationImpl.this.isEnabled(new ApplicableChecker(), actionInput);
        }

        public boolean isVisibleOnContextMenu(ActionInput actionInput) {
            return ActionConfigurationImpl.this.isVisibleOnContextMenu(new ApplicableChecker(), actionInput);
        }

        public void setStateChangeNotifier(StateChangeNotifier stateChangeNotifier) {
            this.iConfiguration.setStatechangeNotifier(stateChangeNotifier);
        }
    }
}

