/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.StateChangeNotifier;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.WritablePathModel;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLPathUtils;
import com.mathworks.util.Predicate;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class PathActionProvider
implements ActionProvider {
    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        PathChangeNotifier pathChangeNotifier = new PathChangeNotifier();
        ActionConfiguration actionConfiguration = actionRegistry.getAction(CoreActionID.ADD_SELECTED_FOLDERS_TO_PATH);
        actionConfiguration.setEnabled(ActionPredicates.and(ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS, ActionPredicates.ANY_PATH_ADDABLE_DIRECTORIES_SELECTED));
        actionConfiguration.setVisibleOnContextMenu(ActionPredicates.and(ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS, ActionPredicates.ANY_PATH_ADDABLE_DIRECTORIES_SELECTED, ActionPredicates.ALL_DIRECTORIES_SELECTED));
        actionConfiguration.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration.setCode(SelectionMode.EXPLICIT_MULTIPLE_FOLDER_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.addToPath(MatlabPathModel.getInstance(), true, false, actionInput.getSelection(), null);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration2 = actionRegistry.getAction(CoreActionID.ADD_SELECTED_FOLDERS_RECURSIVE);
        actionConfiguration2.setEnabled(ActionPredicates.and(ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS, ActionPredicates.ANY_NON_PACKAGEORCLASSORPRIVATE_DIRECTORIES_SELECTED));
        actionConfiguration2.setVisibleOnContextMenu(ActionPredicates.and(ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS, ActionPredicates.ANY_NON_PACKAGEORCLASSORPRIVATE_DIRECTORIES_SELECTED, ActionPredicates.ALL_DIRECTORIES_SELECTED));
        actionConfiguration2.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration2.setCode(SelectionMode.EXPLICIT_MULTIPLE_FOLDER_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.addToPath(MatlabPathModel.getInstance(), true, true, actionInput.getSelection(), null);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration3 = actionRegistry.getAction(CoreActionID.ADD_CONTAINING_FOLDER_TO_PATH);
        actionConfiguration3.setEnabled(ActionPredicates.and(ActionPredicates.ANY_NON_PRIVATE_FILES_SELECTED, ActionPredicates.IN_SEARCH_MODE, ActionPredicates.ANY_NON_PATH_ITEMS_SELECTED));
        actionConfiguration3.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration3.setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.addToPath(MatlabPathModel.getInstance(), true, false, FileSystemUtils.getParents(actionInput.getSelection()), null);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration4 = actionRegistry.getAction(CoreActionID.ADD_CURRENT_FOLDER_TO_PATH);
        actionConfiguration4.setEnabled((Predicate)ActionPredicates.IN_PATH_ADDABLE_DIRECTORY);
        actionConfiguration4.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration4.setVisibleOnContextMenu((Predicate)ActionPredicates.NOT_IN_PRIVATE_DIRECTORY);
        actionConfiguration4.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.addToPath(MatlabPathModel.getInstance(), true, false, Arrays.asList(actionInput.getLocation()), null);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration5 = actionRegistry.getAction(CoreActionID.REMOVE_SELECTED_FOLDERS_FROM_PATH);
        actionConfiguration5.setEnabled((Predicate)ActionPredicates.ANY_FOLDER_PATH_ITEMS_SELECTED);
        actionConfiguration5.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration5.setVisibleOnContextMenu(ActionPredicates.and(ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS, ActionPredicates.ANY_FOLDER_PATH_ITEMS_SELECTED, ActionPredicates.ALL_DIRECTORIES_SELECTED));
        actionConfiguration5.setCode(SelectionMode.EXPLICIT_MULTIPLE_FOLDER_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.removeFromPath((WritablePathModel)MatlabPathModel.getInstance(), false, actionInput.getSelection(), null);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration6 = actionRegistry.getAction(CoreActionID.REMOVE_SELECTED_FOLDERS_RECURSIVE);
        actionConfiguration6.setEnabled((Predicate)ActionPredicates.ANY_FOLDER_PATH_ITEMS_SELECTED);
        actionConfiguration6.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration6.setVisibleOnContextMenu(ActionPredicates.and(ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS, ActionPredicates.ANY_FOLDER_PATH_ITEMS_SELECTED, ActionPredicates.ALL_DIRECTORIES_SELECTED));
        actionConfiguration6.setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.removeFromPath((WritablePathModel)MatlabPathModel.getInstance(), true, actionInput.getSelection(), null);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration7 = actionRegistry.getAction(CoreActionID.REMOVE_CONTAINING_FOLDER_FROM_PATH);
        actionConfiguration7.setEnabled(ActionPredicates.and(ActionPredicates.ANY_NON_PRIVATE_FILES_SELECTED, ActionPredicates.IN_SEARCH_MODE, ActionPredicates.ANY_PATH_ITEMS_SELECTED));
        actionConfiguration7.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration7.setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.removeFromPath((WritablePathModel)MatlabPathModel.getInstance(), false, FileSystemUtils.getParents(actionInput.getSelection()), null);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration8 = actionRegistry.getAction(CoreActionID.REMOVE_CURRENT_FOLDER_FROM_PATH);
        actionConfiguration8.setEnabled(ActionPredicates.and(ActionPredicates.NOT_IN_PRIVATE_DIRECTORY, ActionPredicates.IN_PATH_DIRECTORY));
        actionConfiguration8.setStateChangeNotifier((StateChangeNotifier)pathChangeNotifier);
        actionConfiguration8.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MLPathUtils.removeFromPath((WritablePathModel)MatlabPathModel.getInstance(), false, Arrays.asList(actionInput.getLocation()), null);
                return Status.COMPLETED;
            }
        });
    }

    private class PathChangeNotifier
    implements StateChangeNotifier {
        private PropertyChangeListener fListener;

        private PathChangeNotifier() {
        }

        public synchronized void install(final ChangeListener changeListener) {
            if (this.fListener == null) {
                this.fListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        changeListener.stateChanged(new ChangeEvent(PathActionProvider.this));
                    }
                };
                MatlabPathModel.getInstance().addPropertyChangeListener(this.fListener);
            }
        }

        public synchronized void uninstall() {
            if (this.fListener != null) {
                MatlabPathModel.getInstance().removePropertyChangeListener(this.fListener);
            }
        }
    }
}

