/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlservices.WorkspaceVariableAdaptor;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ISelectionOpenerProvider;
import com.mathworks.mlwidgets.array.UnsupportedEditorProvider;
import com.mathworks.mlwidgets.array.brushing.IBrushableInfoProvider;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetActions;
import com.mathworks.widgets.spreadsheet.SpreadsheetDTMenuBar;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MatlabArrayDTMenuBar
extends SpreadsheetDTMenuBar {
    private IGraphableInfoProvider fGIP = null;
    private GraphSelListener fGraphSelListener = null;
    private VariableIdentifierProvider fVDP = null;
    private IBrushableInfoProvider fBIP = null;
    private FormattableDisplay fFormattableDisplay = null;
    private MJMenu fGraphicsMenu = null;
    private ActionListener fGraphingActionsListener = null;
    public static final String MENU_CONTENTS_CHANGED = "MENU_CONTENTS_CHANGED";
    private FormatCheckBoxAbstractAction[] fFormatActions;
    private MenuBarExtractAction fExtractMenu = null;

    public MatlabArrayDTMenuBar(Object object, IUndoOpProvider iUndoOpProvider, IClipboardOpProvider iClipboardOpProvider, FormattableDisplay formattableDisplay, String string) {
        this(object, iUndoOpProvider, iClipboardOpProvider, formattableDisplay, (WorkspaceVariable)new WorkspaceVariableAdaptor(string));
    }

    public MatlabArrayDTMenuBar(Object object, IUndoOpProvider iUndoOpProvider, IClipboardOpProvider iClipboardOpProvider, FormattableDisplay formattableDisplay, WorkspaceVariable workspaceVariable) {
        super(object, iUndoOpProvider, iClipboardOpProvider);
        MJAbstractAction mJAbstractAction;
        Object object2;
        this.fFormattableDisplay = formattableDisplay;
        MJMenu mJMenu = new MJMenu(ArrayUtils.getResource("menu.view"));
        mJMenu.setName("View");
        this.add((JMenu)mJMenu);
        FormatIdentifier[] formatIdentifierArray = FormatIdentifier.values();
        this.fFormatActions = new FormatCheckBoxAbstractAction[formatIdentifierArray.length];
        for (int i = 0; i < formatIdentifierArray.length; ++i) {
            this.fFormatActions[i] = new FormatCheckBoxAbstractAction(formatIdentifierArray[i]);
        }
        if (object instanceof UnsupportedEditorProvider) {
            object2 = new MJMenuItem(ArrayUtils.getResource("menu.arrayFormat"));
            object2.setName("Formats");
            mJMenu.add((JMenuItem)object2);
            object2.setEnabled(false);
        } else {
            object2 = new MJMenu(ArrayUtils.getResource("menu.arrayFormat"));
            object2.setName("Formats");
            mJMenu.add((JMenuItem)object2);
            for (FormatCheckBoxAbstractAction formatCheckBoxAbstractAction : this.fFormatActions) {
                object2.add((JMenuItem)new MJCheckBoxMenuItem((Action)((Object)formatCheckBoxAbstractAction)));
            }
        }
        if (workspaceVariable != null) {
            mJMenu.add((Action)((Object)new ArrayUtils.UpAction(workspaceVariable.getWorkspaceVariableNameTemp())));
        }
        if (object instanceof IGraphableInfoProvider) {
            this.fGIP = (IGraphableInfoProvider)object;
            this.fGraphicsMenu = new MJMenu(ArrayUtils.getResource("menu.graphics"));
            this.fGraphicsMenu.setName("Graphics");
            this.add((JMenu)this.fGraphicsMenu);
            this.fGraphSelListener = new GraphSelListener();
            this.fGIP.addGraphableSelectionListener(this.fGraphSelListener);
        }
        if (object instanceof VariableIdentifierProvider) {
            this.fVDP = (VariableIdentifierProvider)object;
        }
        object2 = object instanceof ISelectionOpenerProvider ? ((ISelectionOpenerProvider)object).getSelectionOpenerAction() : new DummySOAction();
        this.fEditMenu.add((Action)object2);
        try {
            if (MatlabDesktopServices.getDesktop().useToolstrip()) {
                mJAbstractAction = (MJAbstractAction)SpreadsheetActions.getClearContentsAction((Object)object);
                if (object instanceof ArrayEditorProvider) {
                    mJAbstractAction.setName(ArrayUtils.getResource("replace.WithZero"));
                } else {
                    mJAbstractAction.setName(ArrayUtils.getResource("replace.WithEmpty"));
                }
                this.fEditMenu.add((Action)mJAbstractAction);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fExtractMenu = new MenuBarExtractAction();
        this.fEditMenu.add((Action)((Object)this.fExtractMenu));
        if (object instanceof UnsupportedEditorProvider) {
            this.fExtractMenu.setEnabled(false);
        }
        if (object instanceof IBrushableInfoProvider) {
            this.fBIP = (IBrushableInfoProvider)object;
            mJAbstractAction = new MJMenu(ArrayUtils.getResource("menu.brushing"));
            mJAbstractAction.setName("Brushing");
            this.fEditMenu.add((JMenuItem)mJAbstractAction);
            mJAbstractAction.add(this.fBIP.getBrushModeAction());
            this.fBIP.addBrushingActions((MJMenu)mJAbstractAction);
        }
        this.configureGraphicsMenu();
    }

    public void addActionListener(ActionListener actionListener) {
        this.fGraphingActionsListener = AWTEventMulticaster.add(this.fGraphingActionsListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fGraphingActionsListener = AWTEventMulticaster.remove(this.fGraphingActionsListener, actionListener);
    }

    private void configureGraphicsMenu() {
        if (this.fGraphicsMenu != null) {
            Action action;
            MJAbstractAction[] mJAbstractActionArray;
            this.fGraphicsMenu.removeAll();
            this.fGraphicsMenu.add((Action)GraphingActionFactory.getNewFigureAction());
            this.fGraphicsMenu.add((Action)GraphingActionFactory.getNewPlotToolAction());
            MJAbstractAction[] mJAbstractActionArray2 = GraphingActionFactory.getGraphingActions(this.fGIP.getGraphableNames(), false);
            if (mJAbstractActionArray2 != null && mJAbstractActionArray2.length > 0) {
                this.fGraphicsMenu.addSeparator();
                mJAbstractActionArray = mJAbstractActionArray2;
                int n = mJAbstractActionArray.length;
                for (int i = 0; i < n; ++i) {
                    MJAbstractAction mJAbstractAction = mJAbstractActionArray[i];
                    this.fGraphicsMenu.add((Action)mJAbstractAction);
                }
            }
            if ((mJAbstractActionArray = this.fGIP.getPlotPickerAction()) != null) {
                this.fGraphicsMenu.add((Action)mJAbstractActionArray);
            }
            if ((action = this.fGIP.getMorePlotsAction()) != null) {
                this.fGraphicsMenu.addSeparator();
                this.fGraphicsMenu.add(action);
            }
            this.fireMenuBarChangedEvent();
        }
    }

    public void fireMenuBarChangedEvent() {
        if (this.fGraphingActionsListener != null) {
            this.fGraphingActionsListener.actionPerformed(new ActionEvent((Object)this, 1001, MENU_CONTENTS_CHANGED));
        }
    }

    public void cleanup() {
        this.fGraphicsMenu = null;
        this.fFormattableDisplay = null;
        this.fFormatActions = null;
        if (this.fGraphSelListener != null) {
            this.fGIP.removeGraphableSelectionListener(this.fGraphSelListener);
            this.fGraphSelListener = null;
        }
        this.fGraphingActionsListener = null;
        this.fGIP = null;
        this.fVDP = null;
        super.cleanup();
    }

    private class FormatCheckBoxAbstractAction
    extends MJAbstractAction {
        private FormatIdentifier lFormatID;

        FormatCheckBoxAbstractAction(FormatIdentifier formatIdentifier) {
            super(formatIdentifier.getName(), MatlabArrayDTMenuBar.this.fFormattableDisplay.getFormat() == formatIdentifier);
            this.lFormatID = formatIdentifier;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MatlabArrayDTMenuBar.this.fFormattableDisplay.setFormat(this.lFormatID);
            for (FormatCheckBoxAbstractAction formatCheckBoxAbstractAction : MatlabArrayDTMenuBar.this.fFormatActions) {
                formatCheckBoxAbstractAction.formatChanged();
            }
        }

        public void formatChanged() {
            this.setSelected(MatlabArrayDTMenuBar.this.fFormattableDisplay.getFormat() == this.lFormatID);
        }
    }

    protected class MenuBarExtractAction
    extends ArrayUtils.ExtractAction {
        protected MenuBarExtractAction() {
            super(new ArrayUtils.CreateVariableActionProvider(){

                @Override
                public VariableIdentifier getVariableIdentifier() {
                    return MatlabArrayDTMenuBar.this.fVDP == null ? null : MatlabArrayDTMenuBar.this.fVDP.getVariableIdentifier();
                }

                @Override
                public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
                }
            });
            if (MatlabArrayDTMenuBar.this.fVDP != null) {
                MatlabArrayDTMenuBar.this.fVDP.addVariableIdentifierListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (!listSelectionEvent.getValueIsAdjusting()) {
                            MenuBarExtractAction.this.configureExtractAction();
                        }
                    }
                });
            }
            this.configureExtractAction();
        }

        private void configureExtractAction() {
            if (MatlabArrayDTMenuBar.this.fVDP != null) {
                VariableIdentifier variableIdentifier = MatlabArrayDTMenuBar.this.fVDP.getVariableIdentifier();
                String string = variableIdentifier.getVariable();
                if (string == null) {
                    string = variableIdentifier.getExpression();
                }
                this.setEnabled(string != null);
                MatlabArrayDTMenuBar.this.fireMenuBarChangedEvent();
            }
        }
    }

    private static class DummySOAction
    extends ArrayUtils.BaseAction {
        DummySOAction() {
            super("open-selection", "OpenCell");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class GraphSelListener
    implements ListSelectionListener {
        private GraphSelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                MatlabArrayDTMenuBar.this.configureGraphicsMenu();
            }
        }
    }
}

