/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLArrayEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.array.AbstractMatlabTable;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.CategoricalVariableEditor;
import com.mathworks.mlwidgets.array.ColumnDragWindow;
import com.mathworks.mlwidgets.array.DatasetHeaderPopup;
import com.mathworks.mlwidgets.array.DatasetPopupPanel;
import com.mathworks.mlwidgets.array.GroupHeaderUI;
import com.mathworks.mlwidgets.array.ObjectIdentifier;
import com.mathworks.mlwidgets.array.RefreshableObjectVariableLiteral;
import com.mathworks.mlwidgets.array.TabularObjectColumnModel;
import com.mathworks.mlwidgets.array.TabularObjectHeaderRenderer;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.ValueDataSection;
import com.mathworks.mlwidgets.array.data.CategoricalScalar;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotCatalog;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.util.Log;
import com.mathworks.util.Pair;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.CellLocation;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.IHeaderRendererProvider;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellBorder;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DatasetTable
extends AbstractMatlabTable
implements IGraphableInfoProvider,
VariableIdentifierProvider,
IGraphingActionListener,
IPlotPickerDisplayTrigger,
IHeaderRendererProvider {
    private static final String[] STRINGS = new String[0];
    protected PlotCatalog fMorePlotsDlg = null;
    protected MJAbstractAction fCatalogAction;
    private List<ListSelectionListener> fGraphicListener = new Vector<ListSelectionListener>();
    private List<ListSelectionListener> fSimpleVariableListener = new Vector<ListSelectionListener>();
    private int fSPItemsAddedCount;
    private ExtractDatasetVariablesAction fExtractDatasetVariablesAction;
    private ListSelectionListener fLSL;
    private int fLastColumnHeaderClick = -1;
    private MJMenu fExtractMenu;
    private MJAbstractAction fExtractAction;
    private MJAbstractAction fExtractDatasetVariableArrayAction;
    private MJAbstractAction fPlotPickerAction = null;
    private Collection<PlotPickerOpener> fPlotPickerOpeners = new ArrayList<PlotPickerOpener>();
    private TabularObjectColumnModel fTabularObjectColumnModel;
    private MJAbstractAction fInsertAsNewVariableAction;
    private MJAbstractAction fInsertAsNewVarRightAction;
    private MJAbstractAction fInsertAsNewObservationAction;
    private MJAbstractAction fInsertAsNewObsBelowAction;
    private MJAbstractAction fDeleteObservationsAction;
    private MJAbstractAction fDeleteVariablesAction;
    private MJAbstractAction fUngroupVariableAction;
    private MJAbstractAction fGroupVariableAction;
    private MJAbstractAction fSortAscendingAction;
    private MJAbstractAction fSortDescendingAction;
    private MJAbstractAction fConvertToNominalAction;
    private DatasetMouseAdapter fDatasetMouseAdapter = null;
    private boolean fMovingColumns = false;
    private int fMoveColumn = -1;
    private ColumnDragWindow fMoveWindow = null;
    private BorderedCellRenderer fBorderRenderer = null;
    private Map<String, Integer> fColumnWidths = null;
    private boolean fIsAdjusting = false;
    private static final int RESIZE_REGION_SIZE = 2;

    public DatasetTable(TabularObjectTableModel tabularObjectTableModel) {
        super(tabularObjectTableModel);
        assert (this.getVariable().getWorkspaceID() == 0);
        this.setName("DatasetVariableTable");
        this.fBorderRenderer = new BorderedCellRenderer(this);
        this.fSPItemsAddedCount = 0;
        this.fCatalogAction = new MorePlotsAction();
        this.fPlotPickerAction = new MJAbstractAction(ArrayUtils.getResource("menu.picker")){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTable.this.firePlotPickerRequested();
            }
        };
        this.refreshObjectSpecificPopup();
        this.fLSL = new SelListener();
        this.getSelectionModel().addListSelectionListener(this.fLSL);
        this.fExtractAction = new ExtractDatasetAction();
        this.fExtractAction.setComponentName("ExtractDataset");
        this.fExtractDatasetVariableArrayAction = new ExtractDatasetVariableArrayAction();
        this.fExtractDatasetVariableArrayAction.setComponentName("ExtractMatlabArrays");
        this.fDeleteObservationsAction = new DeleteObservationAction();
        this.fDeleteObservationsAction.setComponentName("DeleteObservations");
        this.fExtractDatasetVariablesAction = new ExtractDatasetVariablesAction();
        this.fExtractDatasetVariablesAction.setComponentName("ExtractSeparateArrays");
        this.fDeleteVariablesAction = new DeleteVariableAction();
        this.fDeleteVariablesAction.setComponentName("DeleteVariable");
        this.fUngroupVariableAction = new UngroupVariableAction();
        this.fUngroupVariableAction.setComponentName("UngroupVariable");
        this.fGroupVariableAction = new GroupVariableAction();
        this.fGroupVariableAction.setComponentName("GroupVariable");
        this.fSortAscendingAction = new SortAscendingAction();
        this.fSortAscendingAction.setComponentName("SortAscending");
        this.fSortDescendingAction = new SortDescendingAction();
        this.fSortDescendingAction.setComponentName("SortDescending");
        this.fConvertToNominalAction = new ConvertToNominalAction();
        this.fConvertToNominalAction.setComponentName("ConvertToNominal");
        GraphingActionFactory.addGraphingActionListener(this);
        JTableHeader jTableHeader = new JTableHeader();
        jTableHeader.setName("DatatsetTableHeader");
        this.setTableHeader(jTableHeader);
        this.fHeaderRenderer = this.createColumnHeaderRenderer((JTable)((Object)this));
        jTableHeader.setDefaultRenderer((TableCellRenderer)this.fHeaderRenderer);
        jTableHeader.setReorderingAllowed(false);
        this.fTabularObjectColumnModel = new TabularObjectColumnModel(this.getColumnCount(), this.getVariableName());
        this.fTabularObjectColumnModel.getSelectionModel().addListSelectionListener(this.fLSL);
        if (Matlab.isMatlabAvailable()) {
            this.fTabularObjectColumnModel.updateData();
        }
        this.setColumnModel(this.fTabularObjectColumnModel);
        this.getTableHeader().setUI(new GroupHeaderUI());
        this.fColumnWidths = new HashMap<String, Integer>();
        this.fTabularObjectColumnModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                if (DatasetTable.this.fHeaderRenderer instanceof CellEditor) {
                    ((CellEditor)DatasetTable.this.fHeaderRenderer).cancelCellEditing();
                }
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                if (DatasetTable.this.fHeaderRenderer instanceof CellEditor) {
                    ((CellEditor)DatasetTable.this.fHeaderRenderer).cancelCellEditing();
                }
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.getInsertAction().setEnabled(false);
        StopMovingAction stopMovingAction = new StopMovingAction();
        this.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "stopMoving");
        this.getActionMap().put("stopMoving", stopMovingAction);
        MouseMotionListener[] mouseMotionListenerArray = this.getTableHeader().getMouseMotionListeners();
        MouseMotionListener mouseMotionListener = null;
        if (mouseMotionListenerArray != null) {
            for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                if (!(mouseMotionListenerArray[i] instanceof SpreadsheetTable.TableHeaderMouseEventListener)) continue;
                mouseMotionListener = mouseMotionListenerArray[i];
                this.getTableHeader().removeMouseMotionListener(mouseMotionListenerArray[i]);
                break;
            }
        }
        this.fDatasetMouseAdapter = new DatasetMouseAdapter();
        this.getTableHeader().addMouseListener(this.fDatasetMouseAdapter);
        this.getTableHeader().addMouseMotionListener(this.fDatasetMouseAdapter);
        if (mouseMotionListener != null) {
            this.getTableHeader().addMouseMotionListener(mouseMotionListener);
        }
        if (this.fHeaderRenderer instanceof CellEditor) {
            ((CellEditor)this.fHeaderRenderer).addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent changeEvent) {
                }

                @Override
                public void editingStopped(ChangeEvent changeEvent) {
                    if (DatasetTable.this.fHeaderRenderer == null) {
                        return;
                    }
                    Object object = ((CellEditor)DatasetTable.this.fHeaderRenderer).getCellEditorValue();
                    if (object instanceof TabularObjectHeaderRenderer.NamedHeaderContent) {
                        int n = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getRow() - 1;
                        int n2 = DatasetTable.this.getTabularObjectColumnModel().getStartColumn(n);
                        if (n2 < 0 || DatasetTable.this.getColumnModel().getColumn(n2).getHeaderValue().equals(object)) {
                            return;
                        }
                        String string = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getName();
                        String string2 = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getRowID();
                        String string3 = "variableEditorMetadataCode(" + DatasetTable.this.getVariableName() + ",'" + DatasetTable.this.getVariableName() + "'," + string2 + ",'VarNames','" + string + "')";
                        ((TabularObjectTableModel)((Object)DatasetTable.this.getModel())).evalMatlabString(string3, true, true);
                        DatasetTable.this.getTabularObjectColumnModel().setNamedHeaderContentForColumn(n2, (TabularObjectHeaderRenderer.NamedHeaderContent)object);
                    }
                    changeEvent.toString();
                }
            });
        }
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    private ArrayList<Integer> getVisibleColumnsIndicies() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Rectangle rectangle = this.getVisibleRect();
        int n = this.getTabularObjectColumnModel().getVariableColumnCount();
        int n2 = rectangle.x;
        while ((double)n2 <= rectangle.getWidth()) {
            int n3 = this.getTabularObjectColumnModel().getColumnIndexAtX(n2);
            Integer n4 = new Integer(n3);
            if (!arrayList.contains(n4)) {
                arrayList.add(n4);
            }
            n2 += TabularObjectHeaderRenderer.getIconWidths() / 2;
        }
        return arrayList;
    }

    public ArrayList<TableColumn> getVisibleColumns() {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        Rectangle rectangle = this.getVisibleRect();
        int n = this.getTabularObjectColumnModel().getVariableColumnCount();
        int n2 = rectangle.x;
        while ((double)n2 <= rectangle.getWidth()) {
            int n3 = this.getTabularObjectColumnModel().getColumnIndexAtX(n2);
            TableColumn tableColumn = this.getTabularObjectColumnModel().getColumn(n3);
            if (!arrayList.contains(tableColumn)) {
                arrayList.add(tableColumn);
            }
            n2 += TabularObjectHeaderRenderer.getIconWidths() / 2;
        }
        return arrayList;
    }

    private void adjustVisibleColumnWidths() {
        ArrayList<Integer> arrayList = this.getVisibleColumnsIndicies();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = arrayList.get(i);
            int n2 = n;
            int[] nArray = this.getTabularObjectColumnModel().getGroupColumnInterval(n2);
            int n3 = nArray[1] - nArray[0];
            if (n3 <= 1 || arrayList2.contains(n)) continue;
            int n4 = this.getTabularObjectColumnModel().getGroupColumnWidth(n2);
            int n5 = n4 / n3;
            int n6 = n5 + (n4 - n5 * n3);
            for (int j = nArray[0]; j < nArray[1] - 1; ++j) {
                this.getTabularObjectColumnModel().getColumn(j).setPreferredWidth(n5);
                arrayList2.add(new Integer(j));
            }
            this.getTabularObjectColumnModel().getColumn(nArray[1] - 1).setPreferredWidth(n6);
            arrayList2.add(new Integer(nArray[1] - 1));
        }
    }

    public boolean isAdjusting() {
        return this.fIsAdjusting;
    }

    protected int getNumVariableColumns() {
        int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        if (nArray == null || nArray.length < 2) {
            return -1;
        }
        return nArray[1];
    }

    public void setFormat(FormatIdentifier formatIdentifier) {
        super.setFormat(formatIdentifier);
        this.fBorderRenderer = new BorderedCellRenderer(this);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.fBorderRenderer;
    }

    protected void doRegionCut(ActionEvent actionEvent) {
        String string;
        this.doRegionCopy(actionEvent);
        if (this.isAllDatasetRowsSelected()) {
            List<Pair<String, int[]>> list = this.getTabularObjectColumnModel().getSelectedVariableNames();
            if (list == null || list.isEmpty()) {
                return;
            }
            string = this.getVariableName() + "(:,{'" + (String)list.get(0).getFirst() + "'";
            for (int i = 1; i < list.size(); ++i) {
                string = string + ",'" + (String)list.get(i).getFirst() + "'";
            }
            string = string + "}) = [];";
        } else if (this.isAllDatasetColumnsSelected()) {
            int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
            List list = AbstractSpreadsheetTable.getSelectionIntervals((int[])nArray);
            String string2 = SpreadsheetUtils.getSelectionString((List)list, (int)-1);
            string = this.getVariableName() + "(" + string2 + ",:) = [];";
        } else {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabString(string, false);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Object object = this.getValueAt(n, n2);
        if (object instanceof ValueDataSection && ((ValueDataSection)object).isReadOnly() && eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 2 && ((InputEvent)eventObject).getModifiers() == 16) {
            int n3 = this.getTabularObjectColumnModel().getGroupIndex(n2);
            String string = this.getTabularObjectColumnModel().getVariableName(n3);
            String string2 = this.getTabularObjectColumnModel().getVariableMatlabClass(n3);
            final String string3 = "cell".equals(string2) ? this.getVariableName() + "." + string + "{" + Integer.toString(n + 1) + "}" : this.getVariableName() + "." + string + "(" + Integer.toString(n + 1) + ")";
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        MLArrayEditorServices.openVariable((String)string3);
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            });
            return false;
        }
        return super.editCellAt(n, n2, eventObject);
    }

    private void showMetadataPopup(int n) {
        int n2 = this.getTabularObjectColumnModel().getGroupIndex(n);
        int[] nArray = this.getTabularObjectColumnModel().getGroupColumnInterval(n);
        final DatasetPopupPanel datasetPopupPanel = new DatasetPopupPanel(this, n2);
        Rectangle rectangle = this.getTableHeader().getHeaderRect(nArray[1] - 1);
        Point point = new Point(rectangle.x + rectangle.width - TabularObjectHeaderRenderer.DropDownPanel.getArrowButtonWidth(), rectangle.y + rectangle.height);
        SwingUtilities.convertPointToScreen(point, this.getTableHeader());
        final Point point2 = point;
        datasetPopupPanel.setSortEnabled(this.getTabularObjectColumnModel().isSortEnabled(n));
        datasetPopupPanel.populateMetadataFields(new Runnable(){

            @Override
            public void run() {
                final MJDialog mJDialog = DatasetHeaderPopup.showDatasetHeaderPopup((JComponent)((Object)DatasetTable.this), (JComponent)((Object)datasetPopupPanel), point2);
                datasetPopupPanel.setDismissAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        mJDialog.dispose();
                    }
                });
            }
        });
    }

    protected void doPaste(int n) {
        this.doPaste(n, TabularObjectTableModel.PasteType.PASTE);
    }

    public boolean isAllDatasetRowsSelected() {
        int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        if (nArray == null || nArray.length < 2) {
            return false;
        }
        return this.isRowSelected(0) && this.isRowSelected(nArray[0] - 1) && this.getSelectedRowCount() >= nArray[0];
    }

    private boolean isAllDatasetColumnsSelected() {
        int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        if (nArray == null || nArray.length < 2) {
            return false;
        }
        return this.isColumnSelected(0) && this.isColumnSelected(nArray[1] - 1) && this.getSelectedColumnCount() >= nArray[1];
    }

    private void doPaste(int n, TabularObjectTableModel.PasteType pasteType) {
        MJClipboard mJClipboard = MJClipboard.getMJClipboard();
        try {
            List list;
            SimpleVariableDefinition simpleVariableDefinition;
            if (mJClipboard != null && mJClipboard.isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor) && (simpleVariableDefinition = (SimpleVariableDefinition)(list = (List)mJClipboard.getData(MLDataFlavor.simpleVariableListFlavor)).get(0)) instanceof RefreshableObjectVariableLiteral.ObjectVariableDefinition) {
                String string;
                ObjectIdentifier objectIdentifier = ((RefreshableObjectVariableLiteral.ObjectVariableDefinition)simpleVariableDefinition).getObjectIdentifier();
                int n2 = this.getColumnModel().getSelectionModel().getMinSelectionIndex();
                int n3 = this.getSelectionModel().getMinSelectionIndex();
                int n4 = this.getColumnModel().getSelectionModel().getMaxSelectionIndex() - n2 + 1;
                int n5 = this.getSelectionModel().getMaxSelectionIndex() - n3 + 1;
                int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
                if (n2 > nArray[1]) {
                    ArrayDialog.showErrorDialog(ArrayUtils.getResource("dataset.PasteOutside"));
                    return;
                }
                if (pasteType.isInsert()) {
                    string = this.getEvalStringForPasteInsert(pasteType, objectIdentifier.getKey(), n2, n3, n4, n5);
                } else {
                    List list2 = DatasetTable.getSelectionIntervals((int[])this.getSelectedRows());
                    List list3 = DatasetTable.getSelectionIntervals((int[])this.getSelectedColumns());
                    String string2 = "arrayviewfunc('retrieveValue','" + objectIdentifier.getKey() + "')";
                    string = this.getVariableName() + "= variableEditorPaste(" + this.getVariableName() + "," + SpreadsheetUtils.getSelectionString((List)list2, (int)-1) + "," + SpreadsheetUtils.getSelectionString((List)list3, (int)-1) + "," + string2 + ");";
                    if (list2.size() == 1 && list3.size() == 1) {
                        ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabPasteExpression(string, new PostPasteSelectionRunnable(string2, new Point(((int[])list2.get(0))[0], ((int[])list3.get(0))[0])));
                        return;
                    }
                }
                ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabPasteExpression(string);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((TabularObjectTableModel)((Object)this.getModel())).setInsertState(pasteType);
        super.doPaste(n);
        ((TabularObjectTableModel)((Object)this.getModel())).setInsertState(TabularObjectTableModel.PasteType.PASTE);
    }

    private String getEvalStringForPasteInsert(TabularObjectTableModel.PasteType pasteType, String string, int n, int n2, int n3, int n4) {
        int n5;
        String string2 = null;
        int n6 = pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT ? n3 + 1 : 1;
        int n7 = n5 = pasteType == TabularObjectTableModel.PasteType.INSERTROWS_BELOW ? n4 + 1 : 1;
        if (pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS || pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT) {
            string2 = this.getVariableName() + "= variableEditorInsert(" + this.getVariableName() + ",'columns'," + Integer.toString(n2 + n5) + "," + Integer.toString(n + n6) + ",arrayviewfunc('retrieveValue','" + string + "'));";
        } else if (pasteType == TabularObjectTableModel.PasteType.INSERTROWS || pasteType == TabularObjectTableModel.PasteType.INSERTROWS_BELOW) {
            string2 = this.getVariableName() + "= variableEditorInsert(" + this.getVariableName() + ",'rows'," + Integer.toString(n2 + n5) + "," + Integer.toString(n + n6) + ",arrayviewfunc('retrieveValue','" + string + "'));";
        }
        return string2;
    }

    protected void installEditorsAndRenderersForFormat() {
        super.installEditorsAndRenderersForFormat();
        this.setDefaultEditor(CategoricalScalar.class, new CategoricalVariableEditor());
    }

    @Override
    protected void setupSelectionAsPerSpreadsheet() {
        super.setupSelectionAsPerSpreadsheet();
        this.setSelectionMode(2);
    }

    private void doInsert(TabularObjectTableModel.PasteType pasteType) {
        this.doPaste(0, pasteType);
    }

    private void doInsertObservation(TabularObjectTableModel.PasteType pasteType) {
        this.doPaste(0, pasteType);
    }

    protected void setupContextMenu() {
        this.fSelectionPopupMenu = new MJPopupMenu();
        this.fSelectionPopupMenu.add(this.getCutAction());
        this.fSelectionPopupMenu.add(this.getCopyAction());
        this.fSelectionPopupMenu.add(this.getPasteAction());
        this.fExtractMenu = new MJMenu(ArrayUtils.getResource("dataset.createfromselect"));
        this.fExtractMenu.setName("ExtractParent");
        this.fInsertAsNewVariableAction = new MJAbstractAction(ArrayUtils.getResource("dataset.insertnewcol")){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTable.this.doInsert(TabularObjectTableModel.PasteType.INSERTCOLUMNS);
            }
        };
        this.fInsertAsNewVariableAction.setComponentName("InsertAsNewVariable");
        this.fInsertAsNewVarRightAction = new MJAbstractAction(ArrayUtils.getResource("dataset.insertnewcolright")){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTable.this.doInsert(TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT);
            }
        };
        this.fInsertAsNewVarRightAction.setComponentName("InsertAsNewVariableRight");
        this.fInsertAsNewObservationAction = new MJAbstractAction(ArrayUtils.getResource("dataset.insertnewrow")){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTable.this.doInsertObservation(TabularObjectTableModel.PasteType.INSERTROWS);
            }
        };
        this.fInsertAsNewObservationAction.setComponentName("InsertAsNewObservation");
        this.fInsertAsNewObsBelowAction = new MJAbstractAction(ArrayUtils.getResource("dataset.insertnewrowbelow")){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTable.this.doInsertObservation(TabularObjectTableModel.PasteType.INSERTROWS_BELOW);
            }
        };
        this.addContextMenuMouseListener();
    }

    protected void restoreWidths() {
        for (int i = 0; i < this.getTabularObjectColumnModel().getVariableColumnCount(); ++i) {
            String string = ((TabularObjectHeaderRenderer.NamedHeaderContent)this.getTabularObjectColumnModel().getColumn(i).getHeaderValue()).getName();
            if (!this.fColumnWidths.containsKey(string)) continue;
            int n = this.fColumnWidths.get(string);
            this.getTabularObjectColumnModel().getColumn(i).setPreferredWidth(n);
        }
    }

    @Override
    protected void restoreSelection(int[] nArray, int[] nArray2) {
        List list = DatasetTable.getSelectionIntervals((int[])nArray);
        for (int[] nArray3 : list) {
            this.addRowSelectionInterval(nArray3[0], nArray3[1]);
        }
        List list2 = DatasetTable.getSelectionIntervals((int[])nArray2);
        int n = this.getModel().getColumnCount() < this.getColumnCount() ? this.getModel().getColumnCount() : this.getColumnCount();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            int[] nArray4 = (int[])iterator.next();
            if (nArray4[0] >= n) continue;
            this.addColumnSelectionInterval(nArray4[0], nArray4[1] < n ? nArray4[1] : n - 1);
        }
        this.restoreWidths();
    }

    public IHeaderRenderer createRowHeaderRenderer(JTable jTable) {
        return new TabularObjectHeaderRenderer(jTable, TabularObjectHeaderRenderer.Alignment.ROWS);
    }

    public IHeaderRenderer createColumnHeaderRenderer(JTable jTable) {
        this.fHeaderRenderer = new TabularObjectHeaderRenderer(jTable, TabularObjectHeaderRenderer.Alignment.COLUMNS);
        return this.fHeaderRenderer;
    }

    @Override
    public void updateData() {
        super.updateData();
        this.fTabularObjectColumnModel.updateData();
        if (!this.fMovingColumns) {
            this.getTableHeader().setCursor(new Cursor(0));
            this.cleanupMoveWindow();
        }
    }

    protected void reexamineEditingActions() {
        this.getInsertAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getUndoAction().setEnabled(true);
        this.getRedoAction().setEnabled(true);
        this.getClearContentsAction().setEnabled(false);
    }

    protected void reexamineInsertDeleteEnablement() {
    }

    private void firePlotPickerRequested() {
        for (PlotPickerOpener plotPickerOpener : this.fPlotPickerOpeners) {
            plotPickerOpener.openPlotPicker();
        }
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.add(plotPickerOpener);
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.remove(plotPickerOpener);
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fPlotPickerAction;
    }

    String getVariableUnits(int n) {
        String string = this.getVariableName() + ".Properties.Units{" + Integer.toString(n + 1) + "};";
        try {
            return (String)Matlab.mtFeval((String)"eval", (Object[])new Object[]{string}, (int)1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    boolean isVariableCellStr(int n) {
        return this.getTabularObjectColumnModel().isVariableCellStr(n);
    }

    String getVariableDescription(int n) {
        String string = this.getVariableName() + ".Properties.VarDescription{" + Integer.toString(n + 1) + "};";
        try {
            return (String)Matlab.mtFeval((String)"eval", (Object[])new Object[]{string}, (int)1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private TabularObjectColumnModel getTabularObjectColumnModel() {
        return (TabularObjectColumnModel)this.getColumnModel();
    }

    void setVariableUnits(String string, int n) {
        ((TabularObjectTableModel)((Object)this.getModel())).setVariableUnits(string, n);
    }

    void setVariableDescription(String string, int n) {
        ((TabularObjectTableModel)((Object)this.getModel())).setVariableDescription(string, n);
    }

    void sortAscending() {
        String[] stringArray = this.getSelectedVariableNameArray();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).sortAscending(stringArray);
    }

    void sortDescending() {
        String[] stringArray = this.getSelectedVariableNameArray();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).sortDescending(stringArray);
    }

    void toNominal() {
        String[] stringArray = this.getSelectedVariableNameArray();
        if (stringArray == null || stringArray.length != 1) {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).toNominal(stringArray[0]);
    }

    public void refreshObjectSpecificPopup() {
        int n;
        int n2;
        if (this.fSelectionPopupMenu == null) {
            return;
        }
        for (n2 = 0; n2 < this.fSPItemsAddedCount; ++n2) {
            this.fSelectionPopupMenu.remove(this.fSelectionPopupMenu.getComponentCount() - 1);
        }
        this.fSPItemsAddedCount = 0;
        if (this.getSelectedColumnCount() > 0 && this.getSelectedRowCount() > 0) {
            n2 = this.isAllDatasetColumnsSelected() ? 1 : 0;
            n = this.isAllDatasetRowsSelected();
            if (!(n2 == 0 && n == 0 || n2 != 0 && n != 0)) {
                if (n != 0) {
                    this.fSelectionPopupMenu.add((Action)this.fInsertAsNewVariableAction);
                    this.fSelectionPopupMenu.add((Action)this.fInsertAsNewVarRightAction);
                } else {
                    this.fSelectionPopupMenu.add((Action)this.fInsertAsNewObservationAction);
                    this.fSelectionPopupMenu.add((Action)this.fInsertAsNewObsBelowAction);
                }
                this.fSPItemsAddedCount += 2;
                this.fSelectionPopupMenu.addSeparator();
                ++this.fSPItemsAddedCount;
                if (n != 0 && n2 == 0) {
                    this.fSelectionPopupMenu.add((Action)this.fDeleteVariablesAction);
                    ++this.fSPItemsAddedCount;
                }
                if (n == 0 && n2 != 0) {
                    this.fSelectionPopupMenu.add((Action)this.fDeleteObservationsAction);
                    ++this.fSPItemsAddedCount;
                }
            }
            if (n != 0) {
                if (this.isSortEnabled()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fSortAscendingAction);
                    this.fSelectionPopupMenu.add((Action)this.fSortDescendingAction);
                    this.fSPItemsAddedCount += 3;
                }
                if (this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isUngroupedIntervalSelected()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fGroupVariableAction);
                    this.fSPItemsAddedCount += 2;
                }
                if (this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isSingleSpanningColumnSelected()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fUngroupVariableAction);
                    this.fSPItemsAddedCount += 2;
                }
                if (this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isCellStringSelected()) {
                    this.fSelectionPopupMenu.addSeparator();
                    this.fSelectionPopupMenu.add((Action)this.fConvertToNominalAction);
                    this.fSPItemsAddedCount += 2;
                }
            }
        }
        if (this.getSelectedRowCount() > 0 && this.getSelectedColumnCount() > 0) {
            this.fSelectionPopupMenu.addSeparator();
            this.fSelectionPopupMenu.add((JMenuItem)this.fExtractMenu);
            this.fSPItemsAddedCount += 2;
            this.fExtractMenu.removeAll();
            this.fExtractMenu.add((Action)this.fExtractAction);
            this.fExtractMenu.add((Action)((Object)this.fExtractDatasetVariablesAction));
            TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
            n = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex());
            int n3 = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex());
            if (n3 >= n) {
                if (this.getTabularObjectColumnModel().isNumericSelection()) {
                    this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newnumeric"));
                } else {
                    this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newcell"));
                }
                this.fExtractMenu.add((Action)this.fExtractDatasetVariableArrayAction);
            }
        }
    }

    public boolean isSortEnabled() {
        return this.getColumnModel() instanceof TabularObjectColumnModel && this.getTabularObjectColumnModel().isSortEnabled();
    }

    @Override
    public String[] getGraphableNames() {
        if (this.useMinimalMenus()) {
            return STRINGS;
        }
        return this.getSelectionVariableStrings();
    }

    @Override
    public String[] getGraphableSizes() {
        return null;
    }

    private static String arrayToMatlabString(int[] nArray, int n) {
        if (nArray == null || nArray.length == 0 || nArray.length == n) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = nArray[0];
        stringBuilder.append(Integer.toString(n3 + 1));
        if (nArray.length == 1) {
            return stringBuilder.toString();
        }
        for (int i = 1; i <= nArray.length - 2; ++i) {
            if (nArray[i] - nArray[i - 1] <= 1) continue;
            if (nArray[i - 1] > n3) {
                stringBuilder.append(":");
                stringBuilder.append(Integer.toString(nArray[i - 1] + 1));
            }
            stringBuilder.append(",");
            ++n2;
            n3 = nArray[i];
            stringBuilder.append(Integer.toString(n3 + 1));
        }
        if (nArray[nArray.length - 1] - nArray[nArray.length - 2] > 1) {
            stringBuilder.append(":");
            stringBuilder.append(Integer.toString(nArray[nArray.length - 2] + 1));
            stringBuilder.append(",");
        } else {
            stringBuilder.append(":");
        }
        ++n2;
        if (nArray[nArray.length - 1] + 1 < n) {
            stringBuilder.append(Integer.toString(nArray[nArray.length - 1] + 1));
        } else {
            stringBuilder.append("end");
        }
        if (n2 >= 2) {
            return "[" + stringBuilder.toString() + "]";
        }
        return stringBuilder.toString();
    }

    public void selectEntireColumns() {
        int[] nArray = this.getSelectedColumns();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getRowCount();
        if (n != 0) {
            if (this.isSelectionModeByHeader()) {
                this.setColumnSelectionAllowed(true);
                this.setRowSelectionAllowed(false);
            }
            CellLocation cellLocation = this.getAnchorLocation();
            List list = DatasetTable.getSelectionIntervals((int[])nArray);
            for (int[] nArray2 : list) {
                this.addColumnSelectionInterval(nArray2[0], nArray2[1]);
            }
            this.setAnchorLocation(cellLocation);
            this.setRowSelectionInterval(n - 1, 0);
        }
        this.setSelectedRowsFullySelected(false);
        this.setSelectedColumnsFullySelected(true);
    }

    public void selectEntireRows() {
        if (this.getSelectedRowsFullySelected()) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getColumnCount();
        if (n != 0) {
            if (this.isSelectionModeByHeader()) {
                this.setColumnSelectionAllowed(false);
                this.setRowSelectionAllowed(true);
            }
            CellLocation cellLocation = this.getAnchorLocation();
            List list = DatasetTable.getSelectionIntervals((int[])nArray);
            for (int[] nArray2 : list) {
                this.addRowSelectionInterval(nArray2[0], nArray2[1]);
            }
            this.setAnchorLocation(cellLocation);
            this.setColumnSelectionInterval(n - 1, 0);
        }
        this.setSelectedRowsFullySelected(true);
        this.setSelectedColumnsFullySelected(false);
    }

    @Override
    public String[] getGraphableClasses() {
        return null;
    }

    @Override
    public Action getMorePlotsAction() {
        return this.fCatalogAction;
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.add(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.remove(listSelectionListener);
    }

    @Override
    public void graphingActionsChanged() {
        for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
            listSelectionListener.valueChanged(new ListSelectionEvent(this, 0, this.getRowCount() - 1, false));
        }
    }

    public VariableIdentifier getVariableIdentifier() {
        String string = this.getSelectionNameString();
        return new VariableIdentifier(string, string, this.getVariable().getWorkspaceID());
    }

    public void addVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.add(listSelectionListener);
    }

    public void removeVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.remove(listSelectionListener);
    }

    @Override
    protected void populateClipboardFromIdentifier(VariableIdentifier variableIdentifier) {
        if (variableIdentifier.getVariable() != null || variableIdentifier.getExpression() != null) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            RefreshableObjectVariableLiteral.populateClipboardFromObjectIdentifier((ObjectIdentifier)variableIdentifier, (ChangeListener)new SpreadsheetTable.CopyChangeListener((SpreadsheetTable)this, cursor));
        }
    }

    public void setHeaderRenderer(int n) {
        if (this.fHeaderRenderer == null) {
            this.fHeaderRenderer = this.createColumnHeaderRenderer((JTable)((Object)this));
        }
        this.tableHeader.setDefaultRenderer((TableCellRenderer)this.fHeaderRenderer);
    }

    public void cleanup() {
        this.fExtractAction = null;
        this.getSelectionModel().removeListSelectionListener(this.fLSL);
        this.getColumnModel().getSelectionModel().removeListSelectionListener(this.fLSL);
        this.fLSL = null;
        GraphingActionFactory.removeGraphingActionListener(this);
        this.fGraphicListener = null;
        this.fSimpleVariableListener = null;
        this.fCatalogAction = null;
        this.fDatasetMouseAdapter = null;
        this.cleanupMoveWindow();
        super.cleanup();
    }

    private String getSelectionNameString() {
        int n;
        if (!(this.getColumnModel() instanceof TabularObjectColumnModel)) {
            return null;
        }
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        if (this.getSelectedRowCount() == 0 || this.getSelectedColumnCount() == 0) {
            return null;
        }
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray2 == null || nArray2.length == 0 || nArray.length == 0) {
            return null;
        }
        List list = DatasetTable.getSelectionIntervals((int[])nArray);
        List list2 = DatasetTable.getSelectionIntervals((int[])nArray2);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (Object object2 : list2) {
            n = tabularObjectColumnModel.getGroupIndex(object2[0]);
            int n2 = tabularObjectColumnModel.getGroupIndex(object2[1]);
            arrayList.add(new int[]{n, n2});
        }
        Object object = "";
        if (nArray.length > 0 && nArray2.length > 0) {
            String string;
            Object object2;
            object2 = this.getModel();
            n = -1;
            if (object2 instanceof IDataBoundsSupplier) {
                n = ((IDataBoundsSupplier)object2).getLastDataRow() + 1;
            }
            object = (string = ArrayUtils.getSelectionString(list, n, arrayList, -1)).isEmpty() ? this.getVariableName() : this.getVariableName() + '(' + string + ')';
        }
        return object;
    }

    private String[] getSelectedVariableNameArray() {
        List<Pair<String, int[]>> list;
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        if (tabularObjectColumnModel != null && (list = tabularObjectColumnModel.getSelectedVariableNames()) != null) {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)list.get(i).getFirst();
            }
            return stringArray;
        }
        return null;
    }

    private String[] getSelectionVariableStrings() {
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        List<Pair<String, int[]>> list = this.getTabularObjectColumnModel().getSelectedVariableNames();
        if (list == null || nArray == null || nArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        int[] nArray2 = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        String string = DatasetTable.arrayToMatlabString(nArray, nArray2[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            Pair<String, int[]> pair = list.get(i);
            int[] nArray3 = (int[])pair.getSecond();
            int n = nArray3[1] - nArray3[0];
            stringArray[i] = string.isEmpty() ? this.getVariableName() + "." + (String)list.get(i).getFirst() : (n > 1 ? this.getVariableName() + "." + (String)list.get(i).getFirst() + "(" + string + ",:)" : this.getVariableName() + "." + (String)list.get(i).getFirst() + "(" + string + ")");
        }
        return stringArray;
    }

    private static String getMatlabIntervalArrayString(List<int[]> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray = list.get(i);
            stringBuilder.append(Integer.toString(nArray[0] + 1));
            stringBuilder.append(",");
            stringBuilder.append(Integer.toString(nArray[1] + 1));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(";");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected void doRegionCopy(ActionEvent actionEvent) {
        String string = this.getSelectionNameString();
        if (string == null || string.isEmpty()) {
            return;
        }
        this.populateClipboardFromIdentifier(new ObjectIdentifier(string, string, this.getVariableName() + "_copy", this.getVariable().getWorkspaceID()));
    }

    private static String getUniqueMatlabVariableName(String string) {
        String string2 = null;
        try {
            String string3 = "";
            int n = 0;
            boolean bl = true;
            while (bl) {
                double[] dArray;
                Object object = Matlab.mtEval((String)("exist('" + string + string3 + "','var')"), (int)1);
                if (object instanceof double[] && (dArray = (double[])object).length == 1 && dArray[0] > 0.9 && dArray[0] < 1.1) {
                    bl = true;
                    string3 = Integer.toString(++n);
                    continue;
                }
                string2 = string + string3;
                bl = false;
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private void cleanupMoveWindow() {
        if (this.fMoveWindow != null) {
            this.fMoveWindow.setVisible(false);
            this.fMoveWindow.dispose();
            this.fMoveWindow = null;
            this.fMovingColumns = false;
            this.fMoveColumn = -1;
            this.getTableHeader().repaint();
            this.getTableHeader().getTable().requestFocus();
            this.getTableHeader().getTable().requestFocusInWindow();
        }
    }

    public MJAbstractAction[] getCreationActions() {
        MJAbstractAction[] mJAbstractActionArray = new MJAbstractAction[3];
        mJAbstractActionArray[0] = this.fExtractAction;
        mJAbstractActionArray[1] = this.fExtractDatasetVariablesAction;
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        int n = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex());
        int n2 = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex());
        if (n2 >= n) {
            if (this.getTabularObjectColumnModel().isNumericSelection()) {
                this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newnumeric"));
            } else {
                this.fExtractDatasetVariableArrayAction.setName(ArrayUtils.getResource("dataset.newcell"));
            }
            mJAbstractActionArray[2] = this.fExtractDatasetVariableArrayAction;
        }
        return mJAbstractActionArray;
    }

    public Action getDeleteAction(IRegionOpProvider.Scope scope, int n) {
        MJAbstractAction mJAbstractAction = null;
        if (scope == IRegionOpProvider.Scope.ROWS) {
            mJAbstractAction = this.fDeleteObservationsAction;
        } else if (scope == IRegionOpProvider.Scope.COLUMNS) {
            mJAbstractAction = this.fDeleteVariablesAction;
        }
        return mJAbstractAction;
    }

    public Action getInsertAction(IRegionOpProvider.Scope scope, int n) {
        MJAbstractAction mJAbstractAction = null;
        switch (scope) {
            case ROWS: {
                mJAbstractAction = this.fInsertAsNewObservationAction;
                break;
            }
            case ROWS_BELOW: {
                mJAbstractAction = this.fInsertAsNewObsBelowAction;
                break;
            }
            case COLUMNS: {
                mJAbstractAction = this.fInsertAsNewVariableAction;
                break;
            }
            case COLUMNS_TO_THE_RIGHT: {
                mJAbstractAction = this.fInsertAsNewVarRightAction;
                break;
            }
        }
        return mJAbstractAction;
    }

    public List<IRegionOpProvider.Scope> getScopeSupportedForSelection() {
        boolean bl = this.isAllDatasetColumnsSelected();
        boolean bl2 = this.isAllDatasetRowsSelected();
        ArrayList<IRegionOpProvider.Scope> arrayList = new ArrayList<IRegionOpProvider.Scope>();
        if (!(!bl && !bl2 || bl && bl2)) {
            if (bl2 && !bl) {
                arrayList.add(IRegionOpProvider.Scope.COLUMNS);
            }
            if (!bl2 && bl) {
                arrayList.add(IRegionOpProvider.Scope.ROWS);
            }
        }
        return arrayList;
    }

    public int[] getSelectedIndices() {
        return this.getTabularObjectColumnModel().getSelectedIndices();
    }

    public int[] getSelectionIntervalToSet(int n, int n2) {
        int[] nArray = this.getTabularObjectColumnModel().getVariableIndices();
        int[] nArray2 = new int[nArray.length];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                nArray2[n4++] = nArray[i];
                continue;
            }
            if (nArray[i] != nArray[i - 1]) {
                nArray2[n4++] = nArray[i] + n3;
                continue;
            }
            ++n3;
        }
        int[] nArray3 = new int[]{n < nArray2.length ? nArray2[n] : 0, n2 < nArray2.length ? nArray2[n2] : 0};
        return nArray3;
    }

    class DatasetMouseAdapter
    extends MouseAdapter {
        DatasetMouseAdapter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            if (DatasetTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer && ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).isHeaderEditing()) {
                ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).fireEditingStopped();
            }
            if (DatasetTable.this.getTableHeader().getTable().isEditing() && DatasetTable.this.getTableHeader().getTable().getCellEditor() != null) {
                DatasetTable.this.getTableHeader().getTable().getCellEditor().cancelCellEditing();
            }
            super.mouseReleased(mouseEvent);
            Point point = mouseEvent.getPoint();
            int n = DatasetTable.this.getTableHeader().columnAtPoint(point);
            int n2 = DatasetTable.this.getTabularObjectColumnModel().getVariableCount();
            DatasetTable.this.adjustVisibleColumnWidths();
            int n3 = DatasetTable.this.getTableHeader().columnAtPoint(new Point(point.x - 4, point.y));
            int n4 = DatasetTable.this.getTabularObjectColumnModel().getColumn(n3).getPreferredWidth();
            if (n3 < n2 && n3 >= 0) {
                object = ((TabularObjectHeaderRenderer.NamedHeaderContent)DatasetTable.this.getTabularObjectColumnModel().getColumn(n3).getHeaderValue()).getName();
                DatasetTable.this.fColumnWidths.remove(object);
                DatasetTable.this.fColumnWidths.put(object, new Integer(n4));
            }
            DatasetTable.this.getTableHeader().setCursor(new Cursor(0));
            if (DatasetTable.this.fMovingColumns) {
                if (n < 0) {
                    n = 0;
                }
                object = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnInterval(DatasetTable.this.fMoveColumn);
                Object object2 = object[0];
                reference var9_9 = object[1] - true;
                reference var10_10 = object[1] - object[0];
                int n5 = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnWidth(n);
                int[] nArray = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
                int n6 = nArray[0];
                int n7 = nArray[1] - 1;
                int n8 = DatasetTable.this.getTableHeader().columnAtPoint(new Point(mouseEvent.getX() + n5 / 2, mouseEvent.getY()));
                int n9 = n6;
                if (n7 < n8) {
                    n9 = n7 + 1;
                }
                int n10 = n9;
                if (DatasetTable.this.fMoveColumn < n9) {
                    n10 -= var10_10;
                }
                if (n10 < 0) {
                    n10 = 0;
                }
                if (n10 >= n2) {
                    n10 = n2;
                }
                if (n10 != DatasetTable.this.fMoveColumn && n2 != 1) {
                    void var18_19;
                    Object object3 = object2;
                    int n11 = 0;
                    while (var18_19 <= var9_9) {
                        ((TabularObjectColumnModel.TabularObjectColumnSelectionModel)DatasetTable.this.getTabularObjectColumnModel().getSelectionModel()).setRealSelectionInterval(n10 + n11, n10 + n11);
                        ++var18_19;
                        ++n11;
                    }
                    if (n9 < object2 || n9 > var9_9) {
                        ((TabularObjectTableModel)((Object)DatasetTable.this.getTableHeader().getTable().getModel())).move(DatasetTable.this.fMoveColumn, n9);
                        DatasetTable.this.getTableHeader().setCursor(ColumnDragWindow.openHandCursor);
                        DatasetTable.this.fMoveWindow.setCursor(ColumnDragWindow.openHandCursor);
                    } else {
                        DatasetTable.this.cleanupMoveWindow();
                        DatasetTable.this.getTableHeader().repaint();
                    }
                } else {
                    DatasetTable.this.cleanupMoveWindow();
                    DatasetTable.this.getTableHeader().repaint();
                }
            }
            DatasetTable.this.fMovingColumns = false;
            DatasetTable.this.fMoveColumn = -1;
            DatasetTable.this.fIsAdjusting = false;
            DatasetTable.this.getTabularObjectColumnModel().setTableIsAdjusting(false);
            DatasetTable.this.setDragSelectionEnabled(true);
            ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).setHoverColumn(-1);
            DatasetTable.this.getTableHeader().getTable().repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DatasetTable.this.fIsAdjusting = true;
            DatasetTable.this.getTabularObjectColumnModel().setTableIsAdjusting(true);
            if (DatasetTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer && ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).isHeaderEditing()) {
                ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).fireEditingStopped();
            }
            if (DatasetTable.this.getTableHeader().getTable().isEditing() && DatasetTable.this.getTableHeader().getTable().getCellEditor() != null) {
                DatasetTable.this.getTableHeader().getTable().getCellEditor().stopCellEditing();
            }
            if (mouseEvent.getButton() != 1) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = DatasetTable.this.getTableHeader().columnAtPoint(point);
            Rectangle rectangle = DatasetTable.this.getTableHeader().getHeaderRect(n);
            int[] nArray = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
            int n2 = nArray[0];
            int n3 = nArray[1] - 1;
            int n4 = nArray[1] - nArray[0];
            if (point.x - rectangle.x > 2 && point.x - rectangle.x < TabularObjectHeaderRenderer.getGripIconWidth() && n < DatasetTable.this.getNumVariableColumns() && n >= 0 && n == n2) {
                DatasetTable.this.fMovingColumns = true;
                DatasetTable.this.setDragSelectionEnabled(false);
                DatasetTable.this.fMoveColumn = n;
                DatasetTable.this.fMoveWindow = new ColumnDragWindow(DatasetTable.this.getTableHeader().getTable(), n2, n3);
                DatasetTable.this.fMoveWindow.setLocation(mouseEvent.getLocationOnScreen());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() != 1) {
                return;
            }
            if (DatasetTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer) {
                Point point = mouseEvent.getPoint();
                int n = DatasetTable.this.getTableHeader().columnAtPoint(point);
                int[] nArray = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
                int n2 = nArray[0];
                int n3 = nArray[1] - 1;
                int n4 = nArray[1] - nArray[0];
                Rectangle rectangle = DatasetTable.this.getTableHeader().getHeaderRect(n2).union(DatasetTable.this.getTableHeader().getHeaderRect(n3));
                point.x -= rectangle.x;
                point.y -= rectangle.y;
                if (point.x > (int)rectangle.getWidth() - TabularObjectHeaderRenderer.DropDownPanel.getArrowButtonWidth() && n2 < DatasetTable.this.getTabularObjectColumnModel().getVariableColumnCount()) {
                    DatasetTable.this.showMetadataPopup(n2);
                } else if (n == DatasetTable.this.fLastColumnHeaderClick && ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).isEditableAtPoint(point, n2, DatasetTable.this.fTabularObjectColumnModel.getColumn(n2).getHeaderValue())) {
                    ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).editColumnHeaderCellAt((JTable)((Object)DatasetTable.this), n2);
                }
                DatasetTable.this.fLastColumnHeaderClick = n;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!DatasetTable.this.fMovingColumns) {
                DatasetTable.this.getTableHeader().setCursor(new Cursor(0));
            }
            ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).setDropArrowColumn(-1);
            DatasetTable.this.getTableHeader().repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = DatasetTable.this.getTableHeader().columnAtPoint(point);
            if (n < 0) {
                if (!DatasetTable.this.fMovingColumns) {
                    DatasetTable.this.getTableHeader().setCursor(new Cursor(0));
                }
                ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).setDropArrowColumn(-1);
                DatasetTable.this.getTableHeader().repaint();
                return;
            }
            int[] nArray = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
            int n2 = nArray[0];
            int n3 = nArray[1] - 1;
            int n4 = nArray[1] - nArray[0];
            Rectangle rectangle = DatasetTable.this.getTableHeader().getHeaderRect(n2).union(DatasetTable.this.getTableHeader().getHeaderRect(n3));
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            if (point.x <= 2 && n > 0 || point.x >= rectangle.width - 2) {
                DatasetTable.this.getTableHeader().setCursor(new Cursor(10));
            } else if (point.x > 2 && point.x < TabularObjectHeaderRenderer.getGripIconWidth() && n < DatasetTable.this.getNumVariableColumns() && !((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).isHeaderEditing() && !DatasetTable.this.getTableHeader().getTable().isEditing()) {
                if (!DatasetTable.this.fMovingColumns) {
                    DatasetTable.this.getTableHeader().setCursor(ColumnDragWindow.openHandCursor);
                }
            } else if (((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).isEditableAtPoint(point, n, DatasetTable.this.fTabularObjectColumnModel.getColumn(n).getHeaderValue()) && point.x < (int)rectangle.getWidth() - TabularObjectHeaderRenderer.DropDownPanel.getArrowButtonWidth() && n < DatasetTable.this.getNumVariableColumns()) {
                DatasetTable.this.getTableHeader().setCursor(new Cursor(2));
            } else {
                DatasetTable.this.getTableHeader().setCursor(new Cursor(0));
            }
            int n5 = ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).getDropArrowColumn();
            if (n5 != nArray[0]) {
                ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).setDropArrowColumn(nArray[0]);
                DatasetTable.this.getTableHeader().repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3;
            Rectangle rectangle;
            DatasetTable.this.fIsAdjusting = true;
            DatasetTable.this.getTabularObjectColumnModel().setTableIsAdjusting(true);
            if (DatasetTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer && ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).isHeaderEditing()) {
                ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).fireEditingStopped();
            }
            if (DatasetTable.this.getTableHeader().getTable().isEditing() && DatasetTable.this.getTableHeader().getTable().getCellEditor() != null) {
                DatasetTable.this.getTableHeader().getTable().getCellEditor().stopCellEditing();
            }
            if (DatasetTable.this.fMovingColumns) {
                mouseEvent.consume();
            }
            super.mouseDragged(mouseEvent);
            Point point = mouseEvent.getPoint();
            int n4 = DatasetTable.this.getTableHeader().columnAtPoint(point);
            if (DatasetTable.this.fMovingColumns && !(rectangle = DatasetTable.this.getVisibleRect()).contains(point) && (n3 = DatasetTable.this.getColumnModel().getColumnIndexAtX(point.x)) >= 0) {
                n2 = 1;
                if (DatasetTable.this.fMovingColumns) {
                    n = DatasetTable.this.getNumVariableColumns();
                    if (n4 < 0 || n4 >= n) {
                        n2 = 0;
                    }
                }
                if (n2 != 0) {
                    Rectangle rectangle2 = DatasetTable.this.getCellRect(0, n3, true);
                    DatasetTable.this.scrollRectToVisible(rectangle2);
                }
            }
            if (DatasetTable.this.fMovingColumns && DatasetTable.this.fMoveWindow != null) {
                DatasetTable.this.getTableHeader().setCursor(ColumnDragWindow.closedHandCursor);
                int n5 = DatasetTable.this.getNumVariableColumns();
                if (n4 >= 0 && n4 < n5) {
                    if (!DatasetTable.this.fMoveWindow.isVisible()) {
                        DatasetTable.this.fMoveWindow.setVisible(true);
                    }
                    DatasetTable.this.fMoveWindow.setLocation(new Point(mouseEvent.getLocationOnScreen().x, DatasetTable.this.getTableHeader().getLocationOnScreen().y));
                    int[] nArray = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnInterval(DatasetTable.this.fMoveColumn);
                    n2 = nArray[0];
                    n = nArray[1] - 1;
                    int n6 = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnWidth(n4);
                    int[] nArray2 = DatasetTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n4);
                    int n7 = nArray2[0];
                    int n8 = nArray2[1] - 1;
                    int n9 = DatasetTable.this.getTableHeader().columnAtPoint(new Point(mouseEvent.getX() + n6 / 2, mouseEvent.getY()));
                    int n10 = n7;
                    if (n8 < n9) {
                        n10 = n8 + 1;
                    }
                    if (n10 < n2 || n10 > n) {
                        if (n10 != n2 && n10 != n + 1) {
                            ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).setHoverColumn(n10);
                        }
                    } else {
                        ((TabularObjectHeaderRenderer)DatasetTable.this.fHeaderRenderer).setHoverColumn(-1);
                    }
                }
                DatasetTable.this.getTableHeader().repaint();
                DatasetTable.this.getTableHeader().getTable().repaint();
            }
        }
    }

    private class StopMovingAction
    extends AbstractAction {
        private StopMovingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DatasetTable.this.fMovingColumns) {
                DatasetTable.this.cleanupMoveWindow();
            }
        }
    }

    public class BorderedCellRenderer
    extends SpreadsheetCellRenderer {
        public BorderedCellRenderer(SpreadsheetTable spreadsheetTable) {
            super(spreadsheetTable.getFormat());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Border border = ((JLabel)component).getBorder();
            if (((TabularObjectHeaderRenderer)((Object)DatasetTable.this.getTableHeader().getDefaultRenderer())).getHoverColumn() == n2) {
                if (border instanceof SpreadsheetCellBorder) {
                    ((JLabel)component).setBorder((Border)new SpreadsheetCellBorder(null, Color.BLACK, null, null, null));
                } else {
                    ((JLabel)component).setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.BLACK));
                }
            }
            return component;
        }
    }

    private class PostPasteSelectionRunnable
    implements Runnable {
        private String iPastedDataExpression;
        private Point iTopLeftCell;

        PostPasteSelectionRunnable(String string, Point point) {
            this.iPastedDataExpression = string;
            this.iTopLeftCell = point;
        }

        @Override
        public void run() {
            MatlabWorker<double[]> matlabWorker = new MatlabWorker<double[]>(){

                public double[] runOnMatlabThread() {
                    try {
                        return (double[])Matlab.mtEval((String)("variableEditorGridSize(" + PostPasteSelectionRunnable.this.iPastedDataExpression + ");"), (int)1);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public void runOnAWTEventDispatchThread(double[] dArray) {
                    if (dArray.length != 2) {
                        return;
                    }
                    DatasetTable.this.clearSelection();
                    DatasetTable.this.setRowSelectionInterval(((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.x, ((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.x + (int)dArray[0] - 1);
                    DatasetTable.this.setColumnSelectionInterval(((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.y, ((PostPasteSelectionRunnable)PostPasteSelectionRunnable.this).iTopLeftCell.y + (int)dArray[1] - 1);
                }
            };
            matlabWorker.start();
        }
    }

    private class ConvertToNominalAction
    extends MJAbstractAction {
        ConvertToNominalAction() {
            super(ArrayUtils.getResource("dataset.convertnominal"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatasetTable.this.toNominal();
        }
    }

    private class SortDescendingAction
    extends MJAbstractAction {
        SortDescendingAction() {
            super(ArrayUtils.getResource("dataset.sortdescend"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatasetTable.this.sortDescending();
        }
    }

    private class SortAscendingAction
    extends MJAbstractAction {
        SortAscendingAction() {
            super(ArrayUtils.getResource("dataset.sortascend"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatasetTable.this.sortAscending();
        }
    }

    private class GroupVariableAction
    extends MJAbstractAction {
        GroupVariableAction() {
            super(ArrayUtils.getResource("dataset.groupvars"));
        }

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabularObjectColumnModel tabularObjectColumnModel = DatasetTable.this.getTabularObjectColumnModel();
            String string = "variableEditorGroupCode(" + DatasetTable.this.getVariableName() + ",'" + DatasetTable.this.getVariableName() + "'," + Integer.toString(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex() + 1) + "," + Integer.toString(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex() + 1) + ")";
            ((TabularObjectTableModel)((Object)DatasetTable.this.getModel())).evalMatlabString(string, true, true);
        }
    }

    private class UngroupVariableAction
    extends MJAbstractAction {
        UngroupVariableAction() {
            super(ArrayUtils.getResource("dataset.ungroupvars"));
        }

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabularObjectColumnModel tabularObjectColumnModel = DatasetTable.this.getTabularObjectColumnModel();
            if (!tabularObjectColumnModel.isSingleSpanningColumnSelected()) {
                return;
            }
            String string = "variableEditorUngroupCode(" + DatasetTable.this.getVariableName() + ",'" + DatasetTable.this.getVariableName() + "'," + Integer.toString(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex() + 1) + ")";
            ((TabularObjectTableModel)((Object)DatasetTable.this.getModel())).evalMatlabString(string, true, true);
        }
    }

    private class DeleteVariableAction
    extends MJAbstractAction {
        DeleteVariableAction() {
            super(ArrayUtils.getResource("dataset.delcols"));
        }

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List list = DatasetTable.getSelectionIntervals((int[])DatasetTable.this.restrictRowColumnSpecToValidRegion(DatasetTable.this.getSelectedColumns(), 1));
            if (list.isEmpty()) {
                return;
            }
            String string = DatasetTable.getMatlabIntervalArrayString(list);
            ((TabularObjectTableModel)((Object)DatasetTable.this.getModel())).deleteTableObjectColumns(string);
        }
    }

    private class DeleteObservationAction
    extends MJAbstractAction {
        DeleteObservationAction() {
            super(ArrayUtils.getResource("dataset.delrows"));
        }

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List list = DatasetTable.getSelectionIntervals((int[])DatasetTable.this.restrictRowColumnSpecToValidRegion(DatasetTable.this.getSelectedRows(), 0));
            String string = DatasetTable.getMatlabIntervalArrayString(list);
            ((TabularObjectTableModel)((Object)DatasetTable.this.getModel())).deleteTableObjectRows(string);
        }
    }

    private class ExtractDatasetVariablesAction
    extends MJAbstractAction {
        ExtractDatasetVariablesAction() {
            super(ArrayUtils.getResource("dataset.separatevars"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final String[] stringArray = DatasetTable.this.getSelectionVariableStrings();
            if (stringArray == null) {
                return;
            }
            final String[] stringArray2 = DatasetTable.this.getSelectedVariableNameArray();
            if (stringArray2 == null || stringArray2.length == 0) {
                return;
            }
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    int n;
                    String[] stringArray3 = new String[stringArray2.length];
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray3[n] = DatasetTable.getUniqueMatlabVariableName(stringArray2[n]);
                    }
                    for (n = 0; n < stringArray2.length; ++n) {
                        MLExecuteServices.executeCommand((String)(stringArray3[n] + " = " + stringArray[n] + ";"));
                    }
                }
            });
        }
    }

    private class ExtractDatasetVariableArrayAction
    extends MJAbstractAction {
        private ExtractDatasetVariableArrayAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DatasetTable.this.getSelectionNameString();
            if (string == null || string.isEmpty()) {
                return;
            }
            boolean bl = DatasetTable.this.getTabularObjectColumnModel().isNumericSelection();
            final String string2 = bl ? "double(" + string + ")" : "dataset2cell(" + string + ")";
            int[] nArray = DatasetTable.this.getSelectedIndices();
            String string3 = "";
            if (nArray != null && nArray.length > 0) {
                string3 = DatasetTable.this.getTabularObjectColumnModel().getVariableName(nArray[0]);
            }
            final String string4 = string3;
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    String string = DatasetTable.getUniqueMatlabVariableName(string4);
                    MLExecuteServices.executeCommand((String)(string + " = " + string2 + ";"));
                }
            });
        }
    }

    private class ExtractDatasetAction
    extends MJAbstractAction {
        ExtractDatasetAction() {
            super(ArrayUtils.getResource("dataset.newdataset"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = DatasetTable.this.getSelectedIndices();
            String string = "untitled";
            if (nArray != null && nArray.length > 0) {
                string = DatasetTable.this.getTabularObjectColumnModel().getVariableName(nArray[0]);
            }
            final String string2 = string;
            final String string3 = DatasetTable.this.getSelectionNameString();
            if (string3 == null || string3.isEmpty()) {
                return;
            }
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    MLExecuteServices.executeCommand((String)(DatasetTable.getUniqueMatlabVariableName(string2) + " = " + string3 + ";"));
                }
            });
        }
    }

    private class MorePlotsAction
    extends ArrayUtils.BaseAction {
        MorePlotsAction() {
            super("show-plot-catalog", "show-plot-catalog");
            DatasetTable.this.registerWithMapsUsingKeyBindingManager(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray;
            if (DatasetTable.this.fMorePlotsDlg == null) {
                DatasetTable.this.fMorePlotsDlg = PlotCatalog.getInstance();
            }
            if ((stringArray = DatasetTable.this.getSelectionVariableStrings()) != null) {
                DatasetTable.this.fMorePlotsDlg.setPlottedVars(stringArray);
                DatasetTable.this.fMorePlotsDlg.show();
            }
        }
    }

    private class SelListener
    implements ListSelectionListener {
        private SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                String[] stringArray = DatasetTable.this.getGraphableNames();
                DatasetTable.this.refreshObjectSpecificPopup();
                if (DatasetTable.this.fGraphicListener != null) {
                    for (ListSelectionListener listSelectionListener : DatasetTable.this.fGraphicListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                if (DatasetTable.this.fSimpleVariableListener != null) {
                    for (ListSelectionListener listSelectionListener : DatasetTable.this.fSimpleVariableListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                DatasetTable.this.fExtractAction.setEnabled(stringArray != null && stringArray.length > 0);
                DatasetTable.this.fExtractDatasetVariableArrayAction.setEnabled(stringArray != null && stringArray.length > 0);
                DatasetTable.this.fExtractDatasetVariablesAction.setEnabled(stringArray != null && stringArray.length > 0);
                boolean bl = DatasetTable.this.isAllDatasetRowsSelected();
                boolean bl2 = DatasetTable.this.isAllDatasetColumnsSelected();
                DatasetTable.this.getCutAction().setEnabled(!(!bl && !bl2 || bl2 && bl));
            }
        }
    }
}

