/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerLeaseMap;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.lease.AbstractLease;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class FiddlerLease
extends AbstractLease
implements ReferentUuid {
    private static final long serialVersionUID = 2L;
    final Fiddler server;
    final Uuid serverID;
    final Uuid registrationID;
    final Uuid leaseID;
    static /* synthetic */ Class class$net$jini$core$lease$Lease;
    static /* synthetic */ Class class$com$sun$jini$fiddler$Fiddler;
    static /* synthetic */ Class class$net$jini$id$Uuid;

    public static FiddlerLease createLease(Fiddler fiddler, Uuid uuid, Uuid uuid2, Uuid uuid3, long l) {
        if (fiddler instanceof RemoteMethodControl) {
            return new ConstrainableFiddlerLease(fiddler, uuid, uuid2, uuid3, l, null);
        }
        return new FiddlerLease(fiddler, uuid, uuid2, uuid3, l);
    }

    private FiddlerLease(Fiddler fiddler, Uuid uuid, Uuid uuid2, Uuid uuid3, long l) {
        super(l);
        this.server = fiddler;
        this.serverID = uuid;
        this.registrationID = uuid2;
        this.leaseID = uuid3;
    }

    public LeaseMap createLeaseMap(long l) {
        return FiddlerLeaseMap.createLeaseMap(this, l);
    }

    public boolean canBatch(Lease lease) {
        return lease instanceof FiddlerLease && this.serverID.equals((Object)((FiddlerLease)lease).serverID);
    }

    Fiddler getServer() {
        return this.server;
    }

    Uuid getServerID() {
        return this.serverID;
    }

    Uuid getRegistrationID() {
        return this.registrationID;
    }

    Uuid getLeaseID() {
        return this.leaseID;
    }

    void setExpiration(long l) {
        this.expiration = l;
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        this.server.cancelLease(this.registrationID, this.leaseID);
    }

    protected long doRenew(long l) throws UnknownLeaseException, RemoteException {
        return this.server.renewLease(this.registrationID, this.leaseID, l);
    }

    public Uuid getReferentUuid() {
        return this.leaseID;
    }

    public int hashCode() {
        return this.leaseID.hashCode();
    }

    public boolean equals(Object object) {
        return ReferentUuids.compare((Object)this, (Object)object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("FiddlerLease.readObject failure - server field is null");
        }
        if (this.serverID == null) {
            throw new InvalidObjectException("FiddlerLease.readObject failure - serverID field is null");
        }
        if (this.registrationID == null) {
            throw new InvalidObjectException("FiddlerLease.readObject failure - registrationID field is null");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data found when attempting to deserialize FiddlerLease instance");
    }

    static final class ConstrainableFiddlerLease
    extends FiddlerLease
    implements RemoteMethodControl {
        static final long serialVersionUID = 2L;
        private static final Method renewMethod = ProxyUtil.getMethod(class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = FiddlerLease.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, "renew", new Class[]{Long.TYPE});
        private static final Method cancelMethod = ProxyUtil.getMethod(class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = FiddlerLease.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, "cancel", new Class[0]);
        private static final Method[] methodMapArray = new Method[]{renewMethod, ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerLease.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "renewLease", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerLease.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerLease.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, Long.TYPE}), cancelMethod, ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerLease.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "cancelLease", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerLease.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerLease.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid})};
        private static final Method[] canBatchMethodMapArray = new Method[]{renewMethod, renewMethod, cancelMethod, cancelMethod};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerLease(Fiddler fiddler, Uuid uuid, Uuid uuid2, Uuid uuid3, long l, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerLease.constrainServer(fiddler, methodConstraints), uuid, uuid2, uuid3, l);
            this.methodConstraints = methodConstraints;
        }

        public boolean canBatch(Lease lease) {
            if (!super.canBatch(lease)) {
                return false;
            }
            if (!(lease instanceof ConstrainableFiddlerLease)) {
                return false;
            }
            return ConstrainableProxyUtil.equivalentConstraints(this.methodConstraints, ((ConstrainableFiddlerLease)lease).methodConstraints, canBatchMethodMapArray);
        }

        private static Fiddler constrainServer(Fiddler fiddler, MethodConstraints methodConstraints) {
            MethodConstraints methodConstraints2 = ConstrainableProxyUtil.translateConstraints(methodConstraints, methodMapArray);
            RemoteMethodControl remoteMethodControl = ((RemoteMethodControl)fiddler).setConstraints(methodConstraints2);
            return (Fiddler)remoteMethodControl;
        }

        public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
            return new ConstrainableFiddlerLease(this.server, this.serverID, this.registrationID, this.leaseID, this.expiration, methodConstraints);
        }

        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMapArray);
        }
    }
}

