/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.ErrorManager;

public abstract class SyntaxElement {
    protected XMLSyntaxSupport support;
    protected TokenItem first;
    private SyntaxElement previous;
    private SyntaxElement next;
    protected int offset;
    protected int length;

    public SyntaxElement(XMLSyntaxSupport xMLSyntaxSupport, TokenItem tokenItem, int n) {
        this.support = xMLSyntaxSupport;
        this.first = tokenItem;
        this.offset = tokenItem.getOffset();
        this.length = n - this.offset;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    public SyntaxElement getPrevious() {
        try {
            if (this.previous == null) {
                if (this.first.getOffset() == 0) {
                    return null;
                }
                this.previous = this.support.getElementChain(this.getElementOffset() - 1);
                if (this.previous != null) {
                    this.previous.next = this;
                    if (this.previous.first.getOffset() == this.first.getOffset()) {
                        IllegalStateException illegalStateException = new IllegalStateException("Previous cannot be the same as current element at offset " + this.first.getOffset() + " " + this.first.getImage());
                        ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                        return null;
                    }
                }
            }
            return this.previous;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public SyntaxElement getNext() {
        try {
            if (this.next == null) {
                this.next = this.support.getElementChain(this.offset + this.length + 1);
                if (this.next != null) {
                    this.next.previous = this;
                    if (this.next.first.getOffset() == this.first.getOffset()) {
                        return null;
                    }
                }
            }
            return this.next;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String toString() {
        String string = "?";
        try {
            string = this.support.getDocument().getText(this.offset, this.length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "SyntaxElement [offset=" + this.offset + "; length=" + this.length + " ;type = " + this.getClass().getName() + "; content:" + string + "]";
    }

    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.length;
    }

    public boolean equals(Object object) {
        return object instanceof SyntaxElement && ((SyntaxElement)object).offset == this.offset;
    }

    public static class Error
    extends SyntaxElement {
        public Error(XMLSyntaxSupport xMLSyntaxSupport, TokenItem tokenItem, int n) {
            super(xMLSyntaxSupport, tokenItem, n);
        }

        @Override
        public String toString() {
            return "Error" + super.toString();
        }
    }
}

