/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.view;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.editor.view.spi.ViewLayoutQueue;
import org.netbeans.editor.view.spi.ViewLayoutState;
import org.netbeans.lib.editor.view.GapBoxView;
import org.netbeans.lib.editor.view.GapBoxViewChildren;
import org.netbeans.lib.editor.view.GapDocumentViewChildren;

public class GapDocumentView
extends GapBoxView {
    private static final boolean debugPaint = Boolean.getBoolean("netbeans.debug.editor.view.paint");
    private static final boolean debugRepaint = Boolean.getBoolean("netbeans.debug.editor.view.repaint");
    private static final int ASYNC_CHILDREN_UPDATE_COUNT = 20;
    private static final int CHILDREN_UPDATE_SUBTASK_COUNT = 50;
    private ChildrenUpdateTask childrenUpdateTask;
    private int lastAllocationX;
    private int lastAllocationY;
    private int lastAllocationWidth;
    private int lastAllocationHeight;
    private double firstRepaintChildYSubOffset;
    private double firstRepaintChildYSubSpan;
    private float firstRepaintChildXSubOffset;
    private int layoutLockDepth;

    public GapDocumentView(Element element) {
        super(element, 1);
    }

    @Override
    protected GapBoxViewChildren createChildren() {
        return new GapDocumentViewChildren(this);
    }

    @Override
    protected Rectangle reallocate(Shape shape) {
        Rectangle rectangle = super.reallocate(shape);
        this.lastAllocationX = rectangle.x;
        this.lastAllocationY = rectangle.y;
        this.lastAllocationWidth = rectangle.width;
        this.lastAllocationHeight = rectangle.height;
        return rectangle;
    }

    @Override
    protected void directUpdateLayout() {
        if (this.layoutLockDepth == 0) {
            super.directUpdateLayout();
        }
    }

    protected final void layoutLock() {
        ++this.layoutLockDepth;
    }

    protected final void layoutUnlock() {
        --this.layoutLockDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderWithUpdateLayout(Runnable runnable) {
        ++this.layoutLockDepth;
        try {
            runnable.run();
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(View view) {
        ++this.layoutLockDepth;
        try {
            super.setParent(view);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(float f, float f2) {
        ++this.layoutLockDepth;
        try {
            super.setSize(f, f2);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        ++this.layoutLockDepth;
        try {
            super.insertUpdate(documentEvent, shape, viewFactory);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        ++this.layoutLockDepth;
        try {
            super.removeUpdate(documentEvent, shape, viewFactory);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        ++this.layoutLockDepth;
        try {
            super.changedUpdate(documentEvent, shape, viewFactory);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics, Shape shape) {
        if (debugPaint) {
            System.err.println("VIEW-PAINT: clip=" + graphics.getClipBounds() + ", alloc=" + shape);
        }
        ++this.layoutLockDepth;
        try {
            super.paint(graphics, shape);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    @Override
    public void repaint(ViewLayoutState viewLayoutState, double d, double d2, float f, float f2) {
        int n = this.getChildIndexNoCheck(viewLayoutState);
        if (this.markRepaint(n, false)) {
            this.firstRepaintChildYSubOffset = d;
            this.firstRepaintChildXSubOffset = f;
        }
    }

    @Override
    protected boolean markRepaint(int n, boolean bl) {
        boolean bl2 = super.markRepaint(n, bl);
        if (bl2) {
            this.firstRepaintChildYSubOffset = 0.0;
            this.firstRepaintChildXSubOffset = 0.0f;
        }
        return bl2;
    }

    @Override
    protected void processRepaint(ViewLayoutState.Parent parent) {
        int n = this.getChildren().getFirstRepaintChildIndex();
        if (n >= 0 && n < this.getViewCount()) {
            Container container;
            int n2;
            int n3;
            double d = this.getChildren().getMajorAxisOffset(n);
            int n4 = (int)Math.floor(d += this.firstRepaintChildYSubOffset);
            if (this.isRepaintTillEnd()) {
                n3 = 0;
                n2 = this.lastAllocationHeight;
            } else {
                n3 = (int)Math.floor(this.firstRepaintChildXSubOffset);
                double d2 = d + this.getChild(n).getLayoutMajorAxisPreferredSpan();
                n2 = (int)Math.ceil(d2) - n4;
            }
            int n5 = this.lastAllocationWidth - n3;
            n3 += this.lastAllocationX;
            if (debugRepaint) {
                System.err.println("REPAINT(childIndex=" + n + ", rect(" + n3 + ", " + n4 + ", " + n5 + ", " + n2 + "))");
            }
            if ((container = this.getContainer()) != null) {
                container.repaint(n3, n4, n5, n2);
            }
        }
    }

    ChildrenUpdateTask getChildrenUpdateTask() {
        if (this.childrenUpdateTask == null) {
            this.childrenUpdateTask = new ChildrenUpdateTask();
        }
        return this.childrenUpdateTask;
    }

    @Override
    protected void resetEstimatedSpan(int n, int n2) {
        if (n2 >= 20) {
            ChildrenUpdateTask childrenUpdateTask = this.getChildrenUpdateTask();
            childrenUpdateTask.markResetChildEstimatedSpan();
            childrenUpdateTask.setChildIndex(n);
            if (!childrenUpdateTask.isRunning()) {
                childrenUpdateTask.start();
            }
        } else {
            super.resetEstimatedSpan(n, n2);
        }
    }

    @Override
    protected void markSizeInvalid(int n, int n2) {
        if (n2 >= 20) {
            ChildrenUpdateTask childrenUpdateTask = this.getChildrenUpdateTask();
            childrenUpdateTask.markUpdateChildSize();
            childrenUpdateTask.setChildIndex(0);
            if (!childrenUpdateTask.isRunning()) {
                childrenUpdateTask.start();
            }
        } else {
            super.markSizeInvalid(n, n2);
        }
    }

    protected final int getLastAllocationX() {
        return this.lastAllocationX;
    }

    protected final int getLastAllocationY() {
        return this.lastAllocationY;
    }

    protected final int getLastAllocationWidth() {
        return this.lastAllocationWidth;
    }

    protected final int getLastAllocationHeight() {
        return this.lastAllocationHeight;
    }

    protected ViewLayoutQueue getLayoutQueue() {
        return ViewLayoutQueue.getDefaultQueue();
    }

    final class ChildrenUpdateTask
    implements Runnable {
        private int childIndex = Integer.MAX_VALUE;
        private boolean running;
        private boolean updateChildSize;
        private boolean resetChildEstimatedSpan;

        ChildrenUpdateTask() {
        }

        void markUpdateChildSize() {
            this.updateChildSize = true;
        }

        void markResetChildEstimatedSpan() {
            this.resetChildEstimatedSpan = true;
        }

        void start() {
            this.running = true;
            GapDocumentView.this.getLayoutQueue().addTask(this);
        }

        boolean isRunning() {
            return this.running;
        }

        private void finish() {
            this.running = false;
            this.updateChildSize = false;
            this.resetChildEstimatedSpan = false;
            this.childIndex = Integer.MAX_VALUE;
        }

        void setChildIndex(int n) {
            if (n < this.childIndex) {
                this.childIndex = n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                AbstractDocument abstractDocument = (AbstractDocument)GapDocumentView.this.getDocument();
                if (abstractDocument != null) {
                    abstractDocument.readLock();
                    try {
                        LockView lockView = LockView.get(GapDocumentView.this);
                        if (lockView == null) break block10;
                        lockView.lock();
                        try {
                            GapDocumentView.this.layoutLock();
                            try {
                                this.updateView(lockView);
                            }
                            finally {
                                GapDocumentView.this.updateLayout();
                                GapDocumentView.this.layoutUnlock();
                            }
                        }
                        finally {
                            lockView.unlock();
                        }
                    }
                    finally {
                        abstractDocument.readUnlock();
                    }
                }
            }
        }

        private void updateView(LockView lockView) {
            if (GapDocumentView.this.getContainer() == null) {
                this.finish();
                return;
            }
            int n = GapDocumentView.this.getViewCount();
            int n2 = Math.max(1, n / 50);
            while (n2 > 0 && this.childIndex < n && !lockView.isPriorityThreadWaiting()) {
                ViewLayoutState viewLayoutState = GapDocumentView.this.getChild(this.childIndex);
                if (!viewLayoutState.isFlyweight()) {
                    View view = viewLayoutState.getView();
                    if (this.resetChildEstimatedSpan && view instanceof EstimatedSpanView) {
                        ((EstimatedSpanView)((Object)view)).setEstimatedSpan(false);
                    }
                    if (this.updateChildSize) {
                        viewLayoutState.markViewSizeInvalid();
                    }
                    viewLayoutState.updateLayout();
                    --n2;
                }
                ++this.childIndex;
            }
            if (this.childIndex < n) {
                GapDocumentView.this.getLayoutQueue().addTask(this);
            } else {
                this.finish();
            }
        }
    }
}

