/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;

public class GapList
extends AbstractList
implements RandomAccess,
Cloneable,
Serializable {
    private static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    private transient Object[] elementData;
    private int gapStart;
    private int gapLength;

    public GapList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
        this.gapLength = n;
    }

    public GapList() {
        this.elementData = EMPTY_ELEMENT_ARRAY;
    }

    public GapList(Collection collection) {
        int n = collection.size();
        this.elementData = new Object[(int)Math.min((long)n * 110L / 100L, Integer.MAX_VALUE)];
        collection.toArray(this.elementData);
        this.gapStart = n;
        this.gapLength = this.elementData.length - n;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.gapLength > 0) {
            int n = this.elementData.length - this.gapLength;
            Object[] objectArray = new Object[n];
            this.copyAllData(objectArray);
            this.elementData = objectArray;
            this.gapLength = 0;
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            int n4 = this.gapStart + this.gapLength;
            int n5 = n2 - n4;
            int n6 = n3 - n5;
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.elementData, 0, objectArray, 0, this.gapStart);
            System.arraycopy(this.elementData, n4, objectArray, n6, n5);
            this.elementData = objectArray;
            this.gapLength = n6 - this.gapStart;
        }
    }

    @Override
    public int size() {
        return this.elementData.length - this.gapLength;
    }

    @Override
    public boolean isEmpty() {
        return this.elementData.length == this.gapLength;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            int n;
            for (n = 0; n < this.gapStart; ++n) {
                if (this.elementData[n] != null) continue;
                return n;
            }
            n += this.gapLength;
            int n2 = this.elementData.length;
            while (n < n2) {
                if (this.elementData[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n;
            for (n = 0; n < this.gapStart; ++n) {
                if (!object.equals(this.elementData[n])) continue;
                return n;
            }
            n += this.gapLength;
            int n3 = this.elementData.length;
            while (n < n3) {
                if (object.equals(this.elementData[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            int n;
            int n2 = this.gapStart + this.gapLength;
            for (n = this.elementData.length - 1; n >= n2; --n) {
                if (this.elementData[n] != null) continue;
                return n;
            }
            n -= this.gapLength;
            while (n >= 0) {
                if (this.elementData[n] == null) {
                    return n;
                }
                --n;
            }
        } else {
            int n;
            int n3 = this.gapStart + this.gapLength;
            for (n = this.elementData.length - 1; n >= n3; --n) {
                if (!object.equals(this.elementData[n])) continue;
                return n;
            }
            n -= this.gapLength;
            while (n >= 0) {
                if (object.equals(this.elementData[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            GapList gapList = (GapList)super.clone();
            int n = this.size();
            Object[] objectArray = new Object[n];
            this.copyAllData(objectArray);
            gapList.elementData = objectArray;
            gapList.gapStart = n;
            gapList.resetModCount();
            return gapList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copyItems(int n, int n2, Object[] objectArray, int n3) {
        if (n < 0 || n2 < n || n2 > this.size()) {
            throw new IndexOutOfBoundsException("srcStartIndex=" + n + ", srcEndIndex=" + n2 + ", size()=" + this.size());
        }
        if (n2 < this.gapStart) {
            System.arraycopy(this.elementData, n, objectArray, n3, n2 - n);
        } else if (n >= this.gapStart) {
            System.arraycopy(this.elementData, n + this.gapLength, objectArray, n3, n2 - n);
        } else {
            int n4 = this.gapStart - n;
            System.arraycopy(this.elementData, n, objectArray, n3, n4);
            System.arraycopy(this.elementData, this.gapStart + this.gapLength, objectArray, n3 + n4, n2 - n - n4);
        }
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        this.copyAllData(objectArray);
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        this.copyAllData(objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public Object get(int n) {
        return this.elementData[n < this.gapStart ? n : n + this.gapLength];
    }

    @Override
    public Object set(int n, Object object) {
        if (n >= this.gapStart) {
            n += this.gapLength;
        }
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    @Override
    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    @Override
    public void add(int n, Object object) {
        int n2 = this.size();
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        this.ensureCapacity(n2 + 1);
        this.moveGap(n);
        this.elementData[this.gapStart++] = object;
        --this.gapLength;
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        return this.addArray(n, collection.toArray());
    }

    public boolean addArray(int n, Object[] objectArray) {
        return this.addArray(n, objectArray, 0, objectArray.length);
    }

    public boolean addArray(int n, Object[] objectArray, int n2, int n3) {
        int n4 = this.size();
        if (n > n4 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n4);
        }
        this.ensureCapacity(n4 + n3);
        this.moveGap(n);
        System.arraycopy(objectArray, n2, this.elementData, this.gapStart, n3);
        this.gapStart += n3;
        this.gapLength -= n3;
        return n3 != 0;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public Object remove(int n) {
        int n2 = this.size();
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("remove(): Index: " + n + ", Size: " + n2);
        }
        ++this.modCount;
        this.moveGap(n + 1);
        Object object = this.elementData[n];
        this.removeUpdate(n, this.elementData, n, n + 1);
        this.elementData[n] = null;
        --this.gapStart;
        ++this.gapLength;
        return object;
    }

    public void remove(int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n3 < n || n3 > this.size()) {
            throw new IndexOutOfBoundsException("index=" + n + ", count=" + n2 + ", size()=" + this.size());
        }
        this.removeRange(n, n3);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        if (n == n2) {
            return;
        }
        int n3 = n2 - n;
        if (n >= this.gapStart) {
            this.moveGap(n);
            this.removeUpdate((n += this.gapLength) - this.gapLength, this.elementData, n, n2 += this.gapLength);
            while (n < n2) {
                this.elementData[n] = null;
                ++n;
            }
        } else {
            if (n2 <= this.gapStart) {
                this.moveGap(n2);
                this.gapStart = n;
                this.removeUpdate(n, this.elementData, n, n2);
            } else {
                this.removeUpdate(n, this.elementData, n, this.gapStart);
                for (int i = n; i < this.gapStart; ++i) {
                    this.elementData[i] = null;
                }
                n = this.gapStart + this.gapLength;
                this.gapStart = n2 - n3;
                this.removeUpdate(this.gapStart, this.elementData, n, n2 += this.gapLength);
            }
            while (n < n2) {
                this.elementData[n++] = null;
            }
        }
        this.gapLength += n3;
    }

    protected void removeUpdate(int n, Object[] objectArray, int n2, int n3) {
    }

    private void moveGap(int n) {
        if (n == this.gapStart) {
            return;
        }
        if (n < this.gapStart) {
            int n2 = this.gapStart - n;
            System.arraycopy(this.elementData, n, this.elementData, this.gapStart + this.gapLength - n2, n2);
            this.clearEmpty(n, Math.min(n2, this.gapLength));
            this.gapStart = n;
        } else {
            int n3 = this.gapStart + this.gapLength;
            int n4 = n - this.gapStart;
            System.arraycopy(this.elementData, n3, this.elementData, this.gapStart, n4);
            if (n < n3) {
                this.clearEmpty(n3, n4);
            } else {
                this.clearEmpty(n, this.gapLength);
            }
            this.gapStart += n4;
        }
    }

    private void copyAllData(Object[] objectArray) {
        if (this.gapLength != 0) {
            int n = this.gapStart + this.gapLength;
            System.arraycopy(this.elementData, 0, objectArray, 0, this.gapStart);
            System.arraycopy(this.elementData, n, objectArray, this.gapStart, this.elementData.length - n);
        } else {
            System.arraycopy(this.elementData, 0, objectArray, 0, this.elementData.length);
        }
    }

    private void clearEmpty(int n, int n2) {
        while (--n2 >= 0) {
            this.elementData[n++] = null;
        }
    }

    private void resetModCount() {
        this.modCount = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (n = 0; n < this.gapStart; ++n) {
            objectOutputStream.writeObject(this.elementData[n]);
        }
        n += this.gapLength;
        int n2 = this.elementData.length;
        while (n < n2) {
            objectOutputStream.writeObject(this.elementData[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.elementData = new Object[n2];
        for (n = 0; n < this.gapStart; ++n) {
            this.elementData[n] = objectInputStream.readObject();
        }
        n += this.gapLength;
        int n3 = this.elementData.length;
        while (n < n3) {
            this.elementData[n] = objectInputStream.readObject();
            ++n;
        }
    }

    void consistencyCheck() {
        if (this.gapStart < 0 || this.gapLength < 0 || this.gapStart + this.gapLength > this.elementData.length) {
            this.consistencyError("Inconsistent gap");
        }
        for (int i = this.gapStart + this.gapLength - 1; i >= this.gapStart; --i) {
            if (this.elementData[i] == null) continue;
            this.consistencyError("Non-null value at raw-index i");
        }
    }

    private void consistencyError(String string) {
        throw new IllegalStateException(string + ": " + this.toStringInternals());
    }

    String toStringInternals() {
        return "elementData.length=" + this.elementData.length + ", gapStart=" + this.gapStart + ", gapLength=" + this.gapLength;
    }
}

