/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JCTokenProcessor;
import org.netbeans.editor.ext.java.JavaLayerTokenContext;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaDrawLayerFactory {
    public static final String JAVA_LAYER_NAME = "java-layer";
    public static final int JAVA_LAYER_VISIBILITY = 1010;

    public static class LParenWatcher
    implements DocumentListener {
        NonWhitespaceBwdFinder nwFinder = new NonWhitespaceBwdFinder();

        private void check(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() instanceof BaseDocument) {
                BaseDocument baseDocument = (BaseDocument)documentEvent.getDocument();
                BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
                String string = baseDocumentEvent.getText();
                if (string != null) {
                    int n;
                    boolean bl = false;
                    for (n = string.length() - 1; n >= 0; --n) {
                        if (string.charAt(n) != '(') continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        n = documentEvent.getOffset();
                        int n2 = 0;
                        if (n > 0) {
                            try {
                                n2 = baseDocument.find(this.nwFinder, n - 1, 0);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            if (n2 < 0) {
                                n2 = 0;
                            }
                        }
                        baseDocument.repaintBlock(n2, n);
                    }
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.check(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.check(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    public static class NonWhitespaceBwdFinder
    extends FinderFactory.GenericBwdFinder {
        private char foundChar;

        public char getFoundChar() {
            return this.foundChar;
        }

        @Override
        protected int scan(char c, boolean bl) {
            if (!Character.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return -1;
        }
    }

    static class NonWhitespaceFwdFinder
    extends FinderFactory.GenericFwdFinder {
        private char foundChar;

        NonWhitespaceFwdFinder() {
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        @Override
        protected int scan(char c, boolean bl) {
            if (!Character.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return 1;
        }
    }

    public static class JavaLayer
    extends DrawLayer.AbstractLayer {
        private int resolvedEndOffset;
        private boolean resolvedValue;
        private NonWhitespaceFwdFinder nwFinder = new NonWhitespaceFwdFinder();

        public JavaLayer() {
            super(JavaDrawLayerFactory.JAVA_LAYER_NAME);
        }

        @Override
        public void init(DrawContext drawContext) {
            this.resolvedEndOffset = 0;
        }

        @Override
        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            int n = drawContext.getTokenOffset() + drawContext.getTokenLength();
            this.setNextActivityChangeOffset(n);
            return true;
        }

        protected Coloring getMethodColoring(DrawContext drawContext) {
            TokenContextPath tokenContextPath = drawContext.getTokenContextPath().replaceStart(JavaLayerTokenContext.contextPath);
            return drawContext.getEditorUI().getColoring(tokenContextPath.getFullTokenName(JavaLayerTokenContext.METHOD));
        }

        private boolean isGenericType(JavaSyntaxSupport javaSyntaxSupport, int n) {
            try {
                int n2 = javaSyntaxSupport.getLastCommandSeparator(n);
                JCTokenProcessor jCTokenProcessor = new JCTokenProcessor(n);
                jCTokenProcessor.setJava15(true);
                javaSyntaxSupport.tokenizeText(jCTokenProcessor, n2 + 1, n, true);
                return jCTokenProcessor.getResultExp().getExpID() == 17;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private boolean isMethod(DrawContext drawContext) {
            int n = drawContext.getTokenOffset() + drawContext.getTokenLength();
            if (n > this.resolvedEndOffset) {
                JavaSyntaxSupport javaSyntaxSupport;
                block11: {
                    this.resolvedEndOffset = n;
                    int n2 = drawContext.getEndOffset();
                    int n3 = drawContext.getBufferStartOffset();
                    char[] cArray = drawContext.getBuffer();
                    javaSyntaxSupport = (JavaSyntaxSupport)drawContext.getEditorUI().getDocument().getSyntaxSupport().get(JavaSyntaxSupport.class);
                    int n4 = Analyzer.findFirstNonWhite(cArray, n - n3, n2 - n);
                    if (n4 >= 0) {
                        boolean bl = this.resolvedValue = cArray[n4] == '(';
                        if (!this.resolvedValue && cArray[n4] == '<') {
                            try {
                                int n5;
                                int[] nArray = javaSyntaxSupport.findMatchingBlock(drawContext.getBufferStartOffset() + n4, true);
                                if (nArray == null || (n5 = Utilities.getFirstNonWhiteFwd(drawContext.getEditorUI().getDocument(), nArray[1])) <= -1) break block11;
                                if (n3 + cArray.length > n5) {
                                    this.resolvedValue = cArray[n5 - n3] == '(' && this.isGenericType(javaSyntaxSupport, n5);
                                    break block11;
                                }
                                this.resolvedValue = drawContext.getEditorUI().getDocument().getChars(n5, 1)[0] == '(' && this.isGenericType(javaSyntaxSupport, n5);
                            }
                            catch (BadLocationException badLocationException) {
                                this.resolvedValue = false;
                            }
                        }
                    } else {
                        try {
                            int[] nArray;
                            int n6 = drawContext.getEditorUI().getDocument().find(this.nwFinder, n2, -1);
                            boolean bl = this.resolvedValue = n6 >= 0 && this.nwFinder.getFoundChar() == '(';
                            if (!this.resolvedValue && this.nwFinder.getFoundChar() == '<' && (nArray = javaSyntaxSupport.findMatchingBlock(n6, true)) != null && (n6 = Utilities.getFirstNonWhiteFwd(drawContext.getEditorUI().getDocument(), nArray[1])) > -1) {
                                this.resolvedValue = drawContext.getEditorUI().getDocument().getChars(n6, 1)[0] == '(' && this.isGenericType(javaSyntaxSupport, n6);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            this.resolvedValue = false;
                        }
                    }
                }
                if (this.resolvedValue) {
                    this.resolvedValue = !javaSyntaxSupport.isAnnotation(drawContext.getTokenOffset());
                }
            }
            return this.resolvedValue;
        }

        @Override
        public void updateContext(DrawContext drawContext) {
            Coloring coloring;
            if (drawContext.getTokenID() == JavaTokenContext.IDENTIFIER && this.isMethod(drawContext) && (coloring = this.getMethodColoring(drawContext)) != null) {
                coloring.apply(drawContext);
            }
        }
    }
}

