/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class MultiKeyBinding
extends JTextComponent.KeyBinding
implements Externalizable {
    public KeyStroke[] keys;
    static final long serialVersionUID = -8602816556604003688L;

    public MultiKeyBinding() {
        super(null, null);
    }

    public MultiKeyBinding(KeyStroke[] keyStrokeArray, String string) {
        super(null, string);
        this.keys = keyStrokeArray;
    }

    public MultiKeyBinding(KeyStroke keyStroke, String string) {
        super(keyStroke, string);
    }

    public MultiKeyBinding(JTextComponent.KeyBinding keyBinding) {
        this(keyBinding.key, keyBinding.actionName);
    }

    public boolean equals(Object object) {
        if (object instanceof MultiKeyBinding) {
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)object;
            if (this.actionName == null ? multiKeyBinding.actionName != null : !this.actionName.equals(multiKeyBinding.actionName)) {
                return false;
            }
            if (this.keys == null) {
                if (multiKeyBinding.keys == null) {
                    return this.key == null && multiKeyBinding.key == null || this.key != null && this.key.equals(multiKeyBinding.key);
                }
                return multiKeyBinding.keys.length == 1 && (this.key == null && multiKeyBinding.keys[0] == null || this.key != null && this.key.equals(multiKeyBinding.keys[0]));
            }
            if (multiKeyBinding.keys != null) {
                return Arrays.equals(this.keys, multiKeyBinding.keys);
            }
            return this.keys.length == 1 && (multiKeyBinding.key == null && this.keys[0] == null || multiKeyBinding.key != null && multiKeyBinding.key.equals(this.keys[0]));
        }
        return false;
    }

    public static void updateKeyBindings(JTextComponent.KeyBinding[] keyBindingArray, JTextComponent.KeyBinding[] keyBindingArray2) {
        ArrayList<JTextComponent.KeyBinding> arrayList = new ArrayList<JTextComponent.KeyBinding>(Arrays.asList(keyBindingArray));
        MultiKeyBinding multiKeyBinding = new MultiKeyBinding(new KeyStroke[1], null);
        for (int i = 0; i < keyBindingArray2.length; ++i) {
            MultiKeyBinding multiKeyBinding2;
            if (keyBindingArray2[i] instanceof MultiKeyBinding) {
                multiKeyBinding2 = (MultiKeyBinding)keyBindingArray2[i];
                if (multiKeyBinding2.keys == null) {
                    multiKeyBinding.keys[0] = multiKeyBinding2.key;
                    multiKeyBinding.actionName = multiKeyBinding2.actionName;
                    multiKeyBinding2 = multiKeyBinding;
                }
            } else {
                multiKeyBinding.keys[0] = keyBindingArray2[i].key;
                multiKeyBinding.actionName = keyBindingArray2[i].actionName;
                multiKeyBinding2 = multiKeyBinding;
            }
            boolean bl = false;
            for (int j = 0; j < arrayList.size(); ++j) {
                JTextComponent.KeyBinding keyBinding = arrayList.get(j);
                if (keyBinding instanceof MultiKeyBinding) {
                    MultiKeyBinding multiKeyBinding3 = (MultiKeyBinding)keyBinding;
                    if (multiKeyBinding3.keys == null) {
                        if (multiKeyBinding2.keys.length != 1 || !multiKeyBinding2.keys[0].equals(multiKeyBinding3.key)) continue;
                        if (multiKeyBinding3.actionName == null) {
                            arrayList.remove(i);
                        } else {
                            arrayList.set(i, multiKeyBinding3);
                        }
                        bl = true;
                        break;
                    }
                    if (multiKeyBinding2.keys.length != multiKeyBinding3.keys.length) continue;
                    bl = true;
                    for (int k = 0; k < multiKeyBinding2.keys.length; ++k) {
                        if (multiKeyBinding2.keys[k].equals(multiKeyBinding3.keys[k])) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    if (multiKeyBinding3.actionName == null) {
                        arrayList.remove(i);
                        break;
                    }
                    arrayList.set(i, multiKeyBinding3);
                    break;
                }
                if (multiKeyBinding2.keys.length != 1 || !multiKeyBinding2.keys[0].equals(keyBinding.key)) continue;
                if (keyBinding.actionName == null) {
                    arrayList.remove(i);
                } else {
                    arrayList.set(i, keyBinding);
                }
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(keyBindingArray2[arrayList.size()]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (n >= 0) {
                this.keys = new KeyStroke[n];
                for (int i = 0; i < n; ++i) {
                    this.keys[i] = KeyStroke.getKeyStroke(objectInput.readInt(), objectInput.readInt(), objectInput.readBoolean());
                }
            } else {
                this.keys = null;
            }
            this.key = objectInput.readBoolean() ? KeyStroke.getKeyStroke(objectInput.readInt(), objectInput.readInt(), objectInput.readBoolean()) : null;
            this.actionName = (String)objectInput.readObject();
        } else {
            this.keys = (KeyStroke[])object;
            this.key = (KeyStroke)objectInput.readObject();
            this.actionName = (String)objectInput.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.keys != null) {
            objectOutput.writeObject(new Integer(this.keys.length));
            for (int i = 0; i < this.keys.length; ++i) {
                objectOutput.writeInt(this.keys[i].getKeyCode());
                objectOutput.writeInt(this.keys[i].getModifiers());
                objectOutput.writeBoolean(this.keys[i].isOnKeyRelease());
            }
        } else {
            objectOutput.writeObject(new Integer(-1));
        }
        if (this.key != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeInt(this.key.getKeyCode());
            objectOutput.writeInt(this.key.getModifiers());
            objectOutput.writeBoolean(this.key.isOnKeyRelease());
        } else {
            objectOutput.writeBoolean(false);
        }
        objectOutput.writeObject(this.actionName);
    }

    public String toString() {
        if (this.keys == null) {
            return "key=" + this.key + ", actionName=" + this.actionName;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.keys.length; ++i) {
            stringBuffer.append("key");
            stringBuffer.append(i);
            stringBuffer.append('=');
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append("actionName=");
        stringBuffer.append(this.actionName);
        return stringBuffer.toString();
    }
}

