/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.overlay.impl;

import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayEffect;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayType;
import com.mathworks.desktop.overlay.Painter;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.NativeEvent;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.event.EventUtils;
import com.mathworks.util.logger.Log;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class DefaultOverlayManager
implements Disposable,
OverlayManager {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.desktop.overlay.impl.DefaultOverlayManager");
    private static final Integer LAYER = JLayeredPane.DEFAULT_LAYER + 50;
    private static final Integer POPUP_LAYER = JLayeredPane.POPUP_LAYER;
    private boolean fHeavyWeightMode;
    private final Window fRootWindow;
    private final JLayeredPane fLayeredPane;
    private Point fRootLocationWhenPopupShown;
    private boolean fBlockDeactivationResponse;
    private List<Window> fToDisposeList = new ArrayList<Window>();
    private final Map<Component, OverlayItem> fComp2Overlay = new IdentityHashMap<Component, OverlayItem>();
    private final Map<Component, Component> fHWMap = new MapMaker().weakKeys().makeMap();
    private final List<OverlayItem> fPopupStack = new ArrayList<OverlayItem>();

    public static boolean isSupported(Window window) {
        return window instanceof RootPaneContainer;
    }

    @Inject
    public DefaultOverlayManager(Window window) {
        this.fRootWindow = window;
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Window must be a RootPaneContainer");
        }
        this.fLayeredPane = ((RootPaneContainer)((Object)window)).getLayeredPane();
        this.fLayeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DefaultOverlayManager.this.removePopups();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                DefaultOverlayManager.this.removePopups();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                DefaultOverlayManager.this.removePopups();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                DefaultOverlayManager.this.removePopups();
            }
        });
        this.fRootWindow.addComponentListener(new ComponentListener(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (!(PlatformInfo.isWindows() || PlatformInfo.isLinux() && DefaultOverlayManager.this.fRootWindow.getLocation().equals(DefaultOverlayManager.this.fRootLocationWhenPopupShown))) {
                    DefaultOverlayManager.this.removePopups();
                }
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DefaultOverlayManager.this.removePopups();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                DefaultOverlayManager.this.removePopups();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                DefaultOverlayManager.this.removePopups();
            }
        });
        this.fRootWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Disposer.dispose((Disposable)DefaultOverlayManager.this);
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                DefaultOverlayManager.this.removePopups(!PlatformInfo.isWindows());
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                DefaultOverlayManager.this.disposeWindows();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (!DefaultOverlayManager.focusFollowsMouse()) {
                    DefaultOverlayManager.this.removeSingleSelectPopups();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                if (DefaultOverlayManager.this.fBlockDeactivationResponse) {
                    DefaultOverlayManager.this.fBlockDeactivationResponse = false;
                } else {
                    DefaultOverlayManager.this.removeSingleSelectPopups();
                }
            }

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                DefaultOverlayManager.this.removeSingleSelectPopups();
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                DefaultOverlayManager.this.removeSingleSelectPopups();
            }
        });
        if (this.fRootWindow instanceof MJFrame) {
            ((MJFrame)this.fRootWindow).addNativeListener(new NativeEvent.Listener(){

                public void framePressed(NativeEvent nativeEvent) {
                    DefaultOverlayManager.this.removePopups(false);
                }

                public void frameReleased(NativeEvent nativeEvent) {
                    DefaultOverlayManager.this.disposeWindows();
                }
            });
        }
        EventUtils.addAWTEventListener((AWTEventListener)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                int n = aWTEvent.getID();
                switch (n) {
                    case 300: {
                        ContainerEvent containerEvent = (ContainerEvent)aWTEvent;
                        Component component = containerEvent.getChild();
                        Window window = SwingUtilities.getWindowAncestor(component);
                        if (window != DefaultOverlayManager.this.fRootWindow) break;
                        int n2 = DefaultOverlayManager.this.fHWMap.size();
                        DefaultOverlayManager.this.updateHeavyWeights(component, DefaultOverlayManager.this.fHWMap, true);
                        if (n2 != 0 || DefaultOverlayManager.this.fHWMap.size() <= 0) break;
                        DefaultOverlayManager.this.switchToHeavy(true);
                        break;
                    }
                    case 301: {
                        ContainerEvent containerEvent = (ContainerEvent)aWTEvent;
                        int n3 = DefaultOverlayManager.this.fHWMap.size();
                        DefaultOverlayManager.this.updateHeavyWeights(containerEvent.getChild(), DefaultOverlayManager.this.fHWMap, false);
                        if (n3 <= 0 || DefaultOverlayManager.this.fHWMap.size() != 0) break;
                        DefaultOverlayManager.this.switchToHeavy(false);
                        break;
                    }
                    case 501: {
                        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                        if (DefaultOverlayManager.this.isParentFor(mouseEvent.getComponent()) && !DefaultOverlayManager.this.isParentInstanceOf(mouseEvent.getComponent(), JPopupMenu.class)) {
                            Component component;
                            OverlayConstraints overlayConstraints;
                            OverlayItem overlayItem;
                            Point point = mouseEvent.getLocationOnScreen();
                            int n4 = DefaultOverlayManager.this.fPopupStack.size();
                            while (!(--n4 < 0 || (overlayItem = (OverlayItem)DefaultOverlayManager.this.fPopupStack.get(n4)).getBoundsOnScreen().contains(point) || (overlayConstraints = overlayItem.fConstraints) != null && overlayConstraints.isIgnoreMouseClicksOnAnchor() && (component = overlayConstraints.getAnchorComponent()) != null && DefaultOverlayManager.getBoundsOnScreen(component).contains(point))) {
                                DefaultOverlayManager.this.removeInternal(overlayItem);
                                if (overlayConstraints != null && overlayConstraints.getShouldConsumeDismissEvent() != null && !overlayConstraints.getShouldConsumeDismissEvent().accept((Object)mouseEvent)) continue;
                                mouseEvent.consume();
                            }
                        }
                        DefaultOverlayManager.this.fBlockDeactivationResponse = false;
                        break;
                    }
                    case 503: 
                    case 504: 
                    case 505: {
                        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                        boolean bl = false;
                        if (DefaultOverlayManager.focusFollowsMouse() && DefaultOverlayManager.this.fPopupStack.size() > 0 && DefaultOverlayManager.this.isParentFor(mouseEvent.getComponent()) && !DefaultOverlayManager.this.isParentInstanceOf(mouseEvent.getComponent(), JPopupMenu.class)) {
                            Point point = mouseEvent.getLocationOnScreen();
                            OverlayItem overlayItem = (OverlayItem)DefaultOverlayManager.this.fPopupStack.get(DefaultOverlayManager.this.fPopupStack.size() - 1);
                            bl = overlayItem.getBoundsOnScreen().contains(point);
                        }
                        DefaultOverlayManager.this.fBlockDeactivationResponse = bl;
                    }
                }
            }
        }, (long)(0x12L | (DefaultOverlayManager.focusFollowsMouse() ? 32L : 0L)), (Disposable)this);
        this.updateHeavyWeightsChildren(this.fRootWindow, this.fHWMap, true);
        if (this.fHWMap.size() > 0) {
            this.switchToHeavy(true);
        }
    }

    private boolean isParentFor(Component component) {
        while (component != null) {
            if (component == this.fRootWindow) {
                return true;
            }
            if (component instanceof ForeignOverlayWindow) break;
            component = component.getParent();
        }
        return false;
    }

    private boolean isParentInstanceOf(Component component, Class clazz) {
        while (component != null) {
            if (clazz.isAssignableFrom(component.getClass())) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    private void switchToHeavy(boolean bl) {
        LOG.debug("Switching to heavyweight mode = %s", new Object[]{bl});
        if (this.fHeavyWeightMode != bl) {
            this.fHeavyWeightMode = bl;
            for (OverlayItem overlayItem : this.getOverlays()) {
                overlayItem.setState(bl);
                overlayItem.layout(true);
            }
        }
    }

    private static boolean isLightweight(Component component) {
        return component instanceof JComponent || component instanceof CellRendererPane || component instanceof BasicSplitPaneDivider || component.getClass().getName().endsWith("MediumWeightComponent");
    }

    private void updateHeavyWeights(Component component, Map<Component, Component> map, boolean bl) {
        if (!DefaultOverlayManager.isLightweight(component)) {
            LOG.debug("Found heavyweight %s", new Object[]{component.getClass().getName()});
            if (bl) {
                map.put(component, component);
            } else {
                map.remove(component);
            }
        }
        if (component instanceof Container) {
            this.updateHeavyWeightsChildren((Container)component, map, bl);
        }
    }

    private void updateHeavyWeightsChildren(Container container, Map<Component, Component> map, boolean bl) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.updateHeavyWeights(container.getComponent(i), map, bl);
        }
    }

    @Override
    public Window getWindow() {
        return this.fRootWindow;
    }

    public void dispose() {
        for (OverlayItem overlayItem : this.getOverlays()) {
            this.removeInternal(overlayItem);
        }
    }

    private OverlayItem[] getOverlays() {
        Collection<OverlayItem> collection = this.fComp2Overlay.values();
        return collection.toArray(new OverlayItem[collection.size()]);
    }

    @Override
    public void addOverlay(Overlay overlay, OverlayEffect overlayEffect) {
        this.addItem(new OverlayItem(overlay, null, overlayEffect));
    }

    private void addItem(OverlayItem overlayItem) {
        overlayItem.layout(true);
        this.refresh();
    }

    @Override
    public Overlay addOverlay(Component component, final OverlayConstraints overlayConstraints, OverlayEffect overlayEffect) {
        Component component2 = component;
        if (overlayEffect != null) {
            component2 = overlayEffect.create(component);
        }
        final Component component3 = component2;
        final Component component4 = overlayConstraints.getAnchorComponent();
        final Overlay overlay = new Overlay(){

            @Override
            public Rectangle layout(Window window) {
                return overlayConstraints.getBounds(window);
            }

            @Override
            public Component getComponent() {
                return component3;
            }

            @Override
            public OverlayType getType() {
                return overlayConstraints.getType();
            }

            public void dispose() {
                DefaultOverlayManager.this.removeInternal(DefaultOverlayManager.this.getItem(this));
            }
        };
        final OverlayItem overlayItem = new OverlayItem(overlay, overlayConstraints, overlayEffect);
        final ComponentListener componentListener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                overlayItem.layout(true);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                overlayItem.layout(true);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                overlayItem.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                overlayItem.setVisible(false);
            }
        };
        final HierarchyListener hierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (SwingUtilities.getWindowAncestor(component4) == null) {
                    DefaultOverlayManager.this.removeOverlay(overlay);
                }
            }
        };
        component4.addComponentListener(componentListener);
        component4.addHierarchyListener(hierarchyListener);
        Disposer.register((Disposable)new Disposable(){

            public void dispose() {
                component4.removeComponentListener(componentListener);
                component4.removeHierarchyListener(hierarchyListener);
            }
        }, (Disposable)overlay);
        if (component instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)component), (Disposable)overlay);
        }
        this.addItem(overlayItem);
        if (overlayEffect != null) {
            overlayEffect.start(component3);
        }
        return overlay;
    }

    @Override
    public Overlay addOverlay(Painter<Component> painter, OverlayConstraints overlayConstraints, OverlayEffect overlayEffect) {
        PainterPanel painterPanel = new PainterPanel(painter, overlayConstraints.getAnchorComponent());
        return this.addOverlay(painterPanel, overlayConstraints, overlayEffect);
    }

    @Override
    public Overlay addOverlay(Component component, OverlayConstraints overlayConstraints) {
        return this.addOverlay(component, overlayConstraints, null);
    }

    @Override
    public Overlay addOverlay(Painter<Component> painter, OverlayConstraints overlayConstraints) {
        return this.addOverlay(painter, overlayConstraints, null);
    }

    @Override
    public void removeOverlay(Component component) {
        this.removeInternal(this.fComp2Overlay.get(component));
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        this.removeInternal(this.getItem(overlay));
    }

    @Override
    public void packOverlay(Component component) {
        OverlayItem overlayItem = this.getItem(component);
        if (overlayItem != null) {
            this.packInternal(overlayItem);
        }
    }

    @Override
    public void packOverlay(Overlay overlay) {
        this.packInternal(this.getItem(overlay));
    }

    @Override
    public void repaint(Overlay overlay) {
        overlay.getComponent().repaint();
    }

    private OverlayItem getItem(Component component) {
        while (component != null) {
            OverlayItem overlayItem = this.fComp2Overlay.get(component);
            if (overlayItem != null) {
                return overlayItem;
            }
            component = component.getParent();
        }
        return null;
    }

    private OverlayItem getItem(Overlay overlay) {
        return this.fComp2Overlay.get(overlay.getComponent());
    }

    private void removeInternal(OverlayItem overlayItem) {
        this.removeInternal(overlayItem, true);
    }

    private void removeInternal(OverlayItem overlayItem, boolean bl) {
        if (overlayItem != null) {
            overlayItem.dispose(bl);
            this.refresh();
        }
    }

    private void packInternal(OverlayItem overlayItem) {
        Dimension dimension = overlayItem.fOverlay.getComponent().getPreferredSize();
        Rectangle rectangle = overlayItem.fConstraints.getBounds(overlayItem.fOverlayWindow);
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        overlayItem.fConstraints.setBounds(rectangle);
        overlayItem.layout(true);
    }

    @Override
    public void removePopups() {
        this.removePopups(true);
    }

    public void removePopups(boolean bl) {
        OverlayItem[] overlayItemArray;
        for (OverlayItem overlayItem : overlayItemArray = this.fPopupStack.toArray(new OverlayItem[this.fPopupStack.size()])) {
            this.removeInternal(overlayItem, bl);
        }
    }

    @Override
    public void removeSingleSelectPopups() {
        this.removeSingleSelectPopups(true);
    }

    public void removeSingleSelectPopups(boolean bl) {
        OverlayItem[] overlayItemArray = this.fPopupStack.toArray(new OverlayItem[this.fPopupStack.size()]);
        for (int i = overlayItemArray.length - 1; i >= 0; --i) {
            OverlayItem overlayItem = overlayItemArray[i];
            if (overlayItem.fConstraints != null && overlayItem.fConstraints.allowMultiSelect()) break;
            this.removeInternal(overlayItem, bl);
        }
    }

    @Override
    public boolean isPopupShowing() {
        return !this.fPopupStack.isEmpty();
    }

    private void refresh() {
        this.fRootWindow.invalidate();
        this.fRootWindow.repaint();
    }

    private static Rectangle getBoundsOnScreen(Component component) {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, component);
        return new Rectangle(point.x, point.y, component.getWidth(), component.getHeight());
    }

    private void disposeWindows() {
        for (Window window : this.fToDisposeList) {
            window.dispose();
        }
        this.fToDisposeList.clear();
    }

    private static boolean focusFollowsMouse() {
        return PlatformInfo.isLinux();
    }

    private class OverlayItem {
        Overlay fOverlay;
        OverlayEffect fEffect;
        boolean fHeavyWeight;
        Window fOverlayWindow;
        OverlayConstraints fConstraints;
        Component fReturnFocusTo;

        private OverlayItem(Overlay overlay, OverlayConstraints overlayConstraints, OverlayEffect overlayEffect) {
            this.fOverlay = overlay;
            this.fEffect = overlayEffect;
            this.fConstraints = overlayConstraints;
            DefaultOverlayManager.this.fComp2Overlay.put(overlay.getComponent(), this);
            if (this.isPopup()) {
                DefaultOverlayManager.this.fPopupStack.add(this);
                DefaultOverlayManager.this.fRootLocationWhenPopupShown = DefaultOverlayManager.this.fRootWindow.getLocation();
            }
            this.setState(DefaultOverlayManager.this.fHeavyWeightMode);
        }

        private boolean isPopup() {
            return this.fOverlay.getType().isPopup();
        }

        void toHeavyWeight() {
            this.setState(true);
        }

        void toLightWeight() {
            this.setState(false);
        }

        void setState(boolean bl) {
            int n;
            Overlay.Mode mode = this.fOverlay.getType().getMode();
            this.fHeavyWeight = mode == Overlay.Mode.HEAVY_WEIGHT || mode == Overlay.Mode.AUTO && bl;
            OverlayItem overlayItem = null;
            if (this.isPopup() && (n = DefaultOverlayManager.this.fPopupStack.indexOf(this)) > 0) {
                overlayItem = (OverlayItem)DefaultOverlayManager.this.fPopupStack.get(n - 1);
            }
            if (this.fHeavyWeight) {
                if (this.fOverlayWindow == null) {
                    Window window;
                    Window window2 = window = overlayItem == null || overlayItem.fOverlayWindow == null ? DefaultOverlayManager.this.fRootWindow : overlayItem.fOverlayWindow;
                    if (this.fConstraints != null && this.fConstraints.allowMultiSelect() && PlatformInfo.isLinux()) {
                        if (window != DefaultOverlayManager.this.fRootWindow) {
                            window.setVisible(false);
                        }
                        this.fOverlayWindow = new JDialog(DefaultOverlayManager.this.fRootWindow);
                        ((JDialog)this.fOverlayWindow).setUndecorated(true);
                    } else {
                        this.fOverlayWindow = new JWindow(window);
                    }
                    JRootPane jRootPane = ((RootPaneContainer)((Object)this.fOverlayWindow)).getRootPane();
                    jRootPane.putClientProperty("Window.shadow", Boolean.FALSE);
                    if (this.fOverlay.getComponent().isFocusable()) {
                        this.fOverlayWindow.setFocusableWindowState(true);
                    } else {
                        this.fOverlayWindow.setFocusableWindowState(false);
                    }
                } else {
                    ((RootPaneContainer)((Object)this.fOverlayWindow)).getContentPane().removeAll();
                }
                ((RootPaneContainer)((Object)this.fOverlayWindow)).getContentPane().add(this.fOverlay.getComponent());
            } else {
                if (this.fOverlayWindow != null) {
                    Window window = this.fOverlayWindow;
                    this.fOverlayWindow = null;
                    window.dispose();
                }
                DefaultOverlayManager.this.fLayeredPane.remove(this.fOverlay.getComponent());
                Integer n2 = this.isPopup() ? Integer.valueOf(POPUP_LAYER + this.fOverlay.getType().getLayer() + (overlayItem == null ? 0 : overlayItem.fOverlay.getType().getLayer() + 1)) : Integer.valueOf(LAYER + this.fOverlay.getType().getLayer());
                DefaultOverlayManager.this.fLayeredPane.add(this.fOverlay.getComponent(), n2);
            }
        }

        void layout(boolean bl) {
            Rectangle rectangle = this.fOverlay.layout(DefaultOverlayManager.this.fRootWindow);
            Rectangle rectangle2 = SwingUtilities.convertRectangle(DefaultOverlayManager.this.fRootWindow, rectangle, DefaultOverlayManager.this.fLayeredPane);
            if (this.fOverlay.getType().getMode() == Overlay.Mode.AUTO) {
                if (rectangle2.x < 0 || rectangle2.y < 0 || rectangle2.x + rectangle2.width > DefaultOverlayManager.this.fLayeredPane.getWidth() || rectangle2.y + rectangle2.height > DefaultOverlayManager.this.fLayeredPane.getHeight()) {
                    if (!this.fHeavyWeight && bl) {
                        this.toHeavyWeight();
                    }
                } else if (this.fHeavyWeight && !DefaultOverlayManager.this.fHeavyWeightMode) {
                    this.toLightWeight();
                }
            }
            Component component = this.fOverlay.getComponent();
            if (this.fHeavyWeight) {
                component.setBounds(0, 0, rectangle.width, rectangle.height);
                Point point = DefaultOverlayManager.this.fRootWindow.getLocation();
                rectangle.x += point.x;
                rectangle.y += point.y;
                this.fOverlayWindow.setBounds(rectangle);
                this.fOverlayWindow.setVisible(true);
                if (PlatformInfo.isLinux() && DefaultOverlayManager.this.fPopupStack.size() == 1) {
                    this.fReturnFocusTo = DefaultOverlayManager.this.fRootWindow.getFocusOwner();
                }
            } else {
                component.setBounds(rectangle2);
                if (DefaultOverlayManager.this.fPopupStack.size() == 1) {
                    this.fReturnFocusTo = DefaultOverlayManager.this.fRootWindow.getFocusOwner();
                }
            }
            if (component instanceof JComponent) {
                ((JComponent)component).revalidate();
            } else {
                component.invalidate();
            }
            component.repaint();
        }

        public void setVisible(boolean bl) {
            if (this.fHeavyWeight) {
                this.fOverlayWindow.setVisible(bl);
            } else {
                this.fOverlay.getComponent().setVisible(bl);
            }
        }

        public void dispose(boolean bl) {
            Window window;
            if (this.isPopup()) {
                int n = DefaultOverlayManager.this.fPopupStack.indexOf(this);
                if (n < DefaultOverlayManager.this.fPopupStack.size() - 1) {
                    DefaultOverlayManager.this.removeInternal((OverlayItem)DefaultOverlayManager.this.fPopupStack.get(n + 1), bl);
                }
                DefaultOverlayManager.this.fPopupStack.remove(this);
            }
            DefaultOverlayManager.this.fComp2Overlay.remove(this.fOverlay.getComponent());
            if (this.fEffect != null) {
                this.fEffect.stop(this.fOverlay.getComponent());
            }
            if ((window = this.fOverlayWindow) != null) {
                this.fOverlayWindow = null;
                if (bl) {
                    window.dispose();
                } else {
                    if (window.getParent() == DefaultOverlayManager.this.fRootWindow && window.getOwnedWindows().length == 0) {
                        DefaultOverlayManager.this.fToDisposeList.add(window);
                    } else {
                        window.removeAll();
                    }
                    window.setVisible(false);
                }
            }
            if (!this.fHeavyWeight) {
                DefaultOverlayManager.this.fLayeredPane.remove(this.fOverlay.getComponent());
            }
            if (this.fReturnFocusTo != null) {
                if (PlatformInfo.isLinux()) {
                    this.fReturnFocusTo.requestFocus();
                } else {
                    this.fReturnFocusTo.requestFocusInWindow();
                }
            }
            Disposer.dispose((Disposable)this.fOverlay);
        }

        public Rectangle getBoundsOnScreen() {
            return DefaultOverlayManager.getBoundsOnScreen(this.fOverlay.getComponent());
        }
    }

    public static class PainterPanel
    extends JPanel {
        private final Painter<Component> fPainter;
        private final Component fAnchor;

        public PainterPanel(Painter<Component> painter, Component component) {
            this.fPainter = painter;
            this.fAnchor = component;
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            this.fPainter.paint(graphics2D, this.fAnchor, dimension.width, dimension.height);
            graphics2D.dispose();
        }
    }

    public static class ForeignOverlayWindow
    extends Window {
        public ForeignOverlayWindow(Window window) {
            super(window);
        }
    }
}

