/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.timer;

import com.mathworks.timer.MWCallback;
import com.mathworks.timer.TimerTask;
import java.util.Date;
import java.util.Vector;

public class MWCallbackScheduler
implements Runnable {
    Thread scheduleThread = null;
    private boolean schedulerActive = true;
    Vector callbackList = new Vector();
    private static MWCallbackScheduler scheduler = null;
    static int references = 0;

    public MWCallbackScheduler() {
        this.scheduleThread = new Thread(this);
        this.scheduleThread.start();
    }

    public void dispose() {
        this.schedulerActive = false;
        this.scheduleThread.interrupt();
    }

    public static MWCallbackScheduler getScheduler() {
        if (scheduler == null) {
            scheduler = new MWCallbackScheduler();
        }
        ++references;
        return scheduler;
    }

    public static void releaseScheduler() {
        if (references > 0) {
            --references;
        }
        if (references == 0 && scheduler != null) {
            scheduler.removeAll();
            scheduler.dispose();
            scheduler = null;
        }
    }

    public void schedule(TimerTask timerTask, MWCallback mWCallback, Date date) {
        this.schedule(new ScheduledTask(timerTask, mWCallback, date, 0L, false));
    }

    public void schedule(TimerTask timerTask, MWCallback mWCallback, long l) {
        Date date = new Date();
        date.setTime(date.getTime() + l);
        this.schedule(new ScheduledTask(timerTask, mWCallback, date, 0L, false));
    }

    public void schedule(TimerTask timerTask, MWCallback mWCallback, long l, long l2) {
        Date date = new Date();
        date.setTime(date.getTime() + l);
        this.schedule(new ScheduledTask(timerTask, mWCallback, date, l2, true));
    }

    public void schedule(TimerTask timerTask, MWCallback mWCallback, Date date, long l) {
        this.schedule(new ScheduledTask(timerTask, mWCallback, date, l, true));
    }

    private synchronized void schedule(ScheduledTask scheduledTask) {
        this.callbackList.add(scheduledTask);
        this.scheduleThread.interrupt();
    }

    private synchronized long checkSchedule() {
        long l = Long.MAX_VALUE;
        for (int i = 0; i < this.callbackList.size(); ++i) {
            Date date = new Date();
            ScheduledTask scheduledTask = this.getScheduledTask(i);
            if (scheduledTask == null) continue;
            if (!date.before(scheduledTask.getTime())) {
                scheduledTask.getTimerClass().asyncExecute(scheduledTask.timer);
                if (scheduledTask.getRepeat()) {
                    scheduledTask.getTime().setTime(scheduledTask.getTime().getTime() + scheduledTask.getPeriod());
                } else {
                    this.callbackList.remove(scheduledTask);
                }
                --i;
                continue;
            }
            if (l <= scheduledTask.getTime().getTime()) continue;
            l = scheduledTask.getTime().getTime();
        }
        return l;
    }

    private ScheduledTask getScheduledTask(int n) {
        if (this.callbackList.size() > n) {
            return (ScheduledTask)this.callbackList.elementAt(n);
        }
        return null;
    }

    public synchronized void removeCallback(MWCallback mWCallback) {
        for (int i = 0; i < this.callbackList.size(); ++i) {
            ScheduledTask scheduledTask = this.getScheduledTask(i);
            if (scheduledTask.getTimerClass() != mWCallback) continue;
            this.callbackList.remove(i);
            --i;
        }
    }

    private synchronized void removeAll() {
        this.callbackList.clear();
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(10);
        while (this.schedulerActive) {
            long l = this.checkSchedule();
            long l2 = l - System.currentTimeMillis();
            if (l2 <= 0L) continue;
            try {
                if (l2 > 1000000L) {
                    l2 = 1000L;
                }
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public class ScheduledTask {
        private MWCallback _callback;
        private Date _nextRunTime;
        private long _period;
        private boolean _repeat;
        public TimerTask timer;

        ScheduledTask(TimerTask timerTask, MWCallback mWCallback, Date date, long l, boolean bl) {
            this._callback = mWCallback;
            this._nextRunTime = date;
            this._period = l;
            this._repeat = bl;
            this.timer = timerTask;
        }

        public Date getTime() {
            return this._nextRunTime;
        }

        public void setTime(Date date) {
            this._nextRunTime = date;
        }

        public boolean getRepeat() {
            return this._repeat;
        }

        public long getPeriod() {
            return this._period;
        }

        public MWCallback getTimerClass() {
            return this._callback;
        }
    }
}

