/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import [Lnet.jini.id.Uuid;;
import com.sun.jini.landlord.ConstrainableLandlordLeaseMap;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

public final class ConstrainableLandlordLease
extends LandlordLease
implements RemoteMethodControl {
    static final long serialVersionUID = 1L;
    private static final Method renewMethod = ConstrainableLandlordLease.getMethod(Lease.class, "renew", new Class[]{Long.TYPE});
    private static final Method cancelMethod = ConstrainableLandlordLease.getMethod(Lease.class, "cancel", new Class[0]);
    private static final Method renewAllMethod = ConstrainableLandlordLease.getMethod(Landlord.class, "renewAll", new Class[]{Uuid;.class, [J.class});
    private static final Method cancelAllMethod = ConstrainableLandlordLease.getMethod(Landlord.class, "cancelAll", new Class[]{Uuid;.class});
    private static final Method[] methodMapArray = new Method[]{renewMethod, ConstrainableLandlordLease.getMethod(Landlord.class, "renew", new Class[]{Uuid.class, Long.TYPE}), cancelMethod, ConstrainableLandlordLease.getMethod(Landlord.class, "cancel", new Class[]{Uuid.class})};
    static final Method[] leaseMapMethodMapArray = new Method[]{renewMethod, renewAllMethod, cancelMethod, cancelAllMethod};
    private static final Method[] comparableMethodsMapArray = new Method[]{renewMethod, renewMethod, cancelMethod, cancelMethod};
    private final MethodConstraints methodConstraints;

    private static Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (Error)new NoSuchMethodError(noSuchMethodException.getMessage()).initCause(noSuchMethodException);
        }
    }

    public ConstrainableLandlordLease(Uuid uuid, Landlord landlord, Uuid uuid2, long l, MethodConstraints methodConstraints) {
        super(uuid, ConstrainableLandlordLease.constrainServer(landlord, methodConstraints, methodMapArray), uuid2, l);
        this.methodConstraints = methodConstraints;
    }

    private static Landlord constrainServer(Landlord landlord, MethodConstraints methodConstraints, Method[] methodArray) {
        MethodConstraints methodConstraints2 = ConstrainableProxyUtil.translateConstraints(methodConstraints, methodArray);
        RemoteMethodControl remoteMethodControl = ((RemoteMethodControl)landlord).setConstraints(methodConstraints2);
        return (Landlord)remoteMethodControl;
    }

    public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
        return new ConstrainableLandlordLease(this.cookie(), this.landlord(), this.landlordUuid(), this.expiration, methodConstraints);
    }

    public MethodConstraints getConstraints() {
        return this.methodConstraints;
    }

    private ProxyTrustIterator getProxyTrustIterator() {
        return new SingletonProxyTrustIterator((Object)this.landlord());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.landlord(), methodMapArray);
    }

    public boolean canBatch(Lease lease) {
        if (!super.canBatch(lease)) {
            return false;
        }
        if (!(lease instanceof ConstrainableLandlordLease)) {
            return false;
        }
        MethodConstraints methodConstraints = ((ConstrainableLandlordLease)lease).methodConstraints;
        return ConstrainableProxyUtil.equivalentConstraints(this.methodConstraints, methodConstraints, comparableMethodsMapArray);
    }

    public LeaseMap createLeaseMap(long l) {
        return new ConstrainableLandlordLeaseMap(ConstrainableLandlordLease.constrainServer(this.landlord(), this.methodConstraints, leaseMapMethodMapArray), this.landlordUuid(), this, l);
    }
}

