/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import com.intel.bluetooth.Utils;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.UUID;

public class DataElement {
    public static final int NULL = 0;
    public static final int U_INT_1 = 8;
    public static final int U_INT_2 = 9;
    public static final int U_INT_4 = 10;
    public static final int U_INT_8 = 11;
    public static final int U_INT_16 = 12;
    public static final int INT_1 = 16;
    public static final int INT_2 = 17;
    public static final int INT_4 = 18;
    public static final int INT_8 = 19;
    public static final int INT_16 = 20;
    public static final int URL = 64;
    public static final int UUID = 24;
    public static final int BOOL = 40;
    public static final int STRING = 32;
    public static final int DATSEQ = 48;
    public static final int DATALT = 56;
    private Object value;
    private int valueType;

    public DataElement(int valueType) {
        switch (valueType) {
            case 0: {
                this.value = null;
                break;
            }
            case 48: 
            case 56: {
                this.value = new Vector();
                break;
            }
            default: {
                throw new IllegalArgumentException("valueType " + DataElement.typeToString(valueType) + " is not DATSEQ, DATALT or NULL");
            }
        }
        this.valueType = valueType;
    }

    public DataElement(boolean bool) {
        this.value = bool ? Boolean.TRUE : Boolean.FALSE;
        this.valueType = 40;
    }

    public DataElement(int valueType, long value) {
        switch (valueType) {
            case 8: {
                if (value >= 0L && value <= 255L) break;
                throw new IllegalArgumentException(value + " not U_INT_1");
            }
            case 9: {
                if (value >= 0L && value <= 65535L) break;
                throw new IllegalArgumentException(value + " not U_INT_2");
            }
            case 10: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException(value + " not U_INT_4");
            }
            case 16: {
                if (value >= -128L && value <= 127L) break;
                throw new IllegalArgumentException(value + " not INT_1");
            }
            case 17: {
                if (value >= -32768L && value <= 32767L) break;
                throw new IllegalArgumentException(value + " not INT_2");
            }
            case 18: {
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException(value + " not INT_4");
            }
            case 19: {
                break;
            }
            default: {
                throw new IllegalArgumentException("type " + DataElement.typeToString(valueType) + " can't be represented long");
            }
        }
        this.value = new Long(value);
        this.valueType = valueType;
    }

    public DataElement(int valueType, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value param is null");
        }
        switch (valueType) {
            case 32: 
            case 64: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("value param should be String");
            }
            case 24: {
                if (value instanceof UUID) break;
                throw new IllegalArgumentException("value param should be UUID");
            }
            case 11: {
                if (value instanceof byte[] && ((byte[])value).length == 8) break;
                throw new IllegalArgumentException("value param should be byte[8]");
            }
            case 12: 
            case 20: {
                if (value instanceof byte[] && ((byte[])value).length == 16) break;
                throw new IllegalArgumentException("value param should be byte[16]");
            }
            default: {
                throw new IllegalArgumentException("type " + DataElement.typeToString(valueType) + " can't be represented by Object");
            }
        }
        this.value = value;
        this.valueType = valueType;
    }

    public void addElement(DataElement elem) {
        if (elem == null) {
            throw new NullPointerException("elem param is null");
        }
        switch (this.valueType) {
            case 48: 
            case 56: {
                ((Vector)this.value).addElement(elem);
                break;
            }
            default: {
                throw new ClassCastException("DataType is not DATSEQ or DATALT");
            }
        }
    }

    public void insertElementAt(DataElement elem, int index) {
        if (elem == null) {
            throw new NullPointerException("elem param is null");
        }
        switch (this.valueType) {
            case 48: 
            case 56: {
                ((Vector)this.value).insertElementAt(elem, index);
                break;
            }
            default: {
                throw new ClassCastException("DataType is not DATSEQ or DATALT");
            }
        }
    }

    public int getSize() {
        switch (this.valueType) {
            case 48: 
            case 56: {
                return ((Vector)this.value).size();
            }
        }
        throw new ClassCastException("DataType is not DATSEQ or DATALT");
    }

    public boolean removeElement(DataElement elem) {
        if (elem == null) {
            throw new NullPointerException("elem param is null");
        }
        switch (this.valueType) {
            case 48: 
            case 56: {
                return ((Vector)this.value).removeElement(elem);
            }
        }
        throw new ClassCastException("DataType is not DATSEQ or DATALT");
    }

    public int getDataType() {
        return this.valueType;
    }

    public long getLong() {
        switch (this.valueType) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return (Long)this.value;
            }
        }
        throw new ClassCastException("DataType is not INT");
    }

    public boolean getBoolean() {
        if (this.valueType == 40) {
            return (Boolean)this.value;
        }
        throw new ClassCastException("DataType is not BOOL");
    }

    public Object getValue() {
        switch (this.valueType) {
            case 24: 
            case 32: 
            case 64: {
                return this.value;
            }
            case 11: 
            case 12: 
            case 20: {
                return Utils.clone((byte[])this.value);
            }
            case 48: 
            case 56: {
                return ((Vector)this.value).elements();
            }
        }
        throw new ClassCastException("DataType is simple java type");
    }

    private static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 8: {
                return "U_INT_1";
            }
            case 9: {
                return "U_INT_2";
            }
            case 10: {
                return "U_INT_4";
            }
            case 11: {
                return "U_INT_8";
            }
            case 12: {
                return "U_INT_16";
            }
            case 16: {
                return "INT_1";
            }
            case 17: {
                return "INT_2";
            }
            case 18: {
                return "INT_4";
            }
            case 19: {
                return "INT_8";
            }
            case 20: {
                return "INT_16";
            }
            case 64: {
                return "URL";
            }
            case 32: {
                return "STRING";
            }
            case 24: {
                return "UUID";
            }
            case 48: {
                return "DATSEQ";
            }
            case 40: {
                return "BOOL";
            }
            case 56: {
                return "DATALT";
            }
        }
        return "Unknown" + type;
    }

    public String toString() {
        switch (this.valueType) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return DataElement.typeToString(this.valueType) + " 0x" + Utils.toHexString((Long)this.value);
            }
            case 24: 
            case 32: 
            case 40: 
            case 64: {
                return DataElement.typeToString(this.valueType) + " " + this.value.toString();
            }
            case 11: 
            case 12: 
            case 20: {
                byte[] b = (byte[])this.value;
                StringBuffer buf = new StringBuffer();
                buf.append(DataElement.typeToString(this.valueType)).append(" ");
                for (int i = 0; i < b.length; ++i) {
                    buf.append(Integer.toHexString(b[i] >> 4 & 0xF));
                    buf.append(Integer.toHexString(b[i] & 0xF));
                }
                return buf.toString();
            }
            case 48: {
                StringBuffer buf = new StringBuffer("DATSEQ {\n");
                Enumeration e = ((Vector)this.value).elements();
                while (e.hasMoreElements()) {
                    buf.append(e.nextElement());
                    buf.append("\n");
                }
                buf.append("}");
                return buf.toString();
            }
            case 56: {
                StringBuffer buf = new StringBuffer("DATALT {\n");
                Enumeration e = ((Vector)this.value).elements();
                while (e.hasMoreElements()) {
                    buf.append(e.nextElement());
                    buf.append("\n");
                }
                buf.append("}");
                return buf.toString();
            }
        }
        return "Unknown" + this.valueType;
    }
}

