/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierBase;
import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConsts;
import com.intel.bluetooth.BluetoothRFCommServerConnection;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

class BluetoothRFCommConnectionNotifier
extends BluetoothConnectionNotifierBase
implements StreamConnectionNotifier {
    private int rfcommChannel = -1;

    public BluetoothRFCommConnectionNotifier(BluetoothStack bluetoothStack, BluetoothConnectionNotifierParams params) throws IOException {
        super(bluetoothStack, params);
        this.handle = bluetoothStack.rfServerOpen(params, this.serviceRecord);
        this.rfcommChannel = this.serviceRecord.getChannel(BluetoothConsts.RFCOMM_PROTOCOL_UUID);
        this.serviceRecord.attributeUpdated = false;
        this.securityOpt = Utils.securityOpt(params.authenticate, params.encrypt);
        this.connectionCreated();
    }

    protected void stackServerClose(long handle) throws IOException {
        this.bluetoothStack.rfServerClose(handle, this.serviceRecord);
    }

    public StreamConnection acceptAndOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Notifier is closed");
        }
        this.updateServiceRecord(true);
        try {
            long clientHandle = this.bluetoothStack.rfServerAcceptAndOpenRfServerConnection(this.handle);
            int clientSecurityOpt = this.bluetoothStack.rfGetSecurityOpt(clientHandle, this.securityOpt);
            return new BluetoothRFCommServerConnection(this.bluetoothStack, clientHandle, clientSecurityOpt);
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            if (this.closed) {
                throw new InterruptedIOException("Notifier has been closed; " + e.getMessage());
            }
            throw e;
        }
    }

    protected void validateServiceRecord(ServiceRecord srvRecord) {
        if (this.rfcommChannel != this.serviceRecord.getChannel(BluetoothConsts.RFCOMM_PROTOCOL_UUID)) {
            throw new IllegalArgumentException("Must not change the RFCOMM server channel number");
        }
        super.validateServiceRecord(srvRecord);
    }

    protected void updateStackServiceRecord(ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.bluetoothStack.rfServerUpdateServiceRecord(this.handle, serviceRecord, acceptAndOpen);
    }
}

