/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.collection.WeakTable;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.mahalo.LeaseManager;
import com.sun.jini.thread.WakeupManager;
import java.lang.ref.WeakReference;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.Uuid;

class LeaseExpirationMgr
implements LeaseManager,
WeakTable.KeyGCHandler {
    private WeakTable ticketMap = new WeakTable(this);
    private Expirer landlord;
    private WakeupManager expirationQueue = new WakeupManager(new WakeupManager.ThreadDesc(null, true));

    LeaseExpirationMgr(Expirer expirer) {
        this.landlord = expirer;
    }

    void terminate() {
        this.expirationQueue.stop();
        this.expirationQueue.cancelAll();
    }

    public void register(LeasedResource leasedResource) {
        this.schedule(leasedResource);
    }

    public void renewed(LeasedResource leasedResource) {
        this.expirationQueue.cancel((WakeupManager.Ticket)this.ticketMap.remove(leasedResource));
        this.schedule(leasedResource);
    }

    private void schedule(LeasedResource leasedResource) {
        WakeupManager.Ticket ticket = this.expirationQueue.schedule(leasedResource.getExpiration(), new Canceler(leasedResource));
        this.ticketMap.getOrAdd(leasedResource, ticket);
    }

    public void keyGC(Object object) {
        WakeupManager.Ticket ticket = (WakeupManager.Ticket)object;
        this.expirationQueue.cancel(ticket);
    }

    private class Canceler
    implements Runnable {
        private final WeakReference resourceRef;

        Canceler(LeasedResource leasedResource) {
            this.resourceRef = new WeakReference<LeasedResource>(leasedResource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeasedResource leasedResource = (LeasedResource)this.resourceRef.get();
            if (leasedResource == null) {
                return;
            }
            LeasedResource leasedResource2 = leasedResource;
            synchronized (leasedResource2) {
                if (leasedResource.getExpiration() <= System.currentTimeMillis()) {
                    try {
                        LeaseExpirationMgr.this.ticketMap.remove(leasedResource);
                        LeaseExpirationMgr.this.landlord.cancel(leasedResource.getCookie());
                    }
                    catch (UnknownLeaseException unknownLeaseException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static interface Expirer {
        public void cancel(Uuid var1) throws UnknownLeaseException;
    }
}

