/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import [Ljava.lang.String;;
import [Lnet.jini.core.discovery.LookupLocator;;
import [Lnet.jini.core.entry.Entry;;
import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.id.Uuid;
import net.jini.lookup.JoinManager;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

class JoinStateManager
extends LogHandler {
    private static final Logger initlogger = TxnManagerImpl.initLogger;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;
    private ProxyPreparer lookupLocatorPreparer;
    private DiscoveryManagement dm;
    private JoinManager mgr;
    private ReliableLog log;
    private Entry[] attributes;
    private LookupLocator[] locators;
    private String[] groups;
    private Uuid serviceUuid;
    private boolean initial = true;

    JoinStateManager(String string) throws IOException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "JoinStateManager", string);
        }
        ReliableLog reliableLog = this.log = string == null ? null : new ReliableLog(string, this);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "JoinStateManager");
        }
    }

    void recover() throws IOException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "recover");
        }
        if (this.log != null) {
            this.log.recover();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "recover");
        }
    }

    void startManager(Configuration configuration, Object object, ServiceID serviceID, Entry[] entryArray) throws IOException, ConfigurationException {
        Entry[] entryArray2;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "startManager", new Object[]{configuration, object, serviceID, Arrays.asList(entryArray)});
        }
        if (serviceID == null || this.serviceUuid == null) {
            throw new AssertionError((Object)"serviceID and serviceUuid must be set");
        }
        BasicProxyPreparer basicProxyPreparer = new BasicProxyPreparer();
        this.lookupLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "lookupLocatorPreparer", ProxyPreparer.class, basicProxyPreparer);
        if (initlogger.isLoggable(Level.CONFIG)) {
            initlogger.log(Level.CONFIG, "lookupLocatorPreparer: {0}", this.lookupLocatorPreparer);
        }
        this.dm = (DiscoveryManagement)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "discoveryManager", DiscoveryManagement.class, new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, null, null, configuration));
        if (initlogger.isLoggable(Level.CONFIG)) {
            initlogger.log(Level.CONFIG, "discoveryManager: {0}", this.dm);
        }
        if (this.dm instanceof DiscoveryGroupManagement) {
            entryArray2 = ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
            if (entryArray2 == DiscoveryGroupManagement.ALL_GROUPS || entryArray2.length != 0) {
                throw new ConfigurationException("discoveryManager entry must be configured to initially discover/join NO_GROUPS");
            }
        } else {
            throw new ConfigurationException("Entry for component com.sun.jini.mahalo, name discoveryManager must implement net.jini.discovery.DiscoveryGroupManagement");
        }
        if (this.dm instanceof DiscoveryLocatorManagement) {
            entryArray2 = ((DiscoveryLocatorManagement)((Object)this.dm)).getLocators();
            if (entryArray2 != null && entryArray2.length != 0) {
                throw new ConfigurationException("discoveryManager entry must be initiallyconfigured with no locators");
            }
        } else {
            throw new ConfigurationException("Entry for component com.sun.jini.mahalo, name discoveryManager must implement net.jini.discovery.DiscoveryLocatorManagement");
        }
        if (this.initial) {
            if (initlogger.isLoggable(Level.FINEST)) {
                initlogger.log(Level.FINEST, "Obtaining initial values");
            }
            this.groups = (String[])configuration.getEntry("com.sun.jini.mahalo", "initialLookupGroups", String;.class, (Object)new String[]{""});
            if (initlogger.isLoggable(Level.CONFIG)) {
                initlogger.log(Level.CONFIG, "Obtaining initial groups: {0}", this.groups == null ? Arrays.asList("<ALL_GROUPS>") : Arrays.asList(this.groups));
            }
            this.locators = (LookupLocator[])Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "initialLookupLocators", LookupLocator;.class, new LookupLocator[0]);
            if (initlogger.isLoggable(Level.CONFIG)) {
                initlogger.log(Level.CONFIG, "Obtaining initial locators: {0}", Arrays.asList(this.locators));
            }
            entryArray2 = (Entry[])Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "initialLookupAttributes", Entry;.class, new Entry[0]);
            if (initlogger.isLoggable(Level.CONFIG)) {
                initlogger.log(Level.CONFIG, "Obtaining initial attributes: {0}", Arrays.asList(entryArray2));
            }
            if (entryArray2.length == 0) {
                this.attributes = entryArray;
            } else {
                this.attributes = new Entry[entryArray2.length + entryArray.length];
                System.arraycopy(entryArray, 0, this.attributes, 0, entryArray.length);
                System.arraycopy(entryArray2, 0, this.attributes, entryArray.length, entryArray2.length);
            }
            if (initlogger.isLoggable(Level.FINEST)) {
                initlogger.log(Level.FINEST, "Combined attributes: {0}", Arrays.asList(this.attributes));
            }
        } else {
            if (initlogger.isLoggable(Level.FINEST)) {
                initlogger.log(Level.FINEST, "Recovered locators: {0}", Arrays.asList(this.locators));
            }
            if (this.locators.length > 0) {
                entryArray2 = (Entry[])Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "recoveredLookupLocatorPreparer", ProxyPreparer.class, basicProxyPreparer);
                if (initlogger.isLoggable(Level.CONFIG)) {
                    initlogger.log(Level.CONFIG, "recoveredLookupLocatorPreparer: {0}", (Object)entryArray2);
                }
                LinkedList<Object> linkedList = new LinkedList<Object>();
                for (int i = 0; i < this.locators.length; ++i) {
                    try {
                        linkedList.add(entryArray2.prepareProxy((Object)this.locators[i]));
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (initlogger.isLoggable(Levels.HANDLED)) {
                            initlogger.log(Levels.HANDLED, "Exception re-preparing LookupLocator: {0}. Dropping locator.", this.locators[i]);
                        }
                        if (!initlogger.isLoggable(Levels.HANDLED)) continue;
                        initlogger.log(Levels.HANDLED, "Preparer exception: ", throwable);
                    }
                }
                this.locators = linkedList.toArray(new LookupLocator[0]);
            }
        }
        if (initlogger.isLoggable(Level.FINEST)) {
            initlogger.log(Level.FINEST, "Setting groups and locators");
        }
        ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(this.groups);
        ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(this.locators);
        if (initlogger.isLoggable(Level.FINEST)) {
            initlogger.log(Level.FINEST, "Creating JoinManager");
        }
        this.mgr = new JoinManager(object, this.attributes, serviceID, this.dm, null, configuration);
        this.attributes = null;
        this.groups = null;
        this.locators = null;
        if (initlogger.isLoggable(Level.FINEST)) {
            initlogger.log(Level.FINEST, "Taking snapshot");
        }
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "startManager");
        }
    }

    public void setServiceUuid(Uuid uuid) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "setServiceUuid", uuid);
        }
        if (uuid == null) {
            throw new NullPointerException("serviceUuid can't be null");
        }
        this.serviceUuid = uuid;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "setServiceUuid");
        }
    }

    public Uuid getServiceUuid() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getServiceUuid");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getServiceUuid", this.serviceUuid);
        }
        return this.serviceUuid;
    }

    public void stop() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "stop");
        }
        if (this.mgr != null) {
            this.mgr.terminate();
        }
        if (this.dm != null) {
            this.dm.terminate();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "stop");
        }
    }

    public void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "destroy");
        }
        this.stop();
        if (this.log != null) {
            this.log.deletePersistentStore();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "destroy");
        }
    }

    public Entry[] getLookupAttributes() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getLookupAttributes");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getLookupAttributes");
        }
        return this.mgr.getAttributes();
    }

    public void addLookupAttributes(Entry[] entryArray) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "addLookupAttributes");
        }
        this.mgr.addAttributes(entryArray, true);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "addLookupAttributes");
        }
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "modifyLookupAttributes");
        }
        this.mgr.modifyAttributes(entryArray, entryArray2, true);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "modifyLookupAttributes");
        }
    }

    public String[] getLookupGroups() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getLookupGroups");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getLookupGroups");
        }
        return ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
    }

    public void addLookupGroups(String[] stringArray) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "addLookupGroups");
        }
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).addGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not change groups");
        }
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "addLookupGroups");
        }
    }

    public void removeLookupGroups(String[] stringArray) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "removeLookupGroups");
        }
        ((DiscoveryGroupManagement)((Object)this.dm)).removeGroups(stringArray);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "removeLookupGroups");
        }
    }

    public void setLookupGroups(String[] stringArray) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "setLookupGroups");
        }
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not change groups");
        }
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "setLookupGroups");
        }
    }

    public LookupLocator[] getLookupLocators() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getLookupLocators");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getLookupLocators");
        }
        return ((DiscoveryLocatorManagement)((Object)this.dm)).getLocators();
    }

    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "addLookupLocators");
        }
        this.prepareLocators(lookupLocatorArray);
        ((DiscoveryLocatorManagement)((Object)this.dm)).addLocators(lookupLocatorArray);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "addLookupLocators");
        }
    }

    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "removeLookupLocators");
        }
        this.prepareLocators(lookupLocatorArray);
        ((DiscoveryLocatorManagement)((Object)this.dm)).removeLocators(lookupLocatorArray);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "removeLookupLocators");
        }
    }

    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "setLookupLocators");
        }
        this.prepareLocators(lookupLocatorArray);
        ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(lookupLocatorArray);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "setLookupLocators");
        }
    }

    private void prepareLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "prepareLocators");
        }
        for (int i = 0; i < lookupLocatorArray.length; ++i) {
            lookupLocatorArray[i] = (LookupLocator)this.lookupLocatorPreparer.prepareProxy((Object)lookupLocatorArray[i]);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "prepareLocators");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (this.log != null) {
            ReliableLog reliableLog = this.log;
            synchronized (reliableLog) {
                try {
                    this.log.snapshot();
                }
                catch (IOException iOException) {
                    if (persistenceLogger.isLoggable(Level.WARNING)) {
                        persistenceLogger.log(Level.WARNING, "Failed to persist join state", iOException);
                    }
                    throw new RuntimeException("Problem persisting state.", iOException);
                }
            }
        }
    }

    private static void writeAttributes(Entry[] entryArray, ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(entryArray.length);
        for (int i = 0; i < entryArray.length; ++i) {
            objectOutput.writeObject(new MarshalledObject<Entry>(entryArray[i]));
        }
    }

    private static Entry[] readAttributes(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        LinkedList linkedList = new LinkedList();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            try {
                MarshalledObject marshalledObject = (MarshalledObject)objectInput.readObject();
                linkedList.add(marshalledObject.get());
                continue;
            }
            catch (IOException iOException) {
                if (!initlogger.isLoggable(Levels.HANDLED)) continue;
                initlogger.log(Levels.HANDLED, "Exception getting service attribute ... skipping", iOException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!initlogger.isLoggable(Levels.HANDLED)) continue;
                initlogger.log(Levels.HANDLED, "Exception getting service attribute ... skipping", classNotFoundException);
            }
        }
        return linkedList.toArray(new Entry[0]);
    }

    public void snapshot(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this.serviceUuid);
        JoinStateManager.writeAttributes(this.mgr.getAttributes(), objectOutputStream);
        objectOutputStream.writeObject(((DiscoveryLocatorManagement)((Object)this.dm)).getLocators());
        objectOutputStream.writeObject(((DiscoveryGroupManagement)((Object)this.dm)).getGroups());
        objectOutputStream.flush();
    }

    public void recover(InputStream inputStream) throws Exception {
        this.initial = false;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.serviceUuid = (Uuid)objectInputStream.readObject();
        this.attributes = JoinStateManager.readAttributes(objectInputStream);
        this.locators = (LookupLocator[])objectInputStream.readObject();
        this.groups = (String[])objectInputStream.readObject();
    }

    public void applyUpdate(Object object) throws Exception {
        throw new UnsupportedOperationException("JoinStateManager:Updating log, this should not happen");
    }
}

