/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.CacheManager;
import ice.net.Connection;
import ice.util.ICEException;
import ice.util.memory.MemoryManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class CachedInputStream
extends InputStream {
    private CacheManager OEAB;
    private Connection addCache;
    private byte[] arraycopy;
    private int canAllocate;
    private int close;
    protected byte[] cache;
    private int getInstance;
    private int getMaxCacheable;
    private HttpURLConnection isCacheOn;
    private boolean read = false;
    private boolean submit = false;
    private int submitToCache = 0;
    private int I = 4096;
    private Object Z = null;
    private Object C = null;
    private Object B = null;
    private int D = 4096;
    private int F = 0;
    private boolean J = false;

    public CachedInputStream(HttpURLConnection httpURLConnection, CacheManager cacheManager, Connection connection, byte[] byArray, int n, int n2) {
        MemoryManager memoryManager = MemoryManager.getInstance();
        this.Z = new Object();
        this.C = new Object();
        this.B = new Object();
        this.OEAB = cacheManager;
        this.addCache = connection;
        this.isCacheOn = httpURLConnection;
        if (byArray == null) {
            byArray = new byte[n2];
        }
        this.arraycopy = n2 > 0 ? new byte[n2] : new byte[this.D];
        System.arraycopy(byArray, n, this.arraycopy, 0, n2);
        this.canAllocate = 0;
        this.close = n2;
        if (this.OEAB != null) {
            this.submit = this.OEAB.isCacheOn();
            this.submitToCache = this.OEAB.getMaxCacheable(this.isCacheOn);
        } else {
            this.submit = false;
            this.submitToCache = 0;
        }
    }

    void markDone() {
        this.read = true;
    }

    protected void submitToCache() throws ICEException {
        if (!this.submit) {
            return;
        }
        Object object = this.C;
        synchronized (object) {
            if (!this.J && this.OEAB != null) {
                MemoryManager memoryManager = MemoryManager.getInstance();
                if (!memoryManager.canAllocate(this.getMaxCacheable)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                byte[] byArray = null;
                try {
                    byArray = new byte[this.getMaxCacheable];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                if (this.cache != null) {
                    System.arraycopy(this.cache, 0, byArray, 0, this.getMaxCacheable);
                    this.OEAB.submit(byArray, this.isCacheOn);
                    this.J = true;
                }
            }
        }
    }

    protected void addCache(byte[] byArray, int n, int n2) throws ICEException {
        Object object;
        if (!this.submit) {
            return;
        }
        if (this.getMaxCacheable >= this.submitToCache) {
            this.submit = false;
            return;
        }
        if (this.cache == null) {
            object = MemoryManager.getInstance();
            if (!object.canAllocate(this.I)) {
                throw new ICEException(2, 3, 2);
            }
            this.cache = new byte[this.I];
            this.getInstance = 0;
            this.getMaxCacheable = 0;
        }
        if (this.cache.length - (this.getInstance + 1) < n2) {
            object = null;
            int n3 = this.cache.length - this.getInstance;
            MemoryManager memoryManager = MemoryManager.getInstance();
            if (n2 > this.cache.length + n3) {
                if (!memoryManager.canAllocate(this.cache.length + n2)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                object = new byte[this.cache.length + n2];
            } else {
                if (!memoryManager.canAllocate(this.cache.length * 2)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                try {
                    object = new byte[this.cache.length * 2];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
            }
            System.arraycopy(this.cache, 0, object, 0, this.getInstance);
            this.cache = null;
            this.cache = (byte[])object;
        }
        System.arraycopy(byArray, n, this.cache, this.getInstance, n2);
        this.getInstance += n2;
        this.getMaxCacheable += n2;
    }

    protected void addCache(byte by) throws ICEException {
        if (!this.submit) {
            return;
        }
        if (this.getMaxCacheable >= this.submitToCache) {
            this.submit = false;
            return;
        }
        try {
            MemoryManager memoryManager;
            if (this.cache == null) {
                memoryManager = MemoryManager.getInstance();
                if (!memoryManager.canAllocate(4000)) {
                    throw new ICEException(2, 3, 2);
                }
                this.cache = new byte[4000];
                this.getInstance = 0;
                this.getMaxCacheable = 0;
            }
            if (this.cache.length - this.getInstance > 0) {
                this.cache[this.getInstance] = by;
                ++this.getInstance;
                ++this.getMaxCacheable;
            } else {
                memoryManager = MemoryManager.getInstance();
                if (!memoryManager.canAllocate(this.cache.length * 2)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                byte[] byArray = new byte[this.cache.length * 2];
                System.arraycopy(this.cache, 0, byArray, 0, this.getInstance);
                this.cache = null;
                this.cache = byArray;
                this.cache[this.getInstance] = by;
                ++this.getInstance;
                ++this.getMaxCacheable;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.cache = null;
            throw new OutOfMemoryError();
        }
    }

    public int available() throws IOException {
        if (this.arraycopy != null && this.close > 0) {
            return this.close;
        }
        if (this.F >= 4) {
            int n;
            if (this.arraycopy == null) {
                this.arraycopy = new byte[8192];
            }
            if ((n = this.addCache.read(this.arraycopy, 0, this.arraycopy.length)) > 0) {
                this.close = n;
                return n;
            }
        } else {
            ++this.F;
        }
        return 0;
    }

    public void close() throws IOException {
        this.submitToCache();
        Object object = this.B;
        synchronized (object) {
            this.arraycopy = null;
            this.addCache.close();
            this.isCacheOn = null;
            this.OEAB = null;
        }
    }

    public int read() throws IOException {
        Object object = this.Z;
        synchronized (object) {
            int n;
            if (this.close > 0) {
                int n2 = this.canAllocate++;
                this.addCache(this.arraycopy[n2]);
                if (--this.close == 0) {
                    this.canAllocate = 0;
                }
                int n3 = this.arraycopy[n2] & 0xFF;
                return n3;
            }
            this.canAllocate = 0;
            this.close = 0;
            if (this.read) {
                this.submitToCache();
                int n4 = -1;
                return n4;
            }
            if (this.arraycopy == null) {
                this.arraycopy = new byte[this.D];
            }
            if (this.arraycopy.length == 0) {
                this.arraycopy = new byte[this.D];
            }
            if ((n = this.addCache.read(this.arraycopy, 0, this.arraycopy.length)) > 0) {
                this.close = n;
                ++this.canAllocate;
                --this.close;
                this.addCache(this.arraycopy[this.canAllocate - 1]);
                int n5 = this.arraycopy[this.canAllocate - 1] & 0xFF;
                return n5;
            }
            this.submitToCache();
            int n6 = -1;
            return n6;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.read && this.arraycopy == null) {
            return -1;
        }
        Object object = this.Z;
        synchronized (object) {
            int n3;
            int n4 = 0;
            if (this.close >= n2) {
                boolean bl = this.close == n2;
                System.arraycopy(this.arraycopy, this.canAllocate, byArray, n, n2);
                this.addCache(this.arraycopy, this.canAllocate, n2);
                this.canAllocate += n2;
                this.close -= n2;
                if (bl) {
                    this.canAllocate = 0;
                    this.close = 0;
                    this.arraycopy = null;
                }
                int n5 = n2;
                return n5;
            }
            if (this.arraycopy != null && this.close > 0) {
                int n6 = this.close;
                System.arraycopy(this.arraycopy, this.canAllocate, byArray, n, this.close);
                this.addCache(this.arraycopy, this.canAllocate, this.close);
                n += this.close;
                n4 += this.close;
                n2 -= this.close;
                this.canAllocate = 0;
                this.close = 0;
                this.arraycopy = null;
                int n7 = n6;
                return n7;
            }
            if (this.arraycopy == null) {
                this.arraycopy = new byte[this.D];
            }
            if (this.arraycopy.length == 0) {
                this.arraycopy = new byte[this.D];
            }
            if ((n3 = this.addCache.read(this.arraycopy, 0, this.arraycopy.length)) <= 0) {
                this.submitToCache();
                int n8 = -1;
                return n8;
            }
            this.close += n3;
            if (this.close > n2) {
                System.arraycopy(this.arraycopy, this.canAllocate, byArray, n, n2);
                this.addCache(this.arraycopy, this.canAllocate, n2);
                this.canAllocate += n2;
                this.close -= n2;
                int n9 = n2;
                return n9;
            }
            int n10 = this.close;
            System.arraycopy(this.arraycopy, this.canAllocate, byArray, n, this.close);
            this.addCache(this.arraycopy, this.canAllocate, this.close);
            n += this.close;
            n4 += this.close;
            n2 -= this.close;
            this.canAllocate = 0;
            this.close = 0;
            this.arraycopy = null;
            int n11 = n10;
            return n11;
        }
    }
}

