% MATLAB Multimedia Reader Object.
%
% Multimedia Reader Functions and Properties.
%
% Multimedia reader object construction.
%   mmreader      - Construct mmreader object.
%
% Getting and setting parameters.
%   get           - Get value of mmreader object property.
%   set           - Set value of mmreader object property.
%
% General.
%   clear         - Remove mmreader object from memory.
%   display       - Display method for mmreader objects.
%
% Multimedia reader methods.
%   read          - Reads audio samples and/or video frames into the 
%                   workspace.
%
% Multimedia reader properties.
%
%   Duration         - Total length of file in seconds. 
%   Name             - Name of the file to be read.
%   Path             - Path of the file to be read.
%   Tag              - Generic string for the user to set.
%   Type             - Classname of the object.
%   UserData         - Generic field for any user-defined data.
%
%   BitsPerPixel     - Bits per pixel of the video data.
%   FrameRate        - Frame rate of the video in frames per second.
%   Height           - Height of the video frame in pixels.
%   NumberOfFrames   - Total number of frames in the video stream.  
%   VideoFormat      - Video format as it is represented in MATLAB.
%   Width            - Width of the video frame in pixels.
%
%
% See also MMFILEINFO.

%   JCS
%   Copyright 2004-2008 The MathWorks, Inc.
%   $Revision: 1.1.6.2 $  $Date: 2008/10/08 17:14:08 $
