/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.wsclients.cloudconsole;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.mlwebservices.ws_client_core.DefaultMathWorksWebServiceClientConfigurator;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.wsclients.ClientErrorException;
import com.mathworks.toolbox.distcomp.wsclients.Log;
import com.mathworks.toolbox.distcomp.wsclients.ServiceErrorPassThroughException;
import com.mathworks.toolbox.distcomp.wsclients.WSAuthenticationFailureException;
import com.mathworks.toolbox.distcomp.wsclients.WSProxyAuthenticationRequiredException;
import com.mathworks.toolbox.distcomp.wsclients.WSServiceNotFoundException;
import com.mathworks.toolbox.distcomp.wsclients.WSServiceUnavailableException;
import com.mathworks.toolbox.distcomp.wsclients.WebServiceException;
import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.CloudConsoleClusterDetails;
import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.CloudConsoleClusterInfo;
import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.MJSCloudConsoleClient;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.ProxyAuthenticationRequiredException;
import com.mathworks.webservices.client.core.ServiceNotFoundException;
import com.mathworks.webservices.client.core.ServiceUnavailableException;
import com.mathworks.webservices.clients.cloudconsole.CloudConsoleClient;
import com.mathworks.webservices.clients.cloudconsole.ClusterDetailsRequest;
import com.mathworks.webservices.clients.cloudconsole.ClusterDetailsResponse;
import com.mathworks.webservices.clients.cloudconsole.ClusterInfo;
import com.mathworks.webservices.clients.cloudconsole.DiscoverClustersRequest;
import com.mathworks.webservices.clients.cloudconsole.DiscoverClustersResponse;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class MJSCloudConsoleClientImpl
implements MJSCloudConsoleClient {
    private final CloudConsoleClient fCloudConsoleClient;
    private static final String LOCALE = Locale.getDefault().toString();
    private static final String SERVICE_ENDPOINT = WSEndPoints.getCloudConsoleEndPoint();
    private AtomicReference<WebServiceException> fStashedException = new AtomicReference<Object>(null);
    private static final String PCT_CLIENT_PREFIX = "MDPCT";
    private static final String PCT_CLIENT_STRING = "MDPCT-" + InstutilResourceKeys.RELEASE.getString(new Object[0]);

    public MJSCloudConsoleClientImpl() {
        DefaultMathWorksWebServiceClientConfigurator defaultMathWorksWebServiceClientConfigurator = new DefaultMathWorksWebServiceClientConfigurator(SERVICE_ENDPOINT);
        this.fCloudConsoleClient = new CloudConsoleClient(SERVICE_ENDPOINT);
        defaultMathWorksWebServiceClientConfigurator.configureClient((MathWorksWebServiceClient)this.fCloudConsoleClient);
    }

    private void resetStashedException() {
        this.fStashedException.set(null);
    }

    private void setStashedException(WebServiceException webServiceException) {
        this.fStashedException.compareAndSet(null, webServiceException);
    }

    @Override
    public WebServiceException getStashedException() {
        return this.fStashedException.get();
    }

    @Override
    public CloudConsoleClusterInfo[] discoverMyClusters(String string) throws WebServiceException {
        DiscoverClustersRequest discoverClustersRequest = new DiscoverClustersRequest();
        discoverClustersRequest.setToken(string);
        discoverClustersRequest.setClientString(PCT_CLIENT_STRING);
        discoverClustersRequest.setLocale(LOCALE);
        DiscoverClustersResponse discoverClustersResponse = this.makeDiscoverClustersCallToCloudConsole(discoverClustersRequest);
        if (discoverClustersResponse != null) {
            CloudConsoleClusterInfo[] cloudConsoleClusterInfoArray = new CloudConsoleClusterInfo[discoverClustersResponse.getClusterList().size()];
            int n = 0;
            for (ClusterInfo clusterInfo : discoverClustersResponse.getClusterList()) {
                cloudConsoleClusterInfoArray[n++] = new CloudConsoleClusterInfo(clusterInfo.getId(), clusterInfo.getSSLCertificate(), clusterInfo.getName(), clusterInfo.getHeadNodeDNSName(), clusterInfo.getPeerLookupUri(), clusterInfo.getState(), clusterInfo.getRelease(), clusterInfo.getWorkerCount());
            }
            return cloudConsoleClusterInfoArray;
        }
        return new CloudConsoleClusterInfo[0];
    }

    @Override
    public CloudConsoleClusterDetails getClusterDetails(String string, String string2) throws WebServiceException {
        ClusterDetailsRequest clusterDetailsRequest = new ClusterDetailsRequest();
        clusterDetailsRequest.setClusterId(string);
        clusterDetailsRequest.setToken(string2);
        clusterDetailsRequest.setLocale(LOCALE);
        clusterDetailsRequest.setClientString(PCT_CLIENT_STRING);
        ClusterDetailsResponse clusterDetailsResponse = this.makeGetClusterDetailsCallToCloudConsole(clusterDetailsRequest);
        return new CloudConsoleClusterDetails(clusterDetailsResponse.getName(), clusterDetailsResponse.getHeadNodeDNSName(), clusterDetailsResponse.getPeerLookupUri(), clusterDetailsResponse.getState(), clusterDetailsResponse.getRelease(), clusterDetailsResponse.getWorkerCount());
    }

    private DiscoverClustersResponse makeDiscoverClustersCallToCloudConsole(DiscoverClustersRequest discoverClustersRequest) throws WebServiceException {
        DiscoverClustersResponse discoverClustersResponse;
        this.resetStashedException();
        try {
            discoverClustersResponse = this.fCloudConsoleClient.discoverMyCloudClusters(discoverClustersRequest);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            WSServiceNotFoundException wSServiceNotFoundException = new WSServiceNotFoundException(serviceNotFoundException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to discover clusters from cloud console because it could not be found.", serviceNotFoundException);
            this.setStashedException(wSServiceNotFoundException);
            throw wSServiceNotFoundException;
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            WSServiceUnavailableException wSServiceUnavailableException = new WSServiceUnavailableException(serviceUnavailableException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to discover clusters from cloud console because it was unavailable", serviceUnavailableException);
            this.setStashedException(wSServiceUnavailableException);
            throw wSServiceUnavailableException;
        }
        catch (ProxyAuthenticationRequiredException proxyAuthenticationRequiredException) {
            WSProxyAuthenticationRequiredException wSProxyAuthenticationRequiredException = new WSProxyAuthenticationRequiredException(proxyAuthenticationRequiredException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to discover clusters because of a proxy authentication failure", proxyAuthenticationRequiredException);
            this.setStashedException(wSProxyAuthenticationRequiredException);
            throw wSProxyAuthenticationRequiredException;
        }
        catch (MathWorksServiceException mathWorksServiceException) {
            int n = mathWorksServiceException.getStatusCode();
            if (n == 401) {
                WSAuthenticationFailureException wSAuthenticationFailureException = new WSAuthenticationFailureException(mathWorksServiceException);
                String string = String.format("Failed to discover clusters due to an authentication failure.Status code %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
                Log.LOGGER.log(DistcompLevel.TWO, string, mathWorksServiceException);
                this.setStashedException(wSAuthenticationFailureException);
                throw wSAuthenticationFailureException;
            }
            ServiceErrorPassThroughException serviceErrorPassThroughException = new ServiceErrorPassThroughException(mathWorksServiceException);
            String string = String.format("Failed to discover clusters. Status code: %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
            Log.LOGGER.log(DistcompLevel.ONE, string, mathWorksServiceException);
            this.setStashedException(serviceErrorPassThroughException);
            throw serviceErrorPassThroughException;
        }
        catch (MathWorksClientException mathWorksClientException) {
            ClientErrorException clientErrorException = new ClientErrorException(mathWorksClientException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to discover clusters because of a client error.", mathWorksClientException);
            this.setStashedException(clientErrorException);
            throw clientErrorException;
        }
        return discoverClustersResponse;
    }

    private ClusterDetailsResponse makeGetClusterDetailsCallToCloudConsole(ClusterDetailsRequest clusterDetailsRequest) throws WebServiceException {
        ClusterDetailsResponse clusterDetailsResponse;
        this.resetStashedException();
        try {
            clusterDetailsResponse = this.fCloudConsoleClient.getClusterDetails(clusterDetailsRequest);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            WSServiceNotFoundException wSServiceNotFoundException = new WSServiceNotFoundException(serviceNotFoundException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to get cluster details from cloud console because it could not be found.", serviceNotFoundException);
            this.setStashedException(wSServiceNotFoundException);
            throw wSServiceNotFoundException;
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            WSServiceUnavailableException wSServiceUnavailableException = new WSServiceUnavailableException(serviceUnavailableException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to get cluster details from cloud console because it was unavailable", serviceUnavailableException);
            this.setStashedException(wSServiceUnavailableException);
            throw wSServiceUnavailableException;
        }
        catch (ProxyAuthenticationRequiredException proxyAuthenticationRequiredException) {
            WSProxyAuthenticationRequiredException wSProxyAuthenticationRequiredException = new WSProxyAuthenticationRequiredException(proxyAuthenticationRequiredException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to get cluster details because of a proxy authentication failure", proxyAuthenticationRequiredException);
            this.setStashedException(wSProxyAuthenticationRequiredException);
            throw wSProxyAuthenticationRequiredException;
        }
        catch (MathWorksServiceException mathWorksServiceException) {
            int n = mathWorksServiceException.getStatusCode();
            if (n == 401) {
                WSAuthenticationFailureException wSAuthenticationFailureException = new WSAuthenticationFailureException(mathWorksServiceException);
                String string = String.format("Failed to get cluster details due to an authentication failure.Status code %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
                Log.LOGGER.log(DistcompLevel.TWO, string, mathWorksServiceException);
                this.setStashedException(wSAuthenticationFailureException);
                throw wSAuthenticationFailureException;
            }
            ServiceErrorPassThroughException serviceErrorPassThroughException = new ServiceErrorPassThroughException(mathWorksServiceException);
            String string = String.format("Failed to get cluster details. Status code: %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
            Log.LOGGER.log(DistcompLevel.ONE, string, mathWorksServiceException);
            this.setStashedException(serviceErrorPassThroughException);
            throw serviceErrorPassThroughException;
        }
        catch (MathWorksClientException mathWorksClientException) {
            ClientErrorException clientErrorException = new ClientErrorException(mathWorksClientException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to get cluster details because of a client error.", mathWorksClientException);
            this.setStashedException(clientErrorException);
            throw clientErrorException;
        }
        return clusterDetailsResponse;
    }
}

