/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.security;

import com.mathworks.toolbox.distcomp.util.security.FatalSecurityException;
import com.mathworks.toolbox.distcomp.util.security.KeyStoreFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class SSLContextFactory {
    private static final String TRUST_MANAGER_ALGORITHM = "SunX509";
    private static final String PROTOCOL = "TLS";

    public SSLContext createServerSSLContext(KeyStore keyStore, char[] cArray) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(TRUST_MANAGER_ALGORITHM);
            keyManagerFactory.init(keyStore, cArray);
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagerArray = null;
            SecureRandom secureRandom = null;
            SSLContext sSLContext = SSLContext.getInstance(PROTOCOL);
            sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
            return sSLContext;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FatalSecurityException("Failed to create server SSL context", generalSecurityException);
        }
    }

    public SSLContext createClientSSLContext(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TRUST_MANAGER_ALGORITHM);
            trustManagerFactory.init(keyStore);
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            SecureRandom secureRandom = null;
            SSLContext sSLContext = SSLContext.getInstance(PROTOCOL);
            sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
            return sSLContext;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FatalSecurityException("Failed to create client SSL context", generalSecurityException);
        }
    }

    public SSLContext createClientSSLContext(Certificate certificate) {
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        KeyStore keyStore = keyStoreFactory.createKeyStore();
        try {
            keyStore.setCertificateEntry("Certificate", certificate);
        }
        catch (KeyStoreException keyStoreException) {
            throw new FatalSecurityException("Failed to set certificate entry in trust store", keyStoreException);
        }
        return this.createClientSSLContext(keyStore);
    }
}

