/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.security;

import com.mathworks.toolbox.distcomp.util.security.FatalSecurityException;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;

public final class KeyStoreFactory {
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String KEY_TYPE = "DSA";
    private static final String SIG_ALG = "SHA1withDSA";
    private static final int KEY_BITS = 1024;

    public KeyStore createKeyStore() {
        KeyStore keyStore = this.getKeyStoreInstance();
        try {
            keyStore.load(null);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("KeyStore.load(null) threw an IOException. This should never happen since we aren't actually loading anything.", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FatalSecurityException(generalSecurityException);
        }
        return keyStore;
    }

    public KeyStore createKeyStore(String string, char[] cArray) throws IOException {
        KeyStore keyStore = this.getKeyStoreInstance();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, cArray);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FatalSecurityException(generalSecurityException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private KeyStore getKeyStoreInstance() {
        try {
            return KeyStore.getInstance(KEYSTORE_TYPE);
        }
        catch (KeyStoreException keyStoreException) {
            throw new FatalSecurityException(keyStoreException);
        }
    }

    public KeyStore createKeyStore(String string, char[] cArray, String string2, int n) throws IOException {
        try {
            CertAndKeyGen certAndKeyGen = new CertAndKeyGen(KEY_TYPE, SIG_ALG);
            certAndKeyGen.generate(1024);
            PrivateKey privateKey = certAndKeyGen.getPrivateKey();
            long l = TimeUnit.SECONDS.convert(n, TimeUnit.DAYS);
            X509Certificate x509Certificate = certAndKeyGen.getSelfCertificate(new X500Name(string2), l);
            KeyStore keyStore = this.createKeyStore();
            Certificate[] certificateArray = new Certificate[]{x509Certificate};
            keyStore.setKeyEntry(string, privateKey, cArray, certificateArray);
            return keyStore;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FatalSecurityException(generalSecurityException);
        }
    }
}

