/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.concurrent;

import com.mathworks.toolbox.distcomp.PackageInfo;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger fCounter = new AtomicInteger(0);
    private final String fPrefix;
    private final LoggingUncaughtExceptionHandler fExceptionHandler;

    public NamedThreadFactory(String string) {
        this.fPrefix = string;
        this.fExceptionHandler = new LoggingUncaughtExceptionHandler(PackageInfo.LOGGER);
    }

    public NamedThreadFactory(String string, Logger logger) {
        this.fPrefix = string;
        this.fExceptionHandler = new LoggingUncaughtExceptionHandler(logger);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String string = this.fPrefix + this.fCounter.getAndIncrement();
        Thread thread = new Thread(runnable, string);
        thread.setUncaughtExceptionHandler(this.fExceptionHandler);
        return thread;
    }

    private static class LoggingUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Logger fLogger;

        LoggingUncaughtExceptionHandler(Logger logger) {
            this.fLogger = logger;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            this.fLogger.log(Level.SEVERE, "Thread: " + thread.getName() + ", terminated with " + throwable.toString() + ":", throwable);
        }
    }
}

