/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.DefaultOverlayable;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;

public abstract class ConfigurablePropertyView
extends StyleGuideRelatedPanel
implements PropertyChangeListener,
Destroyable {
    private Property fProperty;
    private JComponent fComponent;
    protected static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    private static final Insets OVERLAY_INSETS = new Insets(0, -5, 0, 0);

    public ConfigurablePropertyView(Property property, JComponent jComponent, String string, boolean bl) {
        assert (property.getPropertyInfo().isConfigurable()) : "The property is not configurable.";
        this.fProperty = property;
        this.fComponent = jComponent;
        JComponent jComponent2 = bl ? this.addUseDefaultOverlayDecorator(string) : this.fComponent;
        this.updateUI(this.fComponent, this.fProperty.getValue());
        this.fProperty.addPropertyChangeListener(this);
        this.addLine(jComponent2, 8);
        this.addDefaultValueDecoratorToComponent();
        this.fComponent.setName(string);
    }

    abstract void updateUI(JComponent var1, Object var2);

    abstract void commitEdit();

    public final Property getProperty() {
        return this.fProperty;
    }

    protected JComponent getActualComponent() {
        return this.fComponent;
    }

    private void addDefaultValueDecoratorToComponent() {
        if (this.fProperty.getPropertyInfo().hasDefaultString()) {
            MJLabel mJLabel = new MJLabel(MessageFormat.format(sRes.getString("configurableview.decorator.defaultlabel"), this.getProperty().getPropertyInfo().getDefaultString()));
            this.addLine((JComponent)mJLabel);
        }
    }

    JComponent addUseDefaultOverlayDecorator(String string) {
        if (!this.fProperty.getPropertyInfo().hasDefaultString()) {
            return this.fComponent;
        }
        MJLabel mJLabel = new MJLabel(sRes.getString("configurableview.common.usedefaultlabel"));
        Color color = UIDefaultsLookup.getColor((Object)"Label.disabledForeground");
        if (color == null) {
            color = Color.GRAY;
        }
        mJLabel.setForeground(color);
        mJLabel.setName(string + ".OverlayableLabel");
        final DefaultOverlayable defaultOverlayable = new DefaultOverlayable(this.fComponent, (JComponent)mJLabel, 7);
        defaultOverlayable.setOpaque(false);
        defaultOverlayable.setOverlayLocationInsets(OVERLAY_INSETS);
        this.fComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ConfigurablePropertyView.this.updateOverlayVisibility(defaultOverlayable);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ConfigurablePropertyView.this.updateOverlayVisibility(defaultOverlayable);
            }
        });
        mJLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigurablePropertyView.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ConfigurablePropertyView.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ConfigurablePropertyView.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ConfigurablePropertyView.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ConfigurablePropertyView.this.redispatchMouseEvent(mouseEvent);
            }
        });
        this.fProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ConfigurablePropertyView.this.updateOverlayVisibility(defaultOverlayable);
                    }
                });
            }
        });
        this.updateOverlayVisibility(defaultOverlayable);
        return defaultOverlayable;
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent) {
        this.fComponent.dispatchEvent(new MouseEvent(this.fComponent, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    private void updateOverlayVisibility(DefaultOverlayable defaultOverlayable) {
        if (this.fComponent.hasFocus()) {
            defaultOverlayable.setOverlayVisible(false);
        } else {
            defaultOverlayable.setOverlayVisible(this.fProperty.isDefaultValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        final Object object = propertyChangeEvent.getNewValue();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ConfigurablePropertyView.this.updateUI(ConfigurablePropertyView.this.fComponent, object);
            }
        });
    }

    @Override
    public void destroy() {
        this.fProperty.removePropertyChangeListener(this);
    }
}

