/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.Log;
import com.mathworks.toolbox.distcomp.storage.fileblobs.RandomAccessFilePoolException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.Semaphore;

public class RandomAccessFilePool {
    private Semaphore fFileHandles;

    public RandomAccessFilePool(int n) {
        this.fFileHandles = new Semaphore(n, true);
    }

    public RandomAccessFile getFile(File file) throws RandomAccessFilePoolException {
        RandomAccessFile randomAccessFile;
        this.fFileHandles.acquireUninterruptibly();
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fFileHandles.release();
            throw new RandomAccessFilePoolException("Unable to create a new RandomAccessFile", fileNotFoundException);
        }
        return randomAccessFile;
    }

    public void returnFile(RandomAccessFile randomAccessFile) {
        this.closeRandomAccessFile(randomAccessFile);
        this.fFileHandles.release();
    }

    private void closeRandomAccessFile(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.warning("Failed to close random access file: " + iOException.getMessage());
        }
    }
}

