/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.storage.Cache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class LRUCache<K, V>
implements Cache<K, V> {
    private static final float sLOAD_FACTOR = 0.75f;
    private final ReferenceQueue<V> fDeadReferenceQueue = new ReferenceQueue();
    private final Map<K, CacheReference<K, V>> fMap;
    private CacheReference<K, V> fHead = null;
    private CacheReference<K, V> fTail = null;
    private final int fMaxActiveCacheSize;
    private int fActiveCacheSize = 0;
    private final ReentrantLock fLock = new ReentrantLock();

    public LRUCache(int n) {
        this.fMap = new HashMap<K, CacheReference<K, V>>(n, 0.75f);
        this.fMaxActiveCacheSize = n;
    }

    @Override
    public void lock() {
        this.fLock.lock();
    }

    @Override
    public void unlock() {
        this.fLock.unlock();
    }

    @Override
    public V put(K k, V v) {
        assert (k != null) : "Cannot put a value in the cache with a null key";
        assert (v != null) : "Cannot put a null value in the cache";
        if (!this.fLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Lock must be held by current thread to access the cache");
        }
        this.expungeStaleValues();
        CacheReference<K, V> cacheReference = new CacheReference<K, V>(k, v, this.fDeadReferenceQueue);
        this.insertAtActiveCacheHead(cacheReference);
        return this.returnValueAfterClearingRef(this.fMap.put(k, cacheReference));
    }

    @Override
    public V get(K k) {
        if (!this.fLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Lock must be held by current thread to access the cache");
        }
        this.expungeStaleValues();
        return this.returnValueAfterRefreshingCache(this.fMap.get(k));
    }

    @Override
    public V remove(K k) {
        if (!this.fLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Lock must be held by current thread to access the cache");
        }
        this.expungeStaleValues();
        return this.returnValueAfterClearingRef(this.fMap.remove(k));
    }

    @Override
    public List<V> removeAll() {
        if (!this.fLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Lock must be held by current thread to access the cache");
        }
        this.expungeStaleValues();
        ArrayList<V> arrayList = new ArrayList<V>(this.fMap.size());
        for (K k : this.fMap.keySet()) {
            arrayList.add(this.returnValueAfterClearingRef(this.fMap.remove(k)));
        }
        return arrayList;
    }

    @Override
    public void clear() {
        if (!this.fLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Lock must be held by current thread to access the cache");
        }
        for (CacheReference<K, V> cacheReference : this.fMap.values()) {
            cacheReference.clear();
        }
        this.fMap.clear();
        this.fHead = null;
        this.fTail = null;
    }

    @Override
    public int size() {
        if (!this.fLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Lock must be held by current thread to access the cache");
        }
        this.expungeStaleValues();
        return this.fMap.size();
    }

    private V returnValueAfterClearingRef(CacheReference<K, V> cacheReference) {
        if (cacheReference == null) {
            return null;
        }
        this.removeFromActiveCache(cacheReference);
        Object t = cacheReference.get();
        cacheReference.clear();
        return (V)t;
    }

    private V returnValueAfterRefreshingCache(CacheReference<K, V> cacheReference) {
        if (cacheReference == null) {
            return null;
        }
        Object t = cacheReference.get();
        if (t == null) {
            return null;
        }
        if (cacheReference.isInActiveCache()) {
            this.moveToActiveCacheHead(cacheReference);
        } else {
            cacheReference.refreshSoftReference(t);
            this.insertAtActiveCacheHead(cacheReference);
        }
        return (V)t;
    }

    private void expungeStaleValues() {
        CacheReference cacheReference;
        while ((cacheReference = (CacheReference)this.fDeadReferenceQueue.poll()) != null) {
            this.fMap.remove(cacheReference.getKey());
            this.removeFromActiveCache(cacheReference);
        }
    }

    private void moveToActiveCacheHead(CacheReference<K, V> cacheReference) {
        if (cacheReference.equals(this.fHead)) {
            return;
        }
        if (cacheReference.equals(this.fTail)) {
            this.fTail = cacheReference.previous();
        }
        cacheReference.moveBefore(this.fHead);
        this.fHead = cacheReference;
    }

    private void insertAtActiveCacheHead(CacheReference<K, V> cacheReference) {
        cacheReference.insertBefore(this.fHead);
        this.fHead = cacheReference;
        if (this.fTail == null) {
            this.fTail = cacheReference;
        }
        if (this.fActiveCacheSize >= this.fMaxActiveCacheSize) {
            this.fTail.releaseSoftReference();
            this.fTail = this.fTail.detach();
        } else {
            ++this.fActiveCacheSize;
        }
    }

    private void removeFromActiveCache(CacheReference<K, V> cacheReference) {
        if (cacheReference.isInActiveCache()) {
            if (cacheReference.equals(this.fHead)) {
                this.fHead = cacheReference.next();
            }
            if (cacheReference.equals(this.fTail)) {
                this.fTail = cacheReference.previous();
            }
            cacheReference.detach();
            --this.fActiveCacheSize;
        }
    }

    private static final class CacheReference<K, V>
    extends WeakReference<V> {
        private final K fKey;
        private SoftReference<V> fSoftReference;
        private CacheReference<K, V> fPrevious = null;
        private CacheReference<K, V> fNext = null;
        private boolean fInActiveCache = false;

        CacheReference(K k, V v, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.fKey = k;
            this.fSoftReference = new SoftReference<V>(v);
        }

        K getKey() {
            return this.fKey;
        }

        void releaseSoftReference() {
            this.fSoftReference.clear();
        }

        CacheReference<K, V> previous() {
            return this.fPrevious;
        }

        CacheReference<K, V> next() {
            return this.fNext;
        }

        public void refreshSoftReference(V v) {
            if (this.fSoftReference.get() == null) {
                this.fSoftReference = new SoftReference<V>(v);
            }
        }

        public CacheReference<K, V> detach() {
            CacheReference<K, V> cacheReference = this.fPrevious;
            if (this.fPrevious != null) {
                this.fPrevious.fNext = this.fNext;
            }
            if (this.fNext != null) {
                this.fNext.fPrevious = this.fPrevious;
            }
            this.fPrevious = null;
            this.fNext = null;
            this.fInActiveCache = false;
            return cacheReference;
        }

        public void moveBefore(CacheReference<K, V> cacheReference) {
            assert (cacheReference != null) : "Cannot move before null in the active cache";
            assert (this.fInActiveCache) : "Cannot move reference if not on the active cache";
            if (this.fPrevious != null) {
                this.fPrevious.fNext = this.fNext;
            }
            if (this.fNext != null) {
                this.fNext.fPrevious = this.fPrevious;
            }
            this.fNext = cacheReference;
            this.fPrevious = cacheReference.fPrevious;
            this.fNext.fPrevious = this;
            if (this.fPrevious != null) {
                this.fPrevious.fNext = this;
            }
        }

        public void insertBefore(CacheReference<K, V> cacheReference) {
            assert (!this.fInActiveCache) : "Can only insert if not already in the active cache";
            this.fNext = cacheReference;
            if (cacheReference != null) {
                this.fPrevious = cacheReference.fPrevious;
                this.fNext.fPrevious = this;
                if (this.fPrevious != null) {
                    this.fPrevious.fNext = this;
                }
            }
            this.fInActiveCache = true;
        }

        public boolean isInActiveCache() {
            return this.fInActiveCache;
        }

        @Override
        public void clear() {
            super.clear();
            this.fSoftReference.clear();
        }
    }
}

